/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth.server;

import com.hortonworks.registries.auth.client.AuthenticationException;
import com.hortonworks.registries.auth.server.AuthenticationToken;
import com.hortonworks.registries.auth.server.KerberosAuthenticationHandler;
import com.hortonworks.registries.auth.util.Utils;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AltKerberosAuthenticationHandler
extends KerberosAuthenticationHandler {
    public static final String TYPE = "alt-kerberos";
    public static final String NON_BROWSER_USER_AGENTS = "alt-kerberos.non-browser.user-agents";
    private static final String NON_BROWSER_USER_AGENTS_DEFAULT = "java,curl,wget,perl";
    private String[] nonBrowserUserAgents;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void init(Properties config) throws ServletException {
        super.init(config);
        this.nonBrowserUserAgents = Utils.getNonBrowserUserAgents(config.getProperty(NON_BROWSER_USER_AGENTS, NON_BROWSER_USER_AGENTS_DEFAULT));
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = Utils.isBrowser(this.nonBrowserUserAgents, request) ? this.alternateAuthenticate(request, response) : super.authenticate(request, response);
        return token;
    }

    public abstract AuthenticationToken alternateAuthenticate(HttpServletRequest var1, HttpServletResponse var2) throws IOException, AuthenticationException;
}

