/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.provider.MediaStore;
import com.horses.camera.business.Album;
import com.horses.camera.business.PhotoItem;
import com.horses.camera.ui.application.CameraManager;
import com.horses.camera.utils.FileUtils;
import com.horses.camera.utils.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageUtils {
    public static int getMiniSize(String imagePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        return Math.min(options.outHeight, options.outWidth);
    }

    public static boolean isSquare(String imagePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        return options.outHeight == options.outWidth;
    }

    public static boolean isSquare(Uri imageUri) {
        ContentResolver resolver = CameraManager.getApplication().getContentResolver();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeStream((InputStream)resolver.openInputStream(imageUri), null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return options.outHeight == options.outWidth;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String saveToFile(String fileFolderStr, boolean isDir, Bitmap croppedImage) throws IOException {
        File jpgFile;
        if (isDir) {
            File fileFolder = new File(fileFolderStr);
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            String filename = format.format(date) + ".jpg";
            if (!fileFolder.exists()) {
                FileUtils.getInst().mkdir(fileFolder);
            }
            jpgFile = new File(fileFolder, filename);
        } else {
            jpgFile = new File(fileFolderStr);
            if (!jpgFile.getParentFile().exists()) {
                FileUtils.getInst().mkdir(jpgFile.getParentFile());
            }
        }
        FileOutputStream outputStream = new FileOutputStream(jpgFile);
        croppedImage.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)outputStream);
        IOUtil.closeStream(outputStream);
        return jpgFile.getPath();
    }

    public static Bitmap decodeBitmapWithOrientation(String pathName, int width, int height) {
        return ImageUtils.decodeBitmapWithSize(pathName, width, height, false);
    }

    public static Bitmap decodeBitmapWithOrientationMax(String pathName, int width, int height) {
        return ImageUtils.decodeBitmapWithSize(pathName, width, height, true);
    }

    private static Bitmap decodeBitmapWithSize(String pathName, int width, int height, boolean useBigger) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inInputShareable = true;
        options.inPurgeable = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        int decodeWidth = width;
        int decodeHeight = height;
        int degrees = ImageUtils.getImageDegrees(pathName);
        if (degrees == 90 || degrees == 270) {
            decodeWidth = height;
            decodeHeight = width;
        }
        options.inSampleSize = useBigger ? (int)Math.min((float)options.outWidth / (float)decodeWidth, (float)options.outHeight / (float)decodeHeight) : (int)Math.max((float)options.outWidth / (float)decodeWidth, (float)options.outHeight / (float)decodeHeight);
        options.inJustDecodeBounds = false;
        Bitmap sourceBm = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        return ImageUtils.imageWithFixedRotation(sourceBm, degrees);
    }

    public static int getImageDegrees(String pathName) {
        int degrees = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(pathName);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degrees = 90;
                    break;
                }
                case 3: {
                    degrees = 180;
                    break;
                }
                case 8: {
                    degrees = 270;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return degrees;
    }

    public static Bitmap imageWithFixedRotation(Bitmap bm, int degrees) {
        if (bm == null || bm.isRecycled()) {
            return null;
        }
        if (degrees == 0) {
            return bm;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degrees);
        Bitmap result = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        if (result != bm) {
            bm.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getImageRadio(ContentResolver resolver, Uri fileUri) {
        InputStream inputStream = null;
        try {
            inputStream = resolver.openInputStream(fileUri);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            int initWidth = options.outWidth;
            int initHeight = options.outHeight;
            float f = initHeight > initWidth ? (float)initHeight / (float)initWidth : (float)initWidth / (float)initHeight;
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            float f = 1.0f;
            return f;
        }
        finally {
            IOUtil.closeStream(inputStream);
        }
    }

    public static Bitmap byteToBitmap(byte[] imgByte) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 1;
        ByteArrayInputStream input = new ByteArrayInputStream(imgByte);
        SoftReference<Bitmap> softRef = new SoftReference<Bitmap>(BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options));
        Bitmap bitmap = softRef.get();
        if (imgByte != null) {
            imgByte = null;
        }
        try {
            if (input != null) {
                ((InputStream)input).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    @SuppressLint(value={"Recycle"})
    public static Map<String, Album> findGalleries(Context context, List<String> paths) {
        paths.clear();
        paths.add(FileUtils.getInst().getSystemPhotoPath());
        String[] projection = new String[]{"_id", "_data", "date_added"};
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, "_size>?", new String[]{"100000"}, "date_added desc");
        assert (cursor != null);
        cursor.moveToFirst();
        HashMap<String, Album> galleries = new HashMap<String, Album>();
        while (cursor.moveToNext()) {
            String data = cursor.getString(1);
            if (data.lastIndexOf("/") < 1) continue;
            String sub = data.substring(0, data.lastIndexOf("/"));
            if (!galleries.keySet().contains(sub)) {
                String name = sub.substring(sub.lastIndexOf("/") + 1, sub.length());
                if (!paths.contains(sub)) {
                    paths.add(sub);
                }
                galleries.put(sub, new Album(name, sub, new ArrayList<PhotoItem>()));
            }
            ((Album)galleries.get(sub)).getPhotos().add(new PhotoItem(data, (long)cursor.getInt(2) * 1000L));
        }
        ArrayList<PhotoItem> sysPhotos = FileUtils.getInst().findPicsInDir(FileUtils.getInst().getSystemPhotoPath());
        if (!sysPhotos.isEmpty()) {
            galleries.put(FileUtils.getInst().getSystemPhotoPath(), new Album("Gallery", FileUtils.getInst().getSystemPhotoPath(), sysPhotos));
        } else {
            galleries.remove(FileUtils.getInst().getSystemPhotoPath());
            paths.remove(FileUtils.getInst().getSystemPhotoPath());
        }
        return galleries;
    }

    public static void asyncLoadImage(Context context, Uri imageUri, LoadImageCallback callback) {
        new LoadImageUriTask(context, imageUri, callback).execute(new Void[0]);
    }

    public static void asyncLoadSmallImage(Context context, Uri imageUri, LoadImageCallback callback) {
        new LoadSmallPicTask(context, imageUri, callback).execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getResizedBitmap(Context context, Uri imageUri, int width, int height) {
        InputStream inputStream = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            inputStream = context.getContentResolver().openInputStream(imageUri);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            options.outWidth = width;
            options.outHeight = height;
            options.inJustDecodeBounds = false;
            IOUtil.closeStream(inputStream);
            inputStream = context.getContentResolver().openInputStream(imageUri);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            IOUtil.closeStream(inputStream);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtil.closeStream(inputStream);
        }
        return null;
    }

    private static class LoadSmallPicTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final Uri imageUri;
        private final Context context;
        private LoadImageCallback callback;

        public LoadSmallPicTask(Context context, Uri imageUri, LoadImageCallback callback) {
            this.imageUri = imageUri;
            this.context = context;
            this.callback = callback;
        }

        protected Bitmap doInBackground(Void ... params) {
            return ImageUtils.getResizedBitmap(this.context, this.imageUri, 300, 300);
        }

        protected void onPostExecute(Bitmap result) {
            super.onPostExecute((Object)result);
            this.callback.callback(result);
        }
    }

    private static class LoadImageUriTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final Uri imageUri;
        private final Context context;
        private LoadImageCallback callback;

        public LoadImageUriTask(Context context, Uri imageUri, LoadImageCallback callback) {
            this.imageUri = imageUri;
            this.context = context;
            this.callback = callback;
        }

        protected Bitmap doInBackground(Void ... params) {
            try {
                InputStream inputStream = this.imageUri.getScheme().startsWith("http") || this.imageUri.getScheme().startsWith("https") ? new URL(this.imageUri.toString()).openStream() : this.context.getContentResolver().openInputStream(this.imageUri);
                return BitmapFactory.decodeStream((InputStream)inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(Bitmap result) {
            super.onPostExecute((Object)result);
            this.callback.callback(result);
        }
    }

    public static interface LoadImageCallback {
        public void callback(Bitmap var1);
    }
}

