/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.helper;

import android.app.Activity;
import android.hardware.Camera;
import com.horses.camera.helper.CameraHelperGB;
import com.horses.camera.helper.CameraHelperImpl;
import com.horses.camera.helper.CameraInfo2;

public class CameraHelper {
    private final CameraHelperImpl base = new CameraHelperGB();

    public int getNumberOfCameras() {
        return this.base.getNumberOfCameras();
    }

    public Camera openCamera(int id) {
        return this.base.openCamera(id);
    }

    public Camera openDefaultCamera() {
        return this.base.openDefaultCamera();
    }

    public Camera openFrontCamera() {
        return this.base.openCameraFacing(1);
    }

    public Camera openBackCamera() {
        return this.base.openCameraFacing(0);
    }

    public boolean hasFrontCamera() {
        return this.base.hasCamera(1);
    }

    public boolean hasBackCamera() {
        return this.base.hasCamera(0);
    }

    public void getCameraInfo(int cameraId, CameraInfo2 cameraInfo) {
        this.base.getCameraInfo(cameraId, cameraInfo);
    }

    public void setCameraDisplayOrientation(Activity activity, int cameraId, Camera camera) {
        int result = this.getCameraDisplayOrientation(activity, cameraId);
        camera.setDisplayOrientation(result);
    }

    public int getCameraDisplayOrientation(Activity activity, int cameraId) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        CameraInfo2 info = new CameraInfo2();
        this.getCameraInfo(cameraId, info);
        if (info.getFacing() == 1) {
            return (info.getOrientation() + degrees) % 360;
        }
        return (info.getOrientation() - degrees + 360) % 360;
    }
}

