/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class CameraGrid
extends View {
    private int topBannerWidth = 0;
    private Paint paint;
    private boolean showGrid = true;

    public CameraGrid(Context context) {
        this(context, null);
    }

    public CameraGrid(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.paint = new Paint();
        this.paint.setColor(-1);
        this.paint.setAlpha(120);
        this.paint.setStrokeWidth(1.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (width < height) {
            this.topBannerWidth = height - width;
        }
        if (this.showGrid) {
            canvas.drawLine((float)(width / 3), 0.0f, (float)(width / 3), (float)height, this.paint);
            canvas.drawLine((float)(width * 2 / 3), 0.0f, (float)(width * 2 / 3), (float)height, this.paint);
            canvas.drawLine(0.0f, (float)(height / 3), (float)width, (float)(height / 3), this.paint);
            canvas.drawLine(0.0f, (float)(height * 2 / 3), (float)width, (float)(height * 2 / 3), this.paint);
        }
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public int getTopWidth() {
        return this.topBannerWidth;
    }
}

