/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.ui.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.horses.camera.R;
import com.horses.camera.business.PhotoItem;
import com.horses.camera.ui.adapter.GalleryAdapter;
import com.horses.camera.ui.application.CameraManager;
import com.horses.camera.ui.holder.GalleryHolder;
import java.util.ArrayList;
import java.util.List;

public class GalleryFragment
extends Fragment
implements GalleryHolder.CallbackGallery {
    private List<PhotoItem> photos = new ArrayList<PhotoItem>();
    private static final String PHOTO = "ARRAY";
    protected RecyclerView albums;

    public static GalleryFragment init(ArrayList<PhotoItem> photos) {
        GalleryFragment fragment = new GalleryFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(PHOTO, photos);
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_gallery, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.albums = (RecyclerView)view.findViewById(R.id.albums);
        this.photos = this.setPhotos();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onResume() {
        super.onResume();
        this.albums.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.getActivity(), 4));
        this.albums.setAdapter((RecyclerView.Adapter)new GalleryAdapter(this.photos, this));
    }

    private ArrayList<PhotoItem> setPhotos() {
        return (ArrayList)this.getArguments().getSerializable(PHOTO);
    }

    @Override
    public void onClickPhoto(PhotoItem item) {
        CameraManager.getInst().processCropper((Activity)this.getActivity(), item);
    }
}

