/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.ui.application;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.util.DisplayMetrics;
import com.horses.camera.business.PhotoItem;
import com.horses.camera.ui.activity.CropperActivity;
import com.horses.camera.ui.activity.TakeActivity;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiskCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.cache.disc.naming.Md5FileNameGenerator;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.cache.memory.impl.LruMemoryCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.nostra13.universalimageloader.utils.StorageUtils;
import java.util.Stack;

public class CameraManager {
    private static CameraManager manager;
    private Stack<Activity> cameras = new Stack();
    private static Application application;
    private static int screenWidth;
    private static int screenHeight;
    private static float screenDensity;
    private static String cacheDir;
    private static String filesDir;
    private static int colorPrimary;
    private static String packAge;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CameraManager getInst() {
        if (manager != null) return manager;
        Class<CameraManager> clazz = CameraManager.class;
        synchronized (CameraManager.class) {
            if (manager != null) return manager;
            manager = new CameraManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public void close() {
        for (Activity act : this.cameras) {
            try {
                act.finish();
            }
            catch (Exception exception) {}
        }
        this.cameras.clear();
    }

    public void addActivity(Activity activity) {
        this.cameras.add(activity);
    }

    public void removeActivity(Activity activity) {
        this.cameras.remove(activity);
    }

    public void openCameraSimple(Activity activity) {
        Intent intent = new Intent((Context)activity, TakeActivity.class);
        activity.startActivityForResult(intent, 1532);
    }

    public void processCropper(Activity activity, PhotoItem photo) {
        Uri uri = photo.getImageUri().startsWith("file:") ? Uri.parse((String)photo.getImageUri()) : Uri.parse((String)("file://" + photo.getImageUri()));
        Intent intent = new Intent((Context)activity, CropperActivity.class);
        intent.setData(uri);
        activity.startActivityForResult(intent, 4563);
    }

    public static int getScreenWidth() {
        return screenWidth;
    }

    public static int getScreenHeight() {
        return screenHeight;
    }

    public static float getScreenDensity() {
        return screenDensity;
    }

    public static int dp2px(float dps) {
        return (int)(0.5f + dps * CameraManager.getScreenDensity());
    }

    public static int px2dp(float pxs) {
        return (int)(pxs / CameraManager.getScreenDensity() + 0.5f);
    }

    public static String getFilesDirPath() {
        return filesDir;
    }

    public static String getCacheDirPath() {
        return cacheDir;
    }

    public static Application getApplication() {
        return application;
    }

    public static void setApplication(Application app) {
        application = app;
    }

    public static String getPackAgeName() {
        return packAge;
    }

    public static int getColorPrimary() {
        return colorPrimary;
    }

    static {
        screenWidth = 0;
        screenHeight = 0;
        screenDensity = 0.0f;
        colorPrimary = 0;
    }

    public static class Builder {
        private DisplayMetrics displayMetrics = null;
        private Application application;
        private String packageName = "horses";
        private int primaryColor;
        public static final String APP_DIR = Environment.getExternalStorageDirectory() + "/";
        public static final String APP_TEMP = APP_DIR + "/temp";
        public static final String APP_IMAGE = APP_DIR + "/Media/Images";

        public Builder primaryColor(int colorPrimary) {
            this.primaryColor = colorPrimary;
            return this;
        }

        public Builder packageName(String packAge) {
            this.packageName = packAge;
            return this;
        }

        public Builder(Application application) {
            this.application = application;
            CameraManager.setApplication(application);
        }

        public CameraManager init() {
            screenWidth = this.getScreenWidth();
            screenHeight = this.getScreenHeight();
            screenDensity = this.getScreenDensity();
            cacheDir = this.getCacheDirPath();
            filesDir = this.getFilesDirPath();
            colorPrimary = this.primaryColor;
            packAge = this.packageName;
            this.initImageLoader(this.application);
            return CameraManager.getInst();
        }

        public float getScreenDensity() {
            if (this.displayMetrics == null) {
                this.setDisplayMetrics(this.application.getResources().getDisplayMetrics());
            }
            return this.displayMetrics.density;
        }

        public int getScreenHeight() {
            if (this.displayMetrics == null) {
                this.setDisplayMetrics(this.application.getResources().getDisplayMetrics());
            }
            return this.displayMetrics.heightPixels;
        }

        public int getScreenWidth() {
            if (this.displayMetrics == null) {
                this.setDisplayMetrics(this.application.getResources().getDisplayMetrics());
            }
            return this.displayMetrics.widthPixels;
        }

        public void setDisplayMetrics(DisplayMetrics DisplayMetrics2) {
            this.displayMetrics = DisplayMetrics2;
        }

        public String getFilesDirPath() {
            return this.application.getFilesDir().getAbsolutePath();
        }

        public String getCacheDirPath() {
            return this.application.getCacheDir().getAbsolutePath();
        }

        public String fullDir() {
            return APP_DIR + this.packageName + APP_TEMP + APP_IMAGE;
        }

        private void initImageLoader(Application application) {
            DisplayImageOptions defaultOptions = new DisplayImageOptions.Builder().cacheInMemory(false).imageScaleType(ImageScaleType.EXACTLY).cacheOnDisk(true).build();
            ImageLoaderConfiguration config = new ImageLoaderConfiguration.Builder((Context)application).threadPriority(3).defaultDisplayImageOptions(defaultOptions).denyCacheImageMultipleSizesInMemory().diskCacheFileNameGenerator((FileNameGenerator)new Md5FileNameGenerator()).diskCache((DiskCache)new UnlimitedDiskCache(StorageUtils.getOwnCacheDirectory((Context)application, (String)this.fullDir()))).diskCacheSize(0x6400000).tasksProcessingOrder(QueueProcessingType.LIFO).memoryCache((MemoryCache)new LruMemoryCache(0x200000)).memoryCacheSize(0x200000).threadPoolSize(3).build();
            ImageLoader.getInstance().init(config);
        }
    }
}

