/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.ui.adapter;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v7.app.AppCompatActivity;
import com.horses.camera.R;
import com.horses.camera.business.Album;
import com.horses.camera.ui.fragment.GalleryFragment;
import com.horses.camera.utils.FileUtils;
import com.horses.camera.utils.StringUtils;
import java.util.List;
import java.util.Map;

public class TabPageIndicatorAdapter
extends FragmentPagerAdapter {
    private Map<String, Album> albums;
    private List<String> paths;
    private AppCompatActivity activity;

    public TabPageIndicatorAdapter(AppCompatActivity activity, Map<String, Album> albums, List<String> paths) {
        super(activity.getSupportFragmentManager());
        this.activity = activity;
        this.albums = albums;
        this.paths = paths;
    }

    public Fragment getItem(int position) {
        return GalleryFragment.init(this.albums.get(this.paths.get(position)).getPhotos());
    }

    public CharSequence getPageTitle(int position) {
        Album album = this.albums.get(this.paths.get(position % this.paths.size()));
        if (StringUtils.equalsIgnoreCase(FileUtils.getInst().getSystemPhotoPath(), album.getAlbumUri())) {
            return this.activity.getResources().getString(R.string.title_album);
        }
        if (album.getTitle().length() > 13) {
            return album.getTitle().substring(0, 11) + "...";
        }
        return album.getTitle();
    }

    public int getCount() {
        return this.paths.size();
    }
}

