/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.ui.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.afollestad.materialdialogs.MaterialDialog;
import com.horses.camera.R;
import com.horses.camera.business.PhotoItem;
import com.horses.camera.helper.CameraHelper;
import com.horses.camera.ui.activity.BaseActivity;
import com.horses.camera.ui.activity.GalleryActivity;
import com.horses.camera.ui.application.CameraManager;
import com.horses.camera.ui.view.CameraGrid;
import com.horses.camera.utils.ColorUtils;
import com.horses.camera.utils.DistanceUtil;
import com.horses.camera.utils.FileUtils;
import com.horses.camera.utils.IOUtil;
import com.horses.camera.utils.ImageLoaderUtils;
import com.horses.camera.utils.ImageUtils;
import com.horses.camera.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TakeActivity
extends BaseActivity {
    private static final String TAG = "Camera";
    private static final int MIN_PREVIEW_PIXELS = 153600;
    private static final double MAX_ASPECT_DISTORTION = 0.15;
    private static int PHOTO_SIZE = 2000;
    private int currentCameraId = 0;
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private int photoNumber = 4;
    private int photoWidth = DistanceUtil.getCameraPhotoWidth();
    private int photoMargin = CameraManager.dp2px(1.0f);
    private float pointX;
    private float pointY;
    private static final int FOCUS = 1;
    private static final int ZOOM = 2;
    private int mode;
    private float dist;
    private int curZoomValue = 0;
    private CameraHelper cameraHelper;
    private Camera cameraInst = null;
    private Camera.Parameters parameters = null;
    private Camera.Size adapterSize = null;
    private Camera.Size previewSize = null;
    private Handler handler = new Handler();
    private CameraGrid cameraGrid;
    private LinearLayout photoArea;
    private View takePhotoPanel;
    private View focusIndex;
    private View shutter;
    private ImageView flashBtn;
    private ImageView changeBtn;
    private ImageView backBtn;
    private ImageView galleryBtn;
    private Button takePicture;
    private SurfaceView surfaceView;

    @Override
    protected int getView() {
        return R.layout.activity_take;
    }

    @Override
    protected void onCreate() {
        this.cameraGrid = (CameraGrid)this.findViewById(R.id.masking);
        this.photoArea = (LinearLayout)this.findViewById(R.id.photo_area);
        this.takePhotoPanel = this.findViewById(R.id.panel_take_photo);
        this.focusIndex = this.findViewById(R.id.focus_index);
        this.shutter = this.findViewById(R.id.shutter);
        this.flashBtn = (ImageView)this.findViewById(R.id.flash);
        this.changeBtn = (ImageView)this.findViewById(R.id.change);
        this.backBtn = (ImageView)this.findViewById(R.id.back);
        this.galleryBtn = (ImageView)this.findViewById(R.id.next);
        this.takePicture = (Button)this.findViewById(R.id.take_picture);
        this.surfaceView = (SurfaceView)this.findViewById(R.id.surface_view);
        this.cameraHelper = new CameraHelper();
        this.initView();
        this.initEvent();
        this.initButtons();
        this.changeColor();
    }

    private void initButtons() {
        this.backBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakeActivity.this.finish();
            }
        });
        this.galleryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakeActivity.this.startActivityForResult(new Intent((Context)TakeActivity.this.activity, GalleryActivity.class), 4563);
            }
        });
        this.changeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakeActivity.this.switchCamera();
            }
        });
        this.flashBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakeActivity.this.turnLight(TakeActivity.this.cameraInst);
            }
        });
        this.takePicture.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    TakeActivity.this.animateShutter();
                    TakeActivity.this.cameraInst.takePicture(null, null, new Camera.PictureCallback(){

                        public void onPictureTaken(byte[] data, Camera camera) {
                            Bundle bundle = new Bundle();
                            bundle.putByteArray("bytes", data);
                            new SavePicTask(data).execute(new Void[0]);
                            camera.startPreview();
                        }
                    });
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    new MaterialDialog.Builder((Context)TakeActivity.this.activity).title(R.string.dialog_title_fail).content(R.string.dialog_content_fail).positiveText(17039370).show();
                    try {
                        TakeActivity.this.cameraInst.startPreview();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void initEvent() {
        boolean canSwitch = false;
        try {
            canSwitch = this.cameraHelper.hasFrontCamera() && this.cameraHelper.hasBackCamera();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!canSwitch) {
            this.changeBtn.setVisibility(8);
        }
        this.surfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        TakeActivity.this.pointX = event.getX();
                        TakeActivity.this.pointY = event.getY();
                        TakeActivity.this.mode = 1;
                        break;
                    }
                    case 5: {
                        TakeActivity.this.dist = TakeActivity.this.spacing(event);
                        if (!(TakeActivity.this.spacing(event) > 10.0f)) break;
                        TakeActivity.this.mode = 2;
                        break;
                    }
                    case 1: 
                    case 6: {
                        TakeActivity.this.mode = 1;
                        break;
                    }
                    case 2: {
                        float newDist;
                        if (TakeActivity.this.mode == 1 || TakeActivity.this.mode != 2 || !((newDist = TakeActivity.this.spacing(event)) > 10.0f)) break;
                        float tScale = (newDist - TakeActivity.this.dist) / TakeActivity.this.dist;
                        if (tScale < 0.0f) {
                            tScale *= 10.0f;
                        }
                        TakeActivity.this.addZoomIn((int)tScale);
                    }
                }
                return false;
            }
        });
        this.surfaceView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    TakeActivity.this.pointFocus((int)TakeActivity.this.pointX, (int)TakeActivity.this.pointY);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                RelativeLayout.LayoutParams layout2 = new RelativeLayout.LayoutParams(TakeActivity.this.focusIndex.getLayoutParams());
                layout2.setMargins((int)TakeActivity.this.pointX - 60, (int)TakeActivity.this.pointY - 60, 0, 0);
                TakeActivity.this.focusIndex.setLayoutParams((ViewGroup.LayoutParams)layout2);
                TakeActivity.this.focusIndex.setVisibility(0);
                ScaleAnimation sa = new ScaleAnimation(3.0f, 1.0f, 3.0f, 1.0f, 1, 0.5f, 1, 0.5f);
                sa.setDuration(800L);
                TakeActivity.this.focusIndex.startAnimation((Animation)sa);
                TakeActivity.this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TakeActivity.this.focusIndex.setVisibility(4);
                    }
                }, 800L);
            }
        });
    }

    private float spacing(MotionEvent event) {
        if (event == null) {
            return 0.0f;
        }
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void addZoomIn(int delta) {
        try {
            Camera.Parameters params = this.cameraInst.getParameters();
            if (!params.isZoomSupported()) {
                return;
            }
            this.curZoomValue += delta;
            if (this.curZoomValue < 0) {
                this.curZoomValue = 0;
            } else if (this.curZoomValue > params.getMaxZoom()) {
                this.curZoomValue = params.getMaxZoom();
            }
            if (!params.isSmoothZoomSupported()) {
                params.setZoom(this.curZoomValue);
                this.cameraInst.setParameters(params);
            } else {
                this.cameraInst.startSmoothZoom(this.curZoomValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void pointFocus(int x, int y) {
        this.cameraInst.cancelAutoFocus();
        this.parameters = this.cameraInst.getParameters();
        this.showPoint(x, y);
        this.cameraInst.setParameters(this.parameters);
        this.autoFocus();
    }

    private void showPoint(int x, int y) {
        if (this.parameters.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> areas = new ArrayList<Camera.Area>();
            int rectY = -x * 2000 / CameraManager.getScreenWidth() + 1000;
            int rectX = y * 2000 / CameraManager.getScreenHeight() - 1000;
            int left = rectX < -900 ? -1000 : rectX - 100;
            int top = rectY < -900 ? -1000 : rectY - 100;
            int right = rectX > 900 ? 1000 : rectX + 100;
            int bottom = rectY > 900 ? 1000 : rectY + 100;
            Rect area1 = new Rect(left, top, right, bottom);
            areas.add(new Camera.Area(area1, 800));
            this.parameters.setMeteringAreas(areas);
        }
        this.parameters.setFocusMode("continuous-picture");
    }

    private void switchCamera() {
        this.currentCameraId = (this.currentCameraId + 1) % this.cameraHelper.getNumberOfCameras();
        this.releaseCamera();
        this.setUpCamera(this.currentCameraId);
    }

    private void setUpCamera(int mCurrentCameraId2) {
        this.cameraInst = this.getCameraInstance(mCurrentCameraId2);
        if (this.cameraInst != null) {
            try {
                this.cameraInst.setPreviewDisplay(this.surfaceView.getHolder());
                this.initCamera();
                this.cameraInst.startPreview();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void releaseCamera() {
        if (this.cameraInst != null) {
            this.cameraInst.setPreviewCallback(null);
            this.cameraInst.release();
            this.cameraInst = null;
        }
        this.adapterSize = null;
        this.previewSize = null;
    }

    private void turnLight(Camera camera) {
        if (camera == null || camera.getParameters() == null || camera.getParameters().getSupportedFlashModes() == null) {
            return;
        }
        Camera.Parameters parameters = camera.getParameters();
        String flashMode = camera.getParameters().getFlashMode();
        List supportedModes = camera.getParameters().getSupportedFlashModes();
        if ("off".equals(flashMode) && supportedModes.contains("torch")) {
            parameters.setFlashMode("torch");
            camera.setParameters(parameters);
            this.flashBtn.setImageResource(R.drawable.ic_flash_on_white_24dp);
        } else if ("torch".equals(flashMode)) {
            if (supportedModes.contains("auto")) {
                parameters.setFlashMode("auto");
                this.flashBtn.setImageResource(R.drawable.ic_flash_auto_white_24dp);
                camera.setParameters(parameters);
            } else if (supportedModes.contains("off")) {
                parameters.setFlashMode("off");
                this.flashBtn.setImageResource(R.drawable.ic_flash_off_white_24dp);
                camera.setParameters(parameters);
            }
        } else if ("auto".equals(flashMode) && supportedModes.contains("off")) {
            parameters.setFlashMode("off");
            camera.setParameters(parameters);
            this.flashBtn.setImageResource(R.drawable.ic_flash_off_white_24dp);
        }
    }

    public String saveToSDCard(byte[] data) throws IOException {
        Bitmap croppedImage;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        PHOTO_SIZE = options.outHeight > options.outWidth ? options.outWidth : options.outHeight;
        int height = options.outHeight > options.outWidth ? options.outHeight : options.outWidth;
        options.inJustDecodeBounds = false;
        Rect r = this.currentCameraId == 1 ? new Rect(height - PHOTO_SIZE, 0, height, PHOTO_SIZE) : new Rect(0, 0, PHOTO_SIZE, PHOTO_SIZE);
        try {
            croppedImage = this.decodeRegionCrop(data, r);
        }
        catch (Exception e) {
            return null;
        }
        String imagePath = ImageUtils.saveToFile(FileUtils.getInst().getSystemPhotoPath(), true, croppedImage);
        croppedImage.recycle();
        return imagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap decodeRegionCrop(byte[] data, Rect rect) {
        Bitmap rotatedImage;
        ByteArrayInputStream is = null;
        System.gc();
        Bitmap croppedImage = null;
        try {
            is = new ByteArrayInputStream(data);
            BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance((InputStream)is, (boolean)false);
            try {
                croppedImage = decoder.decodeRegion(rect, new BitmapFactory.Options());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeStream(is);
                throw throwable;
            }
            IOUtil.closeStream(is);
        }
        IOUtil.closeStream(is);
        Matrix m = new Matrix();
        m.setRotate(90.0f, (float)(PHOTO_SIZE / 2), (float)(PHOTO_SIZE / 2));
        if (this.currentCameraId == 1) {
            m.postScale(1.0f, -1.0f);
        }
        if ((rotatedImage = Bitmap.createBitmap((Bitmap)croppedImage, (int)0, (int)0, (int)PHOTO_SIZE, (int)PHOTO_SIZE, (Matrix)m, (boolean)true)) != croppedImage) {
            assert (croppedImage != null);
            croppedImage.recycle();
        }
        return rotatedImage;
    }

    private void animateShutter() {
        this.shutter.setVisibility(0);
        this.shutter.setAlpha(0.0f);
        ObjectAnimator alphaInAnim = ObjectAnimator.ofFloat((Object)this.shutter, (String)"alpha", (float[])new float[]{0.0f, 0.8f});
        alphaInAnim.setDuration(100L);
        alphaInAnim.setStartDelay(100L);
        alphaInAnim.setInterpolator((TimeInterpolator)ACCELERATE_INTERPOLATOR);
        ObjectAnimator alphaOutAnim = ObjectAnimator.ofFloat((Object)this.shutter, (String)"alpha", (float[])new float[]{0.8f, 0.0f});
        alphaOutAnim.setDuration(200L);
        alphaOutAnim.setInterpolator((TimeInterpolator)DECELERATE_INTERPOLATOR);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(new Animator[]{alphaInAnim, alphaOutAnim});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                TakeActivity.this.shutter.setVisibility(8);
            }
        });
        animatorSet.start();
    }

    private void changeColor() {
        this.backBtn.getDrawable().setColorFilter(ColorUtils.getPrimaryColor(), PorterDuff.Mode.MULTIPLY);
        this.galleryBtn.getDrawable().setColorFilter(ColorUtils.getPrimaryColor(), PorterDuff.Mode.MULTIPLY);
    }

    private void initView() {
        SurfaceHolder surfaceHolder = this.surfaceView.getHolder();
        surfaceHolder.setType(3);
        surfaceHolder.setKeepScreenOn(true);
        this.surfaceView.setFocusable(true);
        this.surfaceView.setBackgroundColor(40);
        this.surfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        ViewGroup.LayoutParams layout2 = this.cameraGrid.getLayoutParams();
        layout2.height = CameraManager.getScreenWidth();
        layout2 = this.photoArea.getLayoutParams();
        layout2.height = DistanceUtil.getCameraPhotoAreaHeight();
        layout2 = this.takePhotoPanel.getLayoutParams();
        layout2.height = CameraManager.getScreenHeight() - CameraManager.getScreenWidth() - DistanceUtil.getCameraPhotoAreaHeight();
        ArrayList<PhotoItem> sysPhotos = FileUtils.getInst().findPicsInDir(FileUtils.getInst().getSystemPhotoPath());
        int showNumber = sysPhotos.size() > this.photoNumber ? this.photoNumber : sysPhotos.size();
        for (int i = 0; i < showNumber; ++i) {
            this.addPhoto(sysPhotos.get(showNumber - 1 - i));
        }
    }

    private void addPhoto(PhotoItem photoItem) {
        ImageView photo = new ImageView((Context)this);
        if (StringUtils.isNotBlank(photoItem.getImageUri())) {
            ImageLoaderUtils.displayLocalImage(photoItem.getImageUri(), photo);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.photoWidth, this.photoWidth);
        params.leftMargin = this.photoMargin;
        params.rightMargin = this.photoMargin;
        params.gravity = 17;
        photo.setScaleType(ImageView.ScaleType.CENTER_CROP);
        photo.setTag((Object)photoItem.getImageUri());
        if (this.photoArea.getChildCount() >= this.photoNumber) {
            this.photoArea.removeViewAt(this.photoArea.getChildCount() - 1);
            this.photoArea.addView((View)photo, 0, (ViewGroup.LayoutParams)params);
        } else {
            this.photoArea.addView((View)photo, 0, (ViewGroup.LayoutParams)params);
        }
        photo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (v instanceof ImageView && v.getTag() instanceof String) {
                    CameraManager.getInst().processCropper(TakeActivity.this.activity, new PhotoItem((String)v.getTag(), System.currentTimeMillis()));
                }
            }
        });
    }

    private void autoFocus() {
        new Thread(){

            @Override
            public void run() {
                try {
                    10.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (TakeActivity.this.cameraInst == null) {
                    return;
                }
                TakeActivity.this.cameraInst.autoFocus(new Camera.AutoFocusCallback(){

                    public void onAutoFocus(boolean success, Camera camera) {
                        if (success) {
                            TakeActivity.this.initCamera();
                        }
                    }
                });
            }
        };
    }

    private void initCamera() {
        this.parameters = this.cameraInst.getParameters();
        this.parameters.setPictureFormat(256);
        this.setUpPicSize();
        this.setUpPreviewSize();
        if (this.adapterSize != null) {
            this.parameters.setPictureSize(this.adapterSize.width, this.adapterSize.height);
        }
        if (this.previewSize != null) {
            this.parameters.setPreviewSize(this.previewSize.width, this.previewSize.height);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            this.parameters.setFocusMode("continuous-picture");
        } else {
            this.parameters.setFocusMode("auto");
        }
        this.setDisplay(this.parameters, this.cameraInst);
        try {
            this.cameraInst.setParameters(this.parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cameraInst.startPreview();
        this.cameraInst.cancelAutoFocus();
    }

    private void setDisplay(Camera.Parameters parameters, Camera camera) {
        if (Build.VERSION.SDK_INT >= 8) {
            this.setDisplayOrientation(camera, 90);
        } else {
            parameters.setRotation(90);
        }
    }

    private void setDisplayOrientation(Camera camera, int i) {
        try {
            Method downPolymorphic = camera.getClass().getMethod("setDisplayOrientation", Integer.TYPE);
            if (downPolymorphic != null) {
                downPolymorphic.invoke((Object)camera, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setUpPicSize() {
        if (this.adapterSize == null) {
            this.adapterSize = this.findBestPictureResolution();
        }
    }

    private void setUpPreviewSize() {
        if (this.previewSize == null) {
            this.previewSize = this.findBestPreviewResolution();
        }
    }

    private Camera.Size findBestPictureResolution() {
        Camera.Parameters cameraParameters = this.cameraInst.getParameters();
        List supportedPicResolutions = cameraParameters.getSupportedPictureSizes();
        StringBuilder picResolutionSb = new StringBuilder();
        for (Camera.Size supportedPicResolution : supportedPicResolutions) {
            picResolutionSb.append(supportedPicResolution.width).append('x').append(supportedPicResolution.height).append(" ");
        }
        Log.d((String)TAG, (String)("Supported picture resolutions: " + picResolutionSb));
        Camera.Size defaultPictureResolution = cameraParameters.getPictureSize();
        Log.d((String)TAG, (String)("default picture resolution " + defaultPictureResolution.width + "x" + defaultPictureResolution.height));
        ArrayList sortedSupportedPicResolutions = new ArrayList(supportedPicResolutions);
        Collections.sort(sortedSupportedPicResolutions, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        double screenAspectRatio = (double)CameraManager.getScreenWidth() / (double)CameraManager.getScreenHeight();
        Iterator it = sortedSupportedPicResolutions.iterator();
        while (it.hasNext()) {
            Camera.Size supportedPreviewResolution = (Camera.Size)it.next();
            int width = supportedPreviewResolution.width;
            int height = supportedPreviewResolution.height;
            boolean isCandidatePortrait = width > height;
            int maybeFlippedWidth = isCandidatePortrait ? height : width;
            int n = isCandidatePortrait ? width : height;
            int maybeFlippedHeight = n;
            double aspectRatio = (double)maybeFlippedWidth / (double)maybeFlippedHeight;
            double distortion = Math.abs(aspectRatio - screenAspectRatio);
            if (!(distortion > 0.15)) continue;
            it.remove();
        }
        if (!sortedSupportedPicResolutions.isEmpty()) {
            return (Camera.Size)sortedSupportedPicResolutions.get(0);
        }
        return defaultPictureResolution;
    }

    private Camera.Size findBestPreviewResolution() {
        Camera.Parameters cameraParameters = this.cameraInst.getParameters();
        Camera.Size defaultPreviewResolution = cameraParameters.getPreviewSize();
        List rawSupportedSizes = cameraParameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            return defaultPreviewResolution;
        }
        ArrayList supportedPreviewResolutions = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPreviewResolutions, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        StringBuilder previewResolutionSb = new StringBuilder();
        for (Camera.Size supportedPreviewResolution : supportedPreviewResolutions) {
            previewResolutionSb.append(supportedPreviewResolution.width).append('x').append(supportedPreviewResolution.height).append(' ');
        }
        Log.v((String)TAG, (String)("Supported preview resolutions: " + previewResolutionSb));
        double screenAspectRatio = (double)CameraManager.getScreenWidth() / (double)CameraManager.getScreenHeight();
        Iterator it = supportedPreviewResolutions.iterator();
        while (it.hasNext()) {
            int maybeFlippedHeight;
            Camera.Size supportedPreviewResolution = (Camera.Size)it.next();
            int width = supportedPreviewResolution.width;
            int height = supportedPreviewResolution.height;
            if (width * height < 153600) {
                it.remove();
                continue;
            }
            boolean isCandidatePortrait = width > height;
            int maybeFlippedWidth = isCandidatePortrait ? height : width;
            double aspectRatio = (double)maybeFlippedWidth / (double)(maybeFlippedHeight = isCandidatePortrait ? width : height);
            double distortion = Math.abs(aspectRatio - screenAspectRatio);
            if (distortion > 0.15) {
                it.remove();
                continue;
            }
            if (maybeFlippedWidth != CameraManager.getScreenWidth() || maybeFlippedHeight != CameraManager.getScreenHeight()) continue;
            return supportedPreviewResolution;
        }
        if (!supportedPreviewResolutions.isEmpty()) {
            return (Camera.Size)supportedPreviewResolutions.get(0);
        }
        return defaultPreviewResolution;
    }

    private Camera getCameraInstance(int id2) {
        Camera camera = null;
        try {
            camera = this.cameraHelper.openCamera(id2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return camera;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent result) {
        if (requestCode == 4563 && resultCode == -1) {
            Intent intent = new Intent();
            intent.setData(result.getData());
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private final class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            try {
                if (TakeActivity.this.cameraInst != null) {
                    TakeActivity.this.cameraInst.stopPreview();
                    TakeActivity.this.cameraInst.release();
                    TakeActivity.this.cameraInst = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            if (null == TakeActivity.this.cameraInst) {
                try {
                    TakeActivity.this.cameraInst = Camera.open();
                    TakeActivity.this.cameraInst.setPreviewDisplay(holder);
                    TakeActivity.this.initCamera();
                    TakeActivity.this.cameraInst.startPreview();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            TakeActivity.this.autoFocus();
        }
    }

    private class SavePicTask
    extends AsyncTask<Void, Void, String> {
        private byte[] data;
        private MaterialDialog dialog;

        protected void onPreExecute() {
            this.dialog = new MaterialDialog.Builder((Context)TakeActivity.this.activity).title(R.string.dialog_title).content(R.string.dialog_content).progress(true, 0).cancelable(false).show();
        }

        private SavePicTask(byte[] data) {
            this.data = data;
        }

        protected String doInBackground(Void ... params) {
            try {
                return TakeActivity.this.saveToSDCard(this.data);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(String result) {
            super.onPostExecute((Object)result);
            this.dialog.dismiss();
            if (StringUtils.isNotEmpty(result)) {
                CameraManager.getInst().processCropper(TakeActivity.this.activity, new PhotoItem(result, System.currentTimeMillis()));
            } else {
                new MaterialDialog.Builder((Context)TakeActivity.this.activity).title(R.string.dialog_title_fail).content(R.string.dialog_content_fail).positiveText(17039370).show();
            }
        }
    }
}

