/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.Menu;
import android.view.MenuItem;
import com.afollestad.materialdialogs.MaterialDialog;
import com.edmodo.cropper.CropImageView;
import com.horses.camera.R;
import com.horses.camera.ui.activity.BaseActivity;
import com.horses.camera.ui.application.CameraManager;
import com.horses.camera.utils.FileUtils;
import com.horses.camera.utils.ImageUtils;

public class CropperActivity
extends BaseActivity {
    private MaterialDialog dialog;
    protected CropImageView cropImageView;

    @Override
    protected int getView() {
        return R.layout.activity_cropper;
    }

    @Override
    protected void onCreate() {
        this.cropImageView = (CropImageView)this.findViewById(R.id.cropImageView);
        this.setSupportActionBar();
        this.setSupportActionBar(this.getResources().getString(R.string.title_cropper));
        this.getSupportActionBar().setHomeAsUpIndicator(this.getResources().getDrawable(R.drawable.ic_close_white_24dp));
        this.setCropImageView();
    }

    private void setCropImageView() {
        Uri fileUri = this.getIntent().getData();
        Bitmap oriBitmap = ImageUtils.decodeBitmapWithOrientation(fileUri.getPath(), CameraManager.getScreenWidth(), CameraManager.getScreenHeight());
        this.cropImageView.setImageBitmap(oriBitmap);
        this.cropImageView.setFixedAspectRatio(true);
    }

    private void saveImageToCache(Bitmap croppedImage) {
        if (croppedImage != null) {
            try {
                ImageUtils.saveToFile(FileUtils.getInst().getCacheDir() + "/croppedcache", false, croppedImage);
                Intent intent = new Intent();
                intent.setData(Uri.parse((String)("file://" + FileUtils.getInst().getCacheDir() + "/croppedcache")));
                this.setResult(-1, intent);
                this.dialog.dismiss();
                this.finish();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.check_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.finish();
        } else if (id2 == R.id.action_check) {
            this.dialog = new MaterialDialog.Builder((Context)this.activity).title(R.string.dialog_title).content(R.string.dialog_content).progress(true, 0).cancelable(false).show();
            this.saveImageToCache(this.cropImageView.getCroppedImage());
        }
        return super.onOptionsItemSelected(item);
    }
}

