/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import com.horses.camera.business.PhotoItem;
import com.horses.camera.ui.application.CameraManager;
import com.horses.camera.utils.IOUtil;
import com.horses.camera.utils.MD5Util;
import com.horses.camera.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;

public class FileUtils {
    private static String BASE_PATH;
    private static String STICKER_BASE_PATH;
    private static FileUtils fileUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileUtils getInst() {
        if (fileUtils != null) return fileUtils;
        Class<FileUtils> clazz = FileUtils.class;
        synchronized (FileUtils.class) {
            if (fileUtils != null) return fileUtils;
            fileUtils = new FileUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fileUtils;
        }
    }

    public File getExtFile(String path) {
        return new File(BASE_PATH + path);
    }

    public long getFolderSize(File file) {
        try {
            File[] fileList;
            long size = 0L;
            if (!file.exists()) {
                return size;
            }
            if (!file.isDirectory()) {
                return file.length() / 1024L;
            }
            for (File item : fileList = file.listFiles()) {
                if (item.isDirectory()) {
                    size += this.getFolderSize(item);
                    continue;
                }
                size += item.length();
            }
            return size / 1024L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public String getBasePath(int packageId) {
        return STICKER_BASE_PATH + packageId + "/";
    }

    private String getImageFilePath(int packageId, String imageUrl) {
        String md5Str = MD5Util.getMD5(imageUrl).replace("-", "mm");
        return this.getBasePath(packageId) + md5Str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFromAsset(String fileName) {
        String string2;
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = CameraManager.getApplication().getAssets().open(fileName);
            br = new BufferedReader(new InputStreamReader(is));
            String addonStr = "";
            String line = br.readLine();
            while (line != null) {
                addonStr = addonStr + line;
                line = br.readLine();
            }
            string2 = addonStr;
            IOUtil.closeStream(br);
        }
        catch (Exception e) {
            String string3 = null;
            return string3;
        }
        finally {
            IOUtil.closeStream(br);
            IOUtil.closeStream(is);
        }
        IOUtil.closeStream(is);
        return string2;
    }

    public void removeAddonFolder(int packageId) {
        String filename = this.getBasePath(packageId);
        File file = new File(filename);
        if (file.exists()) {
            this.delete(file);
        }
    }

    public void delete(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                file.delete();
                return;
            }
            for (File item : childFiles) {
                this.delete(item);
            }
            file.delete();
        }
    }

    public String getPhotoSavedPath() {
        return BASE_PATH + CameraManager.getPackAgeName();
    }

    public String getPhotoTempPath() {
        return BASE_PATH + CameraManager.getPackAgeName();
    }

    public String getSystemPhotoPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/DCIM/100Media";
    }

    private FileUtils() {
        String sdcardState = Environment.getExternalStorageState();
        BASE_PATH = "mounted".equals(sdcardState) ? Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + CameraManager.getPackAgeName() + "/" : CameraManager.getCacheDirPath();
        STICKER_BASE_PATH = BASE_PATH + "/photos/";
    }

    public boolean createFile(File file) {
        try {
            if (!file.getParentFile().exists()) {
                this.mkdir(file.getParentFile());
            }
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean mkdir(File file) {
        while (!file.getParentFile().exists()) {
            this.mkdir(file.getParentFile());
        }
        return file.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeSimpleString(File file, String string2) {
        boolean bl;
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file);
            fOut.write(string2.getBytes());
            bl = true;
        }
        catch (Throwable e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtil.closeStream(fOut);
                throw throwable;
            }
            IOUtil.closeStream(fOut);
            return bl2;
        }
        IOUtil.closeStream(fOut);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readSimpleString(File file) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            if (StringUtils.isNotEmpty(line)) {
                sb.append(line.trim());
            }
        }
        catch (Throwable e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = "";
            }
            catch (Throwable throwable) {
                IOUtil.closeStream(br);
                throw throwable;
            }
            IOUtil.closeStream(br);
            return string2;
        }
        IOUtil.closeStream(br);
        return sb.toString();
    }

    public boolean copyAssetDirToFiles(Context context, String dirname) {
        try {
            String[] children;
            AssetManager assetManager = context.getAssets();
            for (String child : children = assetManager.list(dirname)) {
                child = dirname + '/' + child;
                String[] grandChildren = assetManager.list(child);
                if (0 == grandChildren.length) {
                    this.copyAssetFileToFiles(context, child);
                    continue;
                }
                this.copyAssetDirToFiles(context, child);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean copyAssetFileToFiles(Context context, String filename) {
        return this.copyAssetFileToFiles(context, filename, this.getExtFile("/" + filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyAssetFileToFiles(Context context, String filename, File of) {
        boolean bl;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            int readedBytes;
            is = context.getAssets().open(filename);
            this.createFile(of);
            os = new FileOutputStream(of);
            byte[] buf = new byte[1024];
            while ((readedBytes = is.read(buf)) > 0) {
                os.write(buf, 0, readedBytes);
            }
            os.flush();
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtil.closeStream(is);
                IOUtil.closeStream(os);
                throw throwable;
            }
            IOUtil.closeStream(is);
            IOUtil.closeStream(os);
            return bl2;
        }
        IOUtil.closeStream(is);
        IOUtil.closeStream(os);
        return bl;
    }

    public boolean renameDir(String oldDir, String newDir) {
        File of = new File(oldDir);
        File nf = new File(newDir);
        return of.exists() && !nf.exists() && of.renameTo(nf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String oldPath, String newPath) {
        FileInputStream inStream = null;
        FileOutputStream fs = null;
        try {
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                int byteread;
                inStream = new FileInputStream(oldPath);
                fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtil.closeStream(inStream);
            IOUtil.closeStream(fs);
        }
    }

    public File getCacheDir() {
        return CameraManager.getApplication().getCacheDir();
    }

    public ArrayList<PhotoItem> findPicsInDir(String path) {
        File[] files;
        ArrayList<PhotoItem> photos = new ArrayList<PhotoItem>();
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String filePath = pathname.getAbsolutePath();
                return filePath.endsWith(".png") || filePath.endsWith(".jpg") || filePath.endsWith(".jepg");
            }
        })) != null && files.length != 0) {
            for (File file : files) {
                photos.add(new PhotoItem(file.getAbsolutePath(), file.lastModified()));
            }
        }
        Collections.sort(photos);
        return photos;
    }
}

