/*
 * Decompiled with CFR 0.152.
 */
package com.horses.camera.ui.holder;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.horses.camera.R;
import com.horses.camera.business.PhotoItem;
import com.horses.camera.utils.DisplayListener;
import com.horses.camera.utils.DistanceUtil;
import com.horses.camera.utils.ImageLoaderUtils;

public class GalleryHolder
extends RecyclerView.ViewHolder {
    protected ImageView image;

    public GalleryHolder(View itemView) {
        super(itemView);
        this.image = (ImageView)itemView.findViewById(R.id.image);
    }

    public static GalleryHolder init(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_gallery, parent, false);
        int width = DistanceUtil.getCameraAlbumWidth();
        ViewPager.LayoutParams params = (ViewPager.LayoutParams)parent.getLayoutParams();
        params.width = width;
        params.height = width;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        return new GalleryHolder(view);
    }

    public void setPhoto(final PhotoItem photo, final CallbackGallery callback) {
        ImageLoaderUtils.displayLocalImage(photo.getImageUri(), this.image, DisplayListener.optionsImage);
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                callback.onClickPhoto(photo);
            }
        });
    }

    public static interface CallbackGallery {
        public void onClickPhoto(PhotoItem var1);
    }
}

