/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera.ui.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.v7.app.AppCompatActivity;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import app.horses.camera.R;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.android.BeepManager;
import com.journeyapps.barcodescanner.BarcodeCallback;
import com.journeyapps.barcodescanner.BarcodeResult;
import com.journeyapps.barcodescanner.BarcodeView;
import java.util.List;

public class QRTakeActivity
extends AppCompatActivity {
    private static final String TAG = QRTakeActivity.class.getSimpleName();
    @LayoutRes
    private int QRScanLayout;
    private BarcodeView barcodeView;
    private BeepManager beepManager;
    private String lastText;
    private View customOverlay;
    private BarcodeCallback callback = new BarcodeCallback(){

        public void barcodeResult(BarcodeResult result) {
            if (result.getText() == null || result.getText().equals(QRTakeActivity.this.lastText)) {
                return;
            }
            QRTakeActivity.this.lastText = result.getText();
            Intent intent = new Intent();
            intent.putExtra("scan", QRTakeActivity.this.lastText);
            QRTakeActivity.this.setResult(-1, intent);
            QRTakeActivity.this.finish();
        }

        public void possibleResultPoints(List<ResultPoint> resultPoints) {
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.setContentView(R.layout.activity_qr);
        if (intent.hasExtra("QRScanELayout")) {
            this.QRScanLayout = intent.getIntExtra("QRScanELayout", 0);
            this.customOverlay = this.getLayoutInflater().inflate(this.QRScanLayout, null);
            this.addContentView(this.customOverlay, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }
        this.barcodeView = (BarcodeView)this.findViewById(R.id.barcode_scanner);
        this.barcodeView.decodeContinuous(this.callback);
        this.beepManager = new BeepManager((Activity)this);
    }

    protected void onResume() {
        super.onResume();
        this.barcodeView.resume();
    }

    protected void onPause() {
        super.onPause();
        this.barcodeView.pause();
    }

    public void pause(View view) {
        this.barcodeView.pause();
    }

    public void resume(View view) {
        this.barcodeView.resume();
    }

    public void triggerScan(View view) {
        this.barcodeView.decodeSingle(this.callback);
    }

    public void goBack(View view) {
        Intent intent = new Intent();
        this.setResult(0, intent);
        this.finish();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.barcodeView.onKeyDown(keyCode, event) || super.onKeyDown(keyCode, event);
    }
}

