/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera.spin.style;

import android.animation.ValueAnimator;
import android.graphics.Rect;
import app.horses.camera.spin.animation.SpriteAnimatorBuilder;
import app.horses.camera.spin.sprite.CircleSprite;
import app.horses.camera.spin.sprite.Sprite;
import app.horses.camera.spin.sprite.SpriteContainer;

public class ThreeBounce
extends SpriteContainer {
    @Override
    public Sprite[] onCreateChild() {
        return new Sprite[]{new Bounce(), new Bounce(), new Bounce()};
    }

    @Override
    public void onChildCreated(Sprite ... sprites) {
        super.onChildCreated(sprites);
        sprites[1].setAnimationDelay(160);
        sprites[2].setAnimationDelay(320);
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        bounds = this.clipSquare(bounds);
        int radius = bounds.width() / 8;
        int top = bounds.centerY() - radius;
        int bottom = bounds.centerY() + radius;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int left = bounds.width() * i / 3 + bounds.left;
            this.getChildAt(i).setDrawBounds(left, top, left + radius * 2, bottom);
        }
    }

    private class Bounce
    extends CircleSprite {
        Bounce() {
            this.setScale(0.0f);
        }

        @Override
        public ValueAnimator onCreateAnimation() {
            float[] fractions = new float[]{0.0f, 0.4f, 0.8f, 1.0f};
            return new SpriteAnimatorBuilder(this).scale(fractions, Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)).duration(1400L).easeInOut(fractions).build();
        }
    }
}

