/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera.ui.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import app.horses.camera.CameraManager;
import app.horses.camera.R;
import app.horses.camera.util.CameraUtil;
import app.horses.camera.util.ColorUtils;
import app.horses.camera.util.Methods;
import app.horses.camera.util.SimpleAnimatorListener;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Deprecated
public class TakeActivity
extends AppCompatActivity
implements SurfaceHolder.Callback {
    private static final String TAG = TakeActivity.class.getSimpleName();
    private static final int RC_WRITESD_PERMISSIONS_REQUIRED = 101;
    private static final int PHOTO_SIZE = 1200;
    private static final int MIN_PREVIEW_PIXELS = 153600;
    private static final double MAX_ASPECT_DISTORTION = 0.15;
    public static final int CAMERA_POSITION_UNKNOWN = 0;
    public static final int CAMERA_POSITION_FRONT = 1;
    public static final int CAMERA_POSITION_BACK = 2;
    public static final int FLASH_MODE_OFF = 0;
    public static final int FLASH_MODE_ALWAYS_ON = 1;
    public static final int FLASH_MODE_AUTO = 2;
    private int cameraPosition = 0;
    private int flashMode = 0;
    private float pointX;
    private float pointY;
    private static final int FOCUS = 1;
    private static final int ZOOM = 2;
    private int mode;
    private float dist;
    private int curZoomValue = 0;
    private boolean isSquare = false;
    private int step = 0;
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    protected SurfaceView surface;
    protected LinearLayout layout;
    protected ImageView take;
    protected CropImageView preview;
    protected View shutter;
    protected View ripple;
    protected View controllersCamera;
    protected View controllersAccept;
    protected Button retry;
    protected Button save;
    private Bitmap saveBitmap = null;
    private Camera camera;
    private SurfaceHolder holder;
    private int width = 0;
    private int height = 0;
    private String folderPath;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent.hasExtra("folderPath")) {
            this.folderPath = intent.getStringExtra("folderPath");
        }
        this.initActivity();
    }

    private void initActivity() {
        this.setContentView(R.layout.activity_take);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setStatusBarColor(CameraUtil.darkenColor(ColorUtils.getPrimaryColor()));
        }
        this.setRequestedOrientation(1);
        if (CameraManager.getInstance() != null) {
            // empty if block
        }
        this.surface = (SurfaceView)this.findViewById(R.id.surface);
        this.layout = (LinearLayout)this.findViewById(R.id.layout);
        this.take = (ImageView)this.findViewById(R.id.take);
        this.preview = (CropImageView)this.findViewById(R.id.preview);
        this.shutter = this.findViewById(R.id.shutter);
        this.ripple = this.findViewById(R.id.ripple);
        this.controllersCamera = this.findViewById(R.id.camera);
        this.controllersAccept = this.findViewById(R.id.accept);
        this.retry = (Button)this.findViewById(R.id.retry);
        this.save = (Button)this.findViewById(R.id.save);
        this.layout.setBackgroundColor(ColorUtils.getPrimaryColor());
        this.width = Methods.getWidthScreen();
        this.height = Methods.getHeightScreen() - Methods.toPixels(80);
        Log.d((String)TAG, (String)("onCreate() called with: width = [" + this.width + "], height = [" + this.height + "]"));
        this.holder = this.surface.getHolder();
        this.holder.setType(3);
        this.holder.setKeepScreenOn(true);
        this.surface.setFocusable(true);
        this.surface.setBackgroundColor(40);
        this.surface.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.surface.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        TakeActivity.this.pointX = event.getX();
                        TakeActivity.this.pointY = event.getY();
                        TakeActivity.this.mode = 1;
                        break;
                    }
                    case 5: {
                        TakeActivity.this.dist = TakeActivity.this.spacing(event);
                        if (!(TakeActivity.this.spacing(event) > 10.0f)) break;
                        TakeActivity.this.mode = 2;
                        break;
                    }
                    case 1: 
                    case 6: {
                        TakeActivity.this.mode = 1;
                        break;
                    }
                    case 2: {
                        float newDist;
                        if (TakeActivity.this.mode == 1) {
                            TakeActivity.this.pointFocus((int)event.getRawX(), (int)event.getRawY());
                            break;
                        }
                        if (TakeActivity.this.mode != 2 || !((newDist = TakeActivity.this.spacing(event)) > 10.0f)) break;
                        float tScale = (newDist - TakeActivity.this.dist) / TakeActivity.this.dist;
                        if (tScale < 0.0f) {
                            tScale *= 10.0f;
                        }
                        TakeActivity.this.addZoomIn((int)tScale);
                    }
                }
                return false;
            }
        });
        this.surface.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    TakeActivity.this.pointFocus((int)TakeActivity.this.pointX, (int)TakeActivity.this.pointY);
                    TakeActivity.this.showRipple((int)TakeActivity.this.pointX, (int)TakeActivity.this.pointY);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.take.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TakeActivity.this.animateShutter();
                TakeActivity.this.previewPicture();
            }
        });
        this.save.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                File filesDir;
                Bitmap saveBitmap = TakeActivity.this.preview.getCroppedImage();
                if (TakeActivity.this.folderPath != null) {
                    filesDir = new File(TakeActivity.this.folderPath);
                    if (!filesDir.exists()) {
                        filesDir.mkdirs();
                    }
                } else {
                    filesDir = TakeActivity.this.getFilesDir();
                }
                File f = TakeActivity.this.persistImage(saveBitmap, filesDir);
                Log.i((String)TAG, (String)("file size: " + f.length() / 1024L + "kb"));
                Intent intent = new Intent();
                intent.putExtra("uri", f.getPath());
                TakeActivity.this.setResult(-1, intent);
                TakeActivity.this.finish();
                saveBitmap.recycle();
            }
        });
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TakeActivity.this.onBackPressed();
            }
        });
    }

    private File persistImage(Bitmap bitmap, File filesDir) {
        String name = String.format(filesDir + "/%s.jpg", new Date().getTime());
        File imageFile = new File(name);
        try {
            FileOutputStream os = new FileOutputStream(imageFile);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Error writing bitmap", (Throwable)e);
        }
        return imageFile;
    }

    private void showRipple(int pointX, int pointY) {
        Log.d((String)TAG, (String)("showRipple() called with: pointX = [" + pointX + "], pointY = [" + pointY + "]"));
        int size = Methods.toPixels(160);
        Log.d((String)TAG, (String)("showRipple() called with: pointX = [" + (pointX -= size / 2) + "], pointY = [" + (pointY -= size / 2) + "]"));
        this.ripple.animate().setDuration(0L).scaleX(0.0f).scaleY(0.0f).x((float)pointX).y((float)pointY).alpha(0.0f).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationStart(Animator animator) {
                TakeActivity.this.ripple.setVisibility(0);
            }

            @Override
            public void onAnimationEnd(Animator animator) {
                TakeActivity.this.ripple.animate().setDuration(300L).scaleX(1.0f).scaleY(1.0f).alpha(0.5f).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                    @Override
                    public void onAnimationEnd(Animator animator) {
                        TakeActivity.this.ripple.animate().setDuration(500L).scaleX(2.0f).scaleY(2.0f).alpha(0.2f).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                            @Override
                            public void onAnimationEnd(Animator animator) {
                                TakeActivity.this.ripple.setVisibility(8);
                            }
                        }).start();
                    }
                }).start();
            }
        }).start();
    }

    public void onBackPressed() {
        switch (this.step) {
            case 0: {
                this.setResult(0);
                this.finish();
                break;
            }
            case 1: {
                this.step = 0;
                this.surface.setVisibility(0);
                this.preview.setVisibility(8);
                this.controllersCamera.setVisibility(0);
                this.controllersAccept.setVisibility(8);
            }
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (null == this.camera) {
            try {
                this.camera = Camera.open((int)0);
                this.camera.setPreviewDisplay(this.holder);
                this.initCamera();
                this.camera.startPreview();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
        this.autoFocus();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        try {
            if (this.camera != null) {
                this.camera.stopPreview();
                this.camera.release();
                this.camera = null;
            }
        }
        catch (Exception ignored) {
            Log.d((String)TAG, (String)("surfaceDestroyed: " + ignored.toString()));
        }
    }

    private void autoFocus() {
        new Thread(){

            @Override
            public void run() {
                try {
                    7.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (TakeActivity.this.camera == null) {
                    return;
                }
                TakeActivity.this.camera.autoFocus(new Camera.AutoFocusCallback(){

                    public void onAutoFocus(boolean success, Camera camera) {
                        if (success) {
                            TakeActivity.this.initCamera();
                        }
                    }
                });
            }
        };
    }

    private void initCamera() {
        Camera.Parameters parameters = this.camera.getParameters();
        parameters.setPictureFormat(256);
        Camera.Size preview = this.findBestPreviewResolution(parameters, this.width, this.height);
        Camera.Size size = this.findBestPictureResolution(parameters, this.width, this.height);
        parameters.setPictureSize(size.width, size.height);
        parameters.setPreviewSize(preview.width, preview.height);
        parameters.setFocusMode(this.getFocusMode(parameters));
        Log.i((String)TAG, (String)("initCamera: " + this.getFocusMode(parameters)));
        this.setDisplay(parameters, this.camera);
        try {
            this.camera.setParameters(parameters);
        }
        catch (Exception e) {
            Log.wtf((String)TAG, (String)"initCamera: ", (Throwable)e);
        }
        this.camera.startPreview();
        this.camera.cancelAutoFocus();
    }

    private void previewPicture() {
        this.camera.takePicture(null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] bytes, Camera camera) {
                new PreviewImageTask().execute((Object[])new byte[][]{bytes});
            }
        });
    }

    private Camera.Size findBestPreviewResolution(Camera.Parameters parameters, int w, int h) {
        Camera.Size defaultPreviewResolution = parameters.getPreviewSize();
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            return defaultPreviewResolution;
        }
        ArrayList supportedPreviewResolutions = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPreviewResolutions, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        StringBuilder previewResolutionSb = new StringBuilder();
        for (Camera.Size supportedPreviewResolution : supportedPreviewResolutions) {
            previewResolutionSb.append(supportedPreviewResolution.width).append('x').append(supportedPreviewResolution.height).append(' ');
        }
        Log.v((String)TAG, (String)("Supported preview resolutions: " + previewResolutionSb));
        double screenAspectRatio = (double)w / (double)h;
        Iterator it = supportedPreviewResolutions.iterator();
        while (it.hasNext()) {
            int maybeFlippedHeight;
            Camera.Size supportedPreviewResolution = (Camera.Size)it.next();
            int width = supportedPreviewResolution.width;
            int height = supportedPreviewResolution.height;
            if (width * height < 153600) {
                it.remove();
                continue;
            }
            boolean isCandidatePortrait = width > height;
            int maybeFlippedWidth = isCandidatePortrait ? height : width;
            double aspectRatio = (double)maybeFlippedWidth / (double)(maybeFlippedHeight = isCandidatePortrait ? width : height);
            double distortion = Math.abs(aspectRatio - screenAspectRatio);
            if (distortion > 0.15) {
                it.remove();
                continue;
            }
            if (maybeFlippedWidth != w || maybeFlippedHeight != h) continue;
            return supportedPreviewResolution;
        }
        if (!supportedPreviewResolutions.isEmpty()) {
            return (Camera.Size)supportedPreviewResolutions.get(0);
        }
        return defaultPreviewResolution;
    }

    private Camera.Size findBestPictureResolution(Camera.Parameters parameters, int w, int h) {
        List supportedPicResolutions = parameters.getSupportedPictureSizes();
        StringBuilder picResolutionSb = new StringBuilder();
        for (Camera.Size supportedPicResolution : supportedPicResolutions) {
            picResolutionSb.append(supportedPicResolution.width).append('x').append(supportedPicResolution.height).append(" ");
        }
        Log.d((String)TAG, (String)("Supported picture resolutions: " + picResolutionSb));
        Camera.Size defaultPictureResolution = parameters.getPictureSize();
        Log.d((String)TAG, (String)("default picture resolution " + defaultPictureResolution.width + "x" + defaultPictureResolution.height));
        ArrayList sortedSupportedPicResolutions = new ArrayList(supportedPicResolutions);
        Collections.sort(sortedSupportedPicResolutions, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        double screenAspectRatio = (double)w / (double)h;
        Iterator it = sortedSupportedPicResolutions.iterator();
        while (it.hasNext()) {
            Camera.Size supportedPreviewResolution = (Camera.Size)it.next();
            int width = supportedPreviewResolution.width;
            int height = supportedPreviewResolution.height;
            boolean isCandidatePortrait = width > height;
            int maybeFlippedWidth = isCandidatePortrait ? height : width;
            int n = isCandidatePortrait ? width : height;
            int maybeFlippedHeight = n;
            double aspectRatio = (double)maybeFlippedWidth / (double)maybeFlippedHeight;
            double distortion = Math.abs(aspectRatio - screenAspectRatio);
            if (!(distortion > 0.15)) continue;
            it.remove();
        }
        if (!sortedSupportedPicResolutions.isEmpty()) {
            return (Camera.Size)sortedSupportedPicResolutions.get(0);
        }
        return defaultPictureResolution;
    }

    private String getFocusMode(Camera.Parameters parameters) {
        String mode = "auto";
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes.contains("continuous-picture")) {
            mode = "continuous-picture";
        }
        return mode;
    }

    private void setDisplay(Camera.Parameters parameters, Camera camera) {
        if (Build.VERSION.SDK_INT >= 8) {
            this.setDisplayOrientation(camera, 90);
        } else {
            parameters.setRotation(90);
        }
    }

    private void setDisplayOrientation(Camera camera, int i) {
        try {
            Method downPolymorphic = camera.getClass().getMethod("setDisplayOrientation", Integer.TYPE);
            if (downPolymorphic != null) {
                downPolymorphic.invoke((Object)camera, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private float spacing(MotionEvent event) {
        if (event == null) {
            return 0.0f;
        }
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void addZoomIn(int delta) {
        try {
            Camera.Parameters params = this.camera.getParameters();
            if (!params.isZoomSupported()) {
                return;
            }
            this.curZoomValue += delta;
            if (this.curZoomValue < 0) {
                this.curZoomValue = 0;
            } else if (this.curZoomValue > params.getMaxZoom()) {
                this.curZoomValue = params.getMaxZoom();
            }
            if (!params.isSmoothZoomSupported()) {
                params.setZoom(this.curZoomValue);
                try {
                    this.camera.setParameters(params);
                }
                catch (Exception e) {
                    Log.wtf((String)TAG, (String)"addZoomIn: ", (Throwable)e);
                }
            } else {
                this.camera.startSmoothZoom(this.curZoomValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void pointFocus(int x, int y) {
        this.camera.cancelAutoFocus();
        Camera.Parameters parameters = this.camera.getParameters();
        this.showPoint(parameters, x, y);
        try {
            this.camera.setParameters(parameters);
        }
        catch (Exception e) {
            Log.wtf((String)TAG, (String)"pointFocus: ", (Throwable)e);
        }
        this.autoFocus();
    }

    private void showPoint(Camera.Parameters parameters, int x, int y) {
        if (parameters.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> areas = new ArrayList<Camera.Area>();
            int rectY = -x * 2000 / Methods.getWidthScreen() + 1000;
            int rectX = y * 2000 / Methods.getHeightScreen() - 1000;
            int left = rectX < -900 ? -1000 : rectX - 100;
            int top = rectY < -900 ? -1000 : rectY - 100;
            int right = rectX > 900 ? 1000 : rectX + 100;
            int bottom = rectY > 900 ? 1000 : rectY + 100;
            Rect area1 = new Rect(left, top, right, bottom);
            areas.add(new Camera.Area(area1, 800));
            parameters.setMeteringAreas(areas);
        }
        parameters.setFocusMode(this.getFocusMode(parameters));
    }

    private void animateShutter() {
        this.shutter.setVisibility(0);
        this.shutter.setAlpha(0.0f);
        ObjectAnimator alphaInAnim = ObjectAnimator.ofFloat((Object)this.shutter, (String)"alpha", (float[])new float[]{0.0f, 0.8f});
        alphaInAnim.setDuration(100L);
        alphaInAnim.setStartDelay(100L);
        alphaInAnim.setInterpolator((TimeInterpolator)ACCELERATE_INTERPOLATOR);
        ObjectAnimator alphaOutAnim = ObjectAnimator.ofFloat((Object)this.shutter, (String)"alpha", (float[])new float[]{0.8f, 0.0f});
        alphaOutAnim.setDuration(200L);
        alphaOutAnim.setInterpolator((TimeInterpolator)DECELERATE_INTERPOLATOR);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(new Animator[]{alphaInAnim, alphaOutAnim});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                TakeActivity.this.shutter.setVisibility(8);
            }
        });
        animatorSet.start();
    }

    private class PreviewImageTask
    extends AsyncTask<byte[], Void, Bitmap> {
        private Context context;
        private ProgressDialog dialog;

        private PreviewImageTask() {
            this.context = TakeActivity.this;
            this.dialog = new ProgressDialog(this.context);
        }

        protected void onPreExecute() {
            this.dialog.setMessage((CharSequence)this.context.getResources().getString(R.string.dialog_loading));
            this.dialog.setIndeterminate(true);
            this.dialog.setCancelable(false);
            this.dialog.show();
        }

        protected Bitmap doInBackground(byte[] ... bytes) {
            byte[] data = bytes[0];
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Log.d((String)TAG, (String)("doInBackground() called with: width = [" + width + "], height = [" + height + "]"));
            int maxWidth = 1800;
            float newScale = (float)(1800.0 / (double)width);
            Matrix matrix = new Matrix();
            matrix.postScale(newScale, newScale);
            matrix.postRotate(90.0f);
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            bitmap.recycle();
            Log.d((String)TAG, (String)("doInBackground() called with: width = [" + resizedBitmap.getWidth() + "], height = [" + resizedBitmap.getHeight() + "]"));
            return resizedBitmap;
        }

        protected void onPostExecute(Bitmap bitmap) {
            this.dialog.dismiss();
            if (bitmap == null) {
                Log.wtf((String)TAG, (String)"onPostExecute: bitmap is null");
                TakeActivity.this.setResult(66);
                TakeActivity.this.finish();
                return;
            }
            TakeActivity.this.step = 1;
            TakeActivity.this.surface.setVisibility(8);
            TakeActivity.this.preview.setVisibility(0);
            TakeActivity.this.controllersCamera.setVisibility(8);
            TakeActivity.this.controllersAccept.setVisibility(0);
            TakeActivity.this.saveBitmap = bitmap;
            TakeActivity.this.preview.setImageBitmap(TakeActivity.this.saveBitmap);
            TakeActivity.this.preview.setFixedAspectRatio(TakeActivity.this.isSquare);
            TakeActivity.this.preview.setScaleType(CropImageView.ScaleType.CENTER_INSIDE);
        }
    }
}

