/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera.ui.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.media.ExifInterface;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageButton;
import app.horses.camera.CameraManager;
import app.horses.camera.R;
import app.horses.camera.util.CameraException;
import app.horses.camera.util.CameraUtil;
import app.horses.camera.util.ColorUtils;
import com.github.ybq.android.spinkit.SpinKitView;
import com.google.android.cameraview.CameraView;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class GetActivity
extends AppCompatActivity {
    private static final String TAG = GetActivity.class.getSimpleName();
    private int step = 0;
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private CameraView cameraView;
    private View shutter;
    private CropImageView preview;
    private View controllersCamera;
    private View controllersAccept;
    private SpinKitView spin;
    private boolean cropSquare = false;
    private boolean cropView = false;
    private final int[] flashModes = new int[]{R.drawable.ic_flash_auto_white_24dp, R.drawable.ic_flash_on_white_24dp, R.drawable.ic_flash_off_white_24dp};
    private final int[] facingModes = new int[]{R.drawable.ic_camera_front_white_24dp, R.drawable.ic_camera_rear_white_24dp};
    private int facing = 0;
    private int flash = 3;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_get);
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(CameraUtil.darkenColor(ColorUtils.getPrimaryColor()));
        }
        this.cameraView = (CameraView)this.findViewById(R.id.cameraView);
        this.shutter = this.findViewById(R.id.shutter);
        this.preview = (CropImageView)this.findViewById(R.id.preview);
        this.controllersCamera = this.findViewById(R.id.camera);
        this.controllersAccept = this.findViewById(R.id.accept);
        this.spin = (SpinKitView)this.findViewById(R.id.spin);
        this.spin.setColor(ColorUtils.getPrimaryColor());
        this.cropView = CameraManager.isCropView();
        this.cropSquare = CameraManager.isCropSquare();
        this.findViewById(R.id.flash).setVisibility(CameraManager.isFlash() ? 0 : 8);
        this.findViewById(R.id.facing).setVisibility(CameraManager.isFrontCamera() ? 0 : 8);
        this.findViewById(R.id.layout).setBackgroundColor(ColorUtils.getPrimaryColor());
        this.preview.setFixedAspectRatio(this.cropSquare);
        this.preview.setScaleType(CropImageView.ScaleType.FIT_CENTER);
        this.cameraView.addCallback(this.getCameraCallback());
        this.cameraView.setFacing(this.facing);
        this.cameraView.setFlash(this.flash);
        this.cameraView.setAutoFocus(true);
        this.cameraView.setAdjustViewBounds(true);
        this.forceMacroFocusMode();
        this.findViewById(R.id.take).setOnClickListener(this.getTakeListener());
        this.findViewById(R.id.retry).setOnClickListener(this.getRetryListener());
        this.findViewById(R.id.save).setOnClickListener(this.getSaveListener());
        this.findViewById(R.id.facing).setOnClickListener(this.getFacingListener());
        this.findViewById(R.id.flash).setOnClickListener(this.getFlashListener());
        if (!this.isFlashEnable()) {
            this.findViewById(R.id.flash).setVisibility(8);
            this.findViewById(R.id.flash).setOnClickListener(null);
            Log.wtf((String)TAG, (String)"onCreate: ", (Throwable)new CameraException("flash is not support"));
        }
        if (!this.isFrontCameraEnable()) {
            this.findViewById(R.id.facing).setVisibility(8);
            this.findViewById(R.id.facing).setOnClickListener(null);
            Log.wtf((String)TAG, (String)"onCreate: ", (Throwable)new CameraException("front camera is not support"));
        }
    }

    protected void onResume() {
        super.onResume();
        this.cameraView.start();
    }

    protected void onPause() {
        super.onPause();
        this.cameraView.stop();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onBackPressed() {
        switch (this.step) {
            case 0: {
                this.setResult(0);
                this.finish();
                break;
            }
            case 1: {
                this.step = 0;
                this.preview.setVisibility(8);
                this.controllersCamera.setVisibility(0);
                this.controllersAccept.setVisibility(8);
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.d((String)TAG, (String)("onConfigurationChanged() called with: newConfig = [" + newConfig.orientation + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap compressBitmap(byte[] data) {
        Matrix matrix = new Matrix();
        try {
            ExifInterface exif = new ExifInterface((InputStream)new ByteArrayInputStream(data));
            int orientation = exif.getAttributeInt("Orientation", 1);
            Log.d((String)TAG, (String)("compressBitmap() called with: orientation = [" + orientation + "]"));
            switch (orientation) {
                case 1: {
                    break;
                }
                case 6: 
                case 8: {
                    matrix.setRotate(90.0f);
                }
            }
        }
        catch (IOException exif) {
            // empty catch block
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        int widthBitmap = bitmap.getWidth();
        int heightBitmap = bitmap.getHeight();
        Log.d((String)TAG, (String)("compressBitmap() called with: widthBitmap = [" + widthBitmap + "], heightBitmap = [" + heightBitmap + "]"));
        if (widthBitmap > heightBitmap) {
            matrix.setRotate(90.0f);
        }
        int maxWidth = 1800;
        float newScale = (float)(1800.0 / (double)widthBitmap);
        matrix.postScale(newScale, newScale);
        if (this.facing == 1) {
            matrix.postScale(1.0f, -1.0f, newScale / 2.0f, newScale / 2.0f);
        }
        try {
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)widthBitmap, (int)heightBitmap, (Matrix)matrix, (boolean)true);
            return bitmap2;
        }
        finally {
            bitmap.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveFile(Bitmap bitmap) {
        Bitmap.CompressFormat format;
        String suffix;
        int quality = CameraManager.getQuality();
        switch (CameraManager.getFormat()) {
            case 0: {
                suffix = "jpg";
                format = Bitmap.CompressFormat.JPEG;
                break;
            }
            case 1: {
                suffix = "png";
                format = Bitmap.CompressFormat.PNG;
                break;
            }
            default: {
                suffix = "webp";
                format = Bitmap.CompressFormat.WEBP;
            }
        }
        String name = String.format(this.getCacheDir() + "/%s.%s", new Date().getTime(), suffix);
        File file = new File(name);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            bitmap.compress(format, quality, (OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("doInBackground: file=[" + name + "]"), (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
        Log.d((String)TAG, (String)("saveFile() called with: name = [" + name + "]"));
        Log.d((String)TAG, (String)("saveFile() called with: file = [" + file.length() / 1024L + "]"));
        return name;
    }

    private void savePhoto(Bitmap bitmap) {
        new AsyncTask<Bitmap, Void, String>(){

            protected String doInBackground(Bitmap ... bitmaps) {
                return GetActivity.this.saveFile(bitmaps[0]);
            }

            protected void onPostExecute(String file) {
                GetActivity.this.spin.setVisibility(8);
                Intent intent = new Intent();
                intent.putExtra("uri", file);
                GetActivity.this.setResult(-1, intent);
                GetActivity.this.finish();
            }
        }.execute((Object[])new Bitmap[]{bitmap});
    }

    private void savePhotoWithoutPreview(byte[] data) {
        new AsyncTask<byte[], Void, String>(){

            protected String doInBackground(byte[] ... bytes) {
                return GetActivity.this.saveFile(GetActivity.this.compressBitmap(bytes[0]));
            }

            protected void onPostExecute(String file) {
                GetActivity.this.spin.setVisibility(8);
                Intent intent = new Intent();
                intent.putExtra("uri", file);
                GetActivity.this.setResult(-1, intent);
                GetActivity.this.finish();
            }
        }.execute((Object[])new byte[][]{data});
    }

    private void executePreview(byte[] data) {
        new AsyncTask<byte[], Void, Bitmap>(){

            protected Bitmap doInBackground(byte[] ... bytes) {
                return GetActivity.this.compressBitmap(bytes[0]);
            }

            protected void onPostExecute(Bitmap bitmap) {
                GetActivity.this.step = 1;
                GetActivity.this.spin.setVisibility(8);
                GetActivity.this.findViewById(R.id.take).setEnabled(true);
                GetActivity.this.preview.setVisibility(0);
                GetActivity.this.controllersCamera.setVisibility(8);
                GetActivity.this.controllersAccept.setVisibility(0);
                GetActivity.this.preview.setImageBitmap(bitmap);
            }
        }.execute((Object[])new byte[][]{data});
    }

    private void animateShutter() {
        this.shutter.setVisibility(0);
        this.shutter.setAlpha(0.0f);
        ObjectAnimator alphaInAnim = ObjectAnimator.ofFloat((Object)this.shutter, (String)"alpha", (float[])new float[]{0.0f, 0.8f});
        alphaInAnim.setDuration(100L);
        alphaInAnim.setStartDelay(100L);
        alphaInAnim.setInterpolator((TimeInterpolator)ACCELERATE_INTERPOLATOR);
        ObjectAnimator alphaOutAnim = ObjectAnimator.ofFloat((Object)this.shutter, (String)"alpha", (float[])new float[]{0.8f, 0.0f});
        alphaOutAnim.setDuration(200L);
        alphaOutAnim.setInterpolator((TimeInterpolator)DECELERATE_INTERPOLATOR);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(new Animator[]{alphaInAnim, alphaOutAnim});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                GetActivity.this.shutter.setVisibility(8);
            }
        });
        animatorSet.start();
    }

    private CameraView.Callback getCameraCallback() {
        return new CameraView.Callback(){

            public void onPictureTaken(CameraView cameraView, byte[] data) {
                if (GetActivity.this.cropView) {
                    GetActivity.this.executePreview(data);
                } else {
                    GetActivity.this.savePhotoWithoutPreview(data);
                }
            }
        };
    }

    private int getNumberOfCameras() {
        return Camera.getNumberOfCameras();
    }

    private boolean isFlashEnable() {
        return this.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    private boolean isFrontCameraEnable() {
        return this.getNumberOfCameras() == 2;
    }

    private void forceMacroFocusMode() {
        this.cameraView.setFocusMode("macro");
    }

    private View.OnClickListener getFacingListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                GetActivity.this.facing = GetActivity.this.facing == 0 ? 1 : 0;
                GetActivity.this.cameraView.setFacing(GetActivity.this.facing);
                int drawable2 = GetActivity.this.facing == 0 ? GetActivity.this.facingModes[1] : GetActivity.this.facingModes[0];
                ((ImageButton)v).setImageDrawable(ContextCompat.getDrawable((Context)GetActivity.this, (int)drawable2));
                if (CameraManager.isFlash()) {
                    GetActivity.this.findViewById(R.id.flash).setVisibility(GetActivity.this.facing == 0 ? 0 : 8);
                }
            }
        };
    }

    private View.OnClickListener getFlashListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                int drawable2;
                switch (GetActivity.this.flash) {
                    case 3: {
                        drawable2 = GetActivity.this.flashModes[1];
                        GetActivity.this.flash = 1;
                        break;
                    }
                    case 1: {
                        drawable2 = GetActivity.this.flashModes[2];
                        GetActivity.this.flash = 0;
                        break;
                    }
                    default: {
                        drawable2 = GetActivity.this.flashModes[0];
                        GetActivity.this.flash = 3;
                    }
                }
                GetActivity.this.cameraView.setFlash(GetActivity.this.flash);
                ((ImageButton)v).setImageDrawable(ContextCompat.getDrawable((Context)GetActivity.this, (int)drawable2));
            }
        };
    }

    private View.OnClickListener getTakeListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                GetActivity.this.spin.setVisibility(0);
                GetActivity.this.findViewById(R.id.take).setEnabled(false);
                GetActivity.this.animateShutter();
                GetActivity.this.cameraView.takePicture();
            }
        };
    }

    private View.OnClickListener getSaveListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                GetActivity.this.spin.setVisibility(0);
                GetActivity.this.savePhoto(GetActivity.this.preview.getCroppedImage());
            }
        };
    }

    private View.OnClickListener getRetryListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                GetActivity.this.onBackPressed();
            }
        };
    }
}

