/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.ColorRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import app.horses.camera.CallbackManager;
import app.horses.camera.ui.activity.GetActivity;
import app.horses.camera.ui.activity.TakeActivity;
import app.horses.camera.util.CameraException;
import app.horses.camera.util.Methods;

public class CameraManager {
    private static final String TAG = CameraManager.class.getSimpleName();
    private CallbackManager callbackManager;
    public static final int FORMAT_JPG = 0;
    public static final int FORMAT_PNG = 1;
    public static final int FORMAT_WEBP = 2;
    private static CameraManager instance;
    private Builder builder;

    public static CameraManager getInstance() {
        return instance;
    }

    public CameraManager(Builder builder) {
        this.builder = builder;
        Methods.init((Context)builder.application);
    }

    public static void init(Application application) {
        instance = new Builder(application).build();
    }

    public static void openCamera(Activity activity) {
        activity.startActivityForResult(new Intent((Context)activity, TakeActivity.class), 3923);
    }

    public static void openCamera(Activity activity, String path) {
        Intent intent = new Intent((Context)activity, TakeActivity.class);
        intent.putExtra("folderPath", path);
        activity.startActivityForResult(intent, 3923);
    }

    public static void init(CameraManager cameraManager) {
        instance = cameraManager;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public static Application getApplication() {
        return CameraManager.instance.builder.application;
    }

    @ColorRes
    public static int getColorPrimary() {
        return CameraManager.instance.builder.primaryColor;
    }

    public static boolean isCropSquare() {
        return CameraManager.instance.builder.cropSquare;
    }

    public static boolean isCropView() {
        return CameraManager.instance.builder.cropView;
    }

    public static boolean isGallery() {
        return CameraManager.instance.builder.gallery;
    }

    public static boolean isFrontCamera() {
        return CameraManager.instance.builder.frontCamera;
    }

    public static boolean isFlash() {
        return CameraManager.instance.builder.flash;
    }

    public static int getQuality() {
        return CameraManager.instance.builder.quality;
    }

    public static int getFormat() {
        return CameraManager.instance.builder.format;
    }

    public static void openCamera2(Activity activity) {
        if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA") == -1) {
            CallbackManager.getCallback().onFailureCamera(new CameraException("permission denied for camera"));
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == -1) {
            CallbackManager.getCallback().onFailureCamera(new CameraException("permission denied for storage"));
            return;
        }
        activity.startActivityForResult(new Intent((Context)activity, GetActivity.class), 3923);
    }

    public static class Builder {
        protected String packageName = CameraManager.class.getPackage().getName();
        protected int primaryColor = 0;
        protected boolean cropSquare = false;
        protected boolean gallery = false;
        protected boolean frontCamera = false;
        protected boolean cropView = false;
        protected boolean flash = false;
        protected int quality = 100;
        protected int format = 0;
        protected Application application;

        public Builder(Application application) {
            this.application = application;
        }

        public Builder setPackageName(@StringRes int packageName) {
            this.packageName = this.application.getText(packageName).toString();
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setPrimaryColor(@ColorRes int primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public Builder enableCropSquare(boolean cropSquare) {
            this.cropSquare = cropSquare;
            return this;
        }

        public Builder enableGallery(boolean gallery) {
            this.gallery = gallery;
            return this;
        }

        public Builder enableFrontCamera(boolean frontCamera) {
            this.frontCamera = frontCamera;
            return this;
        }

        public Builder enableFlash(boolean flash) {
            this.flash = flash;
            return this;
        }

        public Builder setQuality(int quality) {
            this.quality = quality;
            return this;
        }

        public Builder setFormat(int format) {
            this.format = format;
            return this;
        }

        public Builder enableCropView(boolean cropView) {
            this.cropView = cropView;
            return this;
        }

        public CameraManager build() {
            return new CameraManager(this);
        }
    }
}

