/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import java.util.ArrayList;
import java.util.List;

public class Methods {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;

    public static void init(Context context) {
        Methods.context = context;
    }

    public static boolean isInternetConnected() {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        return isConnected;
    }

    public static boolean isWiFiEnabled() {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        return wifiManager.isWifiEnabled();
    }

    public static <E> List<E> toList(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> list = new ArrayList<E>();
        if (iterable != null) {
            for (E e : iterable) {
                list.add(e);
            }
        }
        return list;
    }

    private static Point getPoint() {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        return size;
    }

    public static int getWidthScreen() {
        return Methods.getPoint().x;
    }

    public static int getHeightScreen() {
        return Methods.getPoint().y;
    }

    public static int toPixels(int dpi) {
        float d = Methods.context.getResources().getDisplayMetrics().density;
        return (int)((float)dpi * d);
    }

    public static void hideKeyboard(View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }
}

