/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.provider.MediaStore;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import app.horses.camera.CallbackManager;
import app.horses.camera.R;
import app.horses.camera.ui.activity.TakeActivity;
import app.horses.camera.util.Methods;

public class CameraManager {
    private static final String TAG = CameraManager.class.getSimpleName();
    private CallbackManager callbackManager;
    private static CameraManager instance;
    private Builder builder;

    public static CameraManager getInstance() {
        return instance;
    }

    public CameraManager(Builder builder) {
        this.builder = builder;
        Methods.init((Context)builder.application);
    }

    public static void init(Application application) {
        instance = new Builder(application).build();
    }

    public static void openCamera(Activity activity) {
        activity.startActivityForResult(new Intent((Context)activity, TakeActivity.class), 3923);
    }

    public static void openCamera(Activity activity, String path) {
        Intent intent = new Intent((Context)activity, TakeActivity.class);
        intent.putExtra("folderPath", path);
        activity.startActivityForResult(intent, 3923);
    }

    public static void openCamera(Activity activity, String path, String filename) {
        Intent intent = new Intent((Context)activity, TakeActivity.class);
        intent.putExtra("folderPath", path);
        intent.putExtra("fileNamePath", filename);
        activity.startActivityForResult(intent, 3923);
    }

    public static void openGallery(Activity activity) {
        Intent i = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        activity.startActivityForResult(i, 102);
    }

    public static void init(CameraManager cameraManager) {
        instance = cameraManager;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public static Application getApplication() {
        return CameraManager.instance.builder.application;
    }

    public static int getColorPrimary() {
        return CameraManager.instance.builder.primaryColor;
    }

    public static class Builder {
        protected String packageName = CameraManager.class.getPackage().getName();
        protected int primaryColor = 0;
        protected int iconCaptureIcon = R.drawable.ic_camera_white_36dp;
        protected String retryText = "";
        protected String saveText = "";
        protected boolean cropEnabled = false;
        protected boolean cropSquare = false;
        protected boolean gallery = false;
        protected boolean frontCamera = false;
        protected Application application;

        public Builder(Application application) {
            this.application = application;
        }

        public Builder setPackageName(@StringRes int packageName) {
            this.packageName = this.application.getText(packageName).toString();
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setPrimaryColor(@ColorRes int primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public Builder setCaptureIcon(@DrawableRes int iconResource) {
            this.iconCaptureIcon = iconResource;
            return this;
        }

        public Builder enableCrop(boolean cropEnable) {
            this.cropEnabled = cropEnable;
            return this;
        }

        public Builder enableCropSquare(boolean cropSquare) {
            this.cropSquare = cropSquare;
            return this;
        }

        public Builder setRetryText(String text) {
            this.retryText = text;
            return this;
        }

        public Builder setSaveText(String text) {
            this.saveText = text;
            return this;
        }

        public Builder enableGallery(boolean gallery) {
            this.gallery = gallery;
            return this;
        }

        public Builder enableFrontCamera(boolean frontCamera) {
            this.frontCamera = frontCamera;
            return this;
        }

        public CameraManager build() {
            return new CameraManager(this);
        }

        public boolean isCropSquare() {
            return this.cropSquare;
        }

        public boolean isCropEnabled() {
            return this.cropEnabled;
        }

        public boolean isGallery() {
            return this.gallery;
        }

        public boolean isFrontCamera() {
            return this.frontCamera;
        }

        public int getIconCaptureIcon() {
            return this.iconCaptureIcon;
        }

        public String getRetryText() {
            return this.retryText;
        }

        public String getSaveText() {
            return this.saveText;
        }
    }
}

