/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import app.horses.camera.view.CallbackView;

public class CallbackManager {
    private static final String TAG = CallbackManager.class.getSimpleName();
    private CallbackView callback;

    public void setCallback(CallbackView callback) {
        this.callback = callback;
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        Log.d((String)TAG, (String)("onActivityResult() called with: requestCode = [" + requestCode + "], resultCode = [" + resultCode + "]"));
        if (requestCode == 3923) {
            switch (resultCode) {
                case -1: {
                    String path = data.getStringExtra("uri");
                    this.callback.successCamera(path);
                    break;
                }
                case 0: {
                    this.callback.cancelCamera();
                    break;
                }
                case 66: {
                    this.callback.errorCamera();
                }
            }
        } else if (requestCode == 102) {
            switch (resultCode) {
                case -1: {
                    Uri selectedImage = data.getData();
                    String path = this.getRealPathFromURI((Context)activity, selectedImage);
                    this.callback.successCamera(path);
                    break;
                }
                case 0: {
                    this.callback.cancelCamera();
                    break;
                }
                case 66: {
                    this.callback.errorCamera();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRealPathFromURI(Context context, Uri contentUri) {
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String string = cursor.getString(column_index);
            return string;
        }
    }
}

