/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera.spin.sprite;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Rect;
import app.horses.camera.spin.animation.AnimationUtils;
import app.horses.camera.spin.sprite.Sprite;

public abstract class SpriteContainer
extends Sprite {
    private Sprite[] sprites = this.onCreateChild();
    private int color;

    public SpriteContainer() {
        this.initCallBack();
        this.onChildCreated(this.sprites);
    }

    private void initCallBack() {
        if (this.sprites != null) {
            for (Sprite sprite : this.sprites) {
                sprite.setCallback(this);
            }
        }
    }

    public void onChildCreated(Sprite ... sprites) {
    }

    public int getChildCount() {
        return this.sprites == null ? 0 : this.sprites.length;
    }

    public Sprite getChildAt(int index) {
        return this.sprites == null ? null : this.sprites[index];
    }

    @Override
    public void setColor(int color) {
        this.color = color;
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setColor(color);
        }
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.drawChild(canvas);
    }

    public void drawChild(Canvas canvas) {
        if (this.sprites != null) {
            for (Sprite sprite : this.sprites) {
                int count = canvas.save();
                sprite.draw(canvas);
                canvas.restoreToCount(count);
            }
        }
    }

    @Override
    protected void drawSelf(Canvas canvas) {
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        for (Sprite sprite : this.sprites) {
            sprite.setBounds(bounds);
        }
    }

    @Override
    public void start() {
        super.start();
        AnimationUtils.start(this.sprites);
    }

    @Override
    public void stop() {
        super.stop();
        AnimationUtils.stop(this.sprites);
    }

    @Override
    public boolean isRunning() {
        return AnimationUtils.isRunning(this.sprites) || super.isRunning();
    }

    public abstract Sprite[] onCreateChild();

    @Override
    public ValueAnimator onCreateAnimation() {
        return null;
    }
}

