/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera.ui.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import app.horses.camera.spin.sprite.Sprite;
import app.horses.camera.spin.style.DoubleBounce;

public class DoubleBounceView
extends ProgressBar {
    private Sprite mSprite;

    public DoubleBounceView(Context context) {
        this(context, null);
    }

    public DoubleBounceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DoubleBounceView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public DoubleBounceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (!this.isInEditMode()) {
            this.init();
        }
        this.setIndeterminate(true);
    }

    private void init() {
        DoubleBounce sprite = new DoubleBounce();
        this.setIndeterminateDrawable(sprite);
    }

    public void setIndeterminateDrawable(Drawable d) {
        if (!(d instanceof Sprite)) {
            throw new IllegalArgumentException("this d must be instanceof Sprite");
        }
        this.setIndeterminateDrawable((Sprite)d);
    }

    public void setIndeterminateDrawable(Sprite d) {
        super.setIndeterminateDrawable((Drawable)d);
        this.mSprite = d;
        this.onSizeChanged(this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        if (this.getVisibility() == 0) {
            this.mSprite.start();
        }
    }

    public Sprite getIndeterminateDrawable() {
        return this.mSprite;
    }

    public void setColor(int color2) {
        if (this.mSprite != null) {
            this.mSprite.setColor(color2);
        }
        this.invalidate();
    }

    public void unscheduleDrawable(Drawable who) {
        super.unscheduleDrawable(who);
        if (who instanceof Sprite) {
            ((Sprite)who).stop();
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && this.mSprite != null && this.getVisibility() == 0) {
            this.mSprite.start();
        }
    }

    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        if (screenState == 0 && this.mSprite != null) {
            this.mSprite.stop();
        }
    }
}

