/*
 * Decompiled with CFR 0.152.
 */
package app.horses.camera;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.ColorRes;
import android.support.annotation.StringRes;
import app.horses.camera.CallbackManager;
import app.horses.camera.ui.activity.TakeActivity;
import app.horses.camera.util.Methods;

public class CameraManager {
    private static final String TAG = CameraManager.class.getSimpleName();
    private CallbackManager callbackManager;
    private static CameraManager instance;
    private Builder builder;

    public static CameraManager getInstance() {
        return instance;
    }

    public CameraManager(Builder builder) {
        this.builder = builder;
        Methods.init((Context)builder.application);
    }

    public static void init(Application application) {
        instance = new Builder(application).build();
    }

    public static void openCamera(Activity activity) {
        activity.startActivityForResult(new Intent((Context)activity, TakeActivity.class), 3923);
    }

    public static void init(CameraManager cameraManager) {
        instance = cameraManager;
    }

    public static Application getApplication() {
        return CameraManager.instance.builder.application;
    }

    public static int getColorPrimary() {
        return CameraManager.instance.builder.primaryColor;
    }

    public static class Builder {
        protected String packageName = CameraManager.class.getPackage().getName();
        protected int primaryColor = 0;
        protected boolean cropSquare = false;
        protected boolean gallery = false;
        protected boolean frontCamera = false;
        protected Application application;

        public Builder(Application application) {
            this.application = application;
        }

        public Builder setPackageName(@StringRes int packageName) {
            this.packageName = this.application.getText(packageName).toString();
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setPrimaryColor(@ColorRes int primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public Builder enableCropSquare(boolean cropSquare) {
            this.cropSquare = cropSquare;
            return this;
        }

        public Builder enableGallery(boolean gallery) {
            this.gallery = gallery;
            return this;
        }

        public Builder enableFrontCamera(boolean frontCamera) {
            this.frontCamera = frontCamera;
            return this;
        }

        public CameraManager build() {
            return new CameraManager(this);
        }
    }
}

