/*
 * Decompiled with CFR 0.152.
 */
package com.hootsuite.nachos.terminator;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import com.hootsuite.nachos.terminator.ChipTerminatorHandler;
import com.hootsuite.nachos.terminator.TextIterator;
import com.hootsuite.nachos.tokenizer.ChipTokenizer;
import java.util.HashMap;
import java.util.Map;

public class DefaultChipTerminatorHandler
implements ChipTerminatorHandler {
    @Nullable
    private Map<Character, Integer> mChipTerminators;
    private int mPasteBehavior = 2;

    @Override
    public void setChipTerminators(@Nullable Map<Character, Integer> chipTerminators) {
        this.mChipTerminators = chipTerminators;
    }

    @Override
    public void addChipTerminator(char character, int behavior) {
        if (this.mChipTerminators == null) {
            this.mChipTerminators = new HashMap<Character, Integer>();
        }
        this.mChipTerminators.put(Character.valueOf(character), behavior);
    }

    @Override
    public void setPasteBehavior(int pasteBehavior) {
        this.mPasteBehavior = pasteBehavior;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int findAndHandleChipTerminators(@NonNull ChipTokenizer tokenizer, @NonNull Editable text, int start, int end, boolean isPasteEvent) {
        if (this.mChipTerminators == null) {
            return -1;
        }
        TextIterator textIterator = new TextIterator(text, start, end);
        int selectionIndex = -1;
        while (textIterator.hasNextCharacter()) {
            char theChar = textIterator.nextCharacter();
            if (!this.isChipTerminator(theChar)) continue;
            int behavior = isPasteEvent && this.mPasteBehavior != -1 ? this.mPasteBehavior : this.mChipTerminators.get(Character.valueOf(theChar));
            int newSelection = -1;
            switch (behavior) {
                case 0: {
                    return this.handleChipifyAll(textIterator, tokenizer);
                }
                case 1: {
                    newSelection = this.handleChipifyCurrentToken(textIterator, tokenizer);
                    break;
                }
                case 2: {
                    newSelection = this.handleChipifyToTerminator(textIterator, tokenizer);
                }
            }
            if (newSelection == -1) continue;
            selectionIndex = newSelection;
        }
        return selectionIndex;
    }

    private int handleChipifyAll(TextIterator textIterator, ChipTokenizer tokenizer) {
        textIterator.deleteCharacter(true);
        tokenizer.terminateAllTokens(textIterator.getText());
        return textIterator.totalLength();
    }

    private int handleChipifyCurrentToken(TextIterator textIterator, ChipTokenizer tokenizer) {
        textIterator.deleteCharacter(true);
        Editable text = textIterator.getText();
        int index = textIterator.getIndex();
        int tokenStart = tokenizer.findTokenStart((CharSequence)text, index);
        int tokenEnd = tokenizer.findTokenEnd((CharSequence)text, index);
        if (tokenStart < tokenEnd) {
            CharSequence chippedText = tokenizer.terminateToken(text.subSequence(tokenStart, tokenEnd), null);
            textIterator.replace(tokenStart, tokenEnd, chippedText);
            return tokenStart + chippedText.length();
        }
        return -1;
    }

    private int handleChipifyToTerminator(TextIterator textIterator, ChipTokenizer tokenizer) {
        Editable text = textIterator.getText();
        int index = textIterator.getIndex();
        if (index > 0) {
            int tokenStart = tokenizer.findTokenStart((CharSequence)text, index);
            if (tokenStart < index) {
                CharSequence chippedText = tokenizer.terminateToken(text.subSequence(tokenStart, index), null);
                textIterator.replace(tokenStart, index + 1, chippedText);
            } else {
                textIterator.deleteCharacter(false);
            }
        } else {
            textIterator.deleteCharacter(false);
        }
        return -1;
    }

    private boolean isChipTerminator(char character) {
        return this.mChipTerminators != null && this.mChipTerminators.keySet().contains(Character.valueOf(character));
    }
}

