/*
 * Decompiled with CFR 0.152.
 */
package com.hootsuite.nachos;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.MultiAutoCompleteTextView;
import com.hootsuite.nachos.ChipConfiguration;
import com.hootsuite.nachos.R;
import com.hootsuite.nachos.chip.Chip;
import com.hootsuite.nachos.chip.ChipInfo;
import com.hootsuite.nachos.chip.ChipSpan;
import com.hootsuite.nachos.chip.ChipSpanChipCreator;
import com.hootsuite.nachos.terminator.ChipTerminatorHandler;
import com.hootsuite.nachos.terminator.DefaultChipTerminatorHandler;
import com.hootsuite.nachos.tokenizer.ChipTokenizer;
import com.hootsuite.nachos.tokenizer.SpanChipTokenizer;
import com.hootsuite.nachos.validator.NachoValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NachoTextView
extends MultiAutoCompleteTextView
implements TextWatcher,
AdapterView.OnItemClickListener {
    private int mChipSpacing = -1;
    private ColorStateList mChipBackground = null;
    private int mChipTextColor = -1;
    private int mChipTextSize = -1;
    private int mChipHeight = -1;
    private int mChipVerticalSpacing = -1;
    private int mDefaultPaddingTop = 0;
    private int mDefaultPaddingBottom = 0;
    private boolean mUsingDefaultPadding = true;
    @Nullable
    private OnChipClickListener mOnChipClickListener;
    private GestureDetector singleTapDetector;
    private boolean mEditChipOnTouchEnabled;
    private boolean mMoveChipToEndOnEdit;
    private boolean mChipifyUnterminatedTokensOnEdit;
    @Nullable
    private ChipTokenizer mChipTokenizer;
    @Nullable
    private ChipTerminatorHandler mChipTerminatorHandler;
    @Nullable
    private NachoValidator mNachoValidator;
    @Nullable
    private char[] mIllegalCharacters;
    private List<Chip> mChipsToRemove = new ArrayList<Chip>();
    private boolean mIgnoreTextChangedEvents;
    private int mTextChangedStart;
    private int mTextChangedEnd;
    private boolean mIsPasteEvent;
    private boolean mMeasured;
    private boolean mLayoutComplete;

    public NachoTextView(Context context) {
        super(context);
        this.init(null);
    }

    public NachoTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public NachoTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@Nullable AttributeSet attrs) {
        Context context = this.getContext();
        if (attrs != null) {
            TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NachoTextView, 0, R.style.DefaultChipSuggestionTextView);
            try {
                this.mChipSpacing = attributes.getDimensionPixelSize(R.styleable.NachoTextView_chipSpacing, -1);
                this.mChipBackground = attributes.getColorStateList(R.styleable.NachoTextView_chipBackground);
                this.mChipTextColor = attributes.getColor(R.styleable.NachoTextView_chipTextColor, -1);
                this.mChipTextSize = attributes.getDimensionPixelSize(R.styleable.NachoTextView_chipTextSize, -1);
                this.mChipHeight = attributes.getDimensionPixelSize(R.styleable.NachoTextView_chipHeight, -1);
                this.mChipVerticalSpacing = attributes.getDimensionPixelSize(R.styleable.NachoTextView_chipVerticalSpacing, -1);
            }
            finally {
                attributes.recycle();
            }
        }
        this.mDefaultPaddingTop = this.getPaddingTop();
        this.mDefaultPaddingBottom = this.getPaddingBottom();
        this.singleTapDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new SingleTapListener());
        this.setImeOptions(0x2000000);
        this.addTextChangedListener(this);
        this.setChipTokenizer(new SpanChipTokenizer<ChipSpan>(context, new ChipSpanChipCreator(), ChipSpan.class));
        this.setChipTerminatorHandler(new DefaultChipTerminatorHandler());
        this.setOnItemClickListener(this);
        this.updatePadding();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.mMeasured && this.getWidth() > 0) {
            this.invalidateChips();
            this.mMeasured = true;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mLayoutComplete) {
            this.invalidateChips();
            this.mLayoutComplete = true;
        }
    }

    private void updatePadding() {
        if (this.mChipHeight != -1) {
            boolean chipsArePresent;
            boolean bl = chipsArePresent = !this.getAllChips().isEmpty();
            if (!chipsArePresent && this.mUsingDefaultPadding) {
                this.mUsingDefaultPadding = false;
                TextPaint paint = this.getPaint();
                Paint.FontMetricsInt fm = paint.getFontMetricsInt();
                int textHeight = fm.descent - fm.ascent;
                int newTextHeight = this.mChipHeight + (this.mChipVerticalSpacing != -1 ? this.mChipVerticalSpacing : 0);
                int paddingAdjustment = (newTextHeight - textHeight) / 2;
                super.setPadding(this.getPaddingLeft(), this.mDefaultPaddingTop + paddingAdjustment, this.getPaddingRight(), this.mDefaultPaddingBottom + paddingAdjustment);
            } else if (chipsArePresent && !this.mUsingDefaultPadding) {
                this.mUsingDefaultPadding = true;
                super.setPadding(this.getPaddingLeft(), this.mDefaultPaddingTop, this.getPaddingRight(), this.mDefaultPaddingBottom);
            }
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.mDefaultPaddingTop = top;
        this.mDefaultPaddingBottom = bottom;
        this.updatePadding();
    }

    public int getChipSpacing() {
        return this.mChipSpacing;
    }

    public void setChipSpacing(@DimenRes int chipSpacingResId) {
        this.mChipSpacing = this.getContext().getResources().getDimensionPixelSize(chipSpacingResId);
        this.invalidateChips();
    }

    public ColorStateList getChipBackground() {
        return this.mChipBackground;
    }

    public void setChipBackgroundResource(@ColorRes int chipBackgroundResId) {
        this.setChipBackground(ContextCompat.getColorStateList((Context)this.getContext(), (int)chipBackgroundResId));
    }

    public void setChipBackground(ColorStateList chipBackground) {
        this.mChipBackground = chipBackground;
        this.invalidateChips();
    }

    public int getChipTextColor() {
        return this.mChipTextColor;
    }

    public void setChipTextColorResource(@ColorRes int chipTextColorResId) {
        this.setChipTextColor(ContextCompat.getColor((Context)this.getContext(), (int)chipTextColorResId));
    }

    public void setChipTextColor(@ColorInt int chipTextColor) {
        this.mChipTextColor = chipTextColor;
        this.invalidateChips();
    }

    public int getChipTextSize() {
        return this.mChipTextSize;
    }

    public void setChipTextSize(@DimenRes int chipTextSizeResId) {
        this.mChipTextSize = this.getContext().getResources().getDimensionPixelSize(chipTextSizeResId);
        this.invalidateChips();
    }

    public int getChipHeight() {
        return this.mChipHeight;
    }

    public void setChipHeight(@DimenRes int chipHeightResId) {
        this.mChipHeight = this.getContext().getResources().getDimensionPixelSize(chipHeightResId);
        this.invalidateChips();
    }

    public int getChipVerticalSpacing() {
        return this.mChipVerticalSpacing;
    }

    public void setChipVerticalSpacing(@DimenRes int chipVerticalSpacingResId) {
        this.mChipVerticalSpacing = this.getContext().getResources().getDimensionPixelSize(chipVerticalSpacingResId);
        this.invalidateChips();
    }

    @Nullable
    public ChipTokenizer getChipTokenizer() {
        return this.mChipTokenizer;
    }

    public void setChipTokenizer(@Nullable ChipTokenizer chipTokenizer) {
        this.mChipTokenizer = chipTokenizer;
        if (this.mChipTokenizer != null) {
            this.setTokenizer(new ChipTokenizerWrapper(this.mChipTokenizer));
        } else {
            this.setTokenizer(null);
        }
        this.invalidateChips();
    }

    public void setOnChipClickListener(@Nullable OnChipClickListener onChipClickListener) {
        this.mOnChipClickListener = onChipClickListener;
    }

    public void setChipTerminatorHandler(@Nullable ChipTerminatorHandler chipTerminatorHandler) {
        this.mChipTerminatorHandler = chipTerminatorHandler;
    }

    public void setNachoValidator(@Nullable NachoValidator nachoValidator) {
        this.mNachoValidator = nachoValidator;
    }

    public void setChipTerminators(@Nullable Map<Character, Integer> chipTerminators) {
        if (this.mChipTerminatorHandler != null) {
            this.mChipTerminatorHandler.setChipTerminators(chipTerminators);
        }
    }

    public void addChipTerminator(char character, int behavior) {
        if (this.mChipTerminatorHandler != null) {
            this.mChipTerminatorHandler.addChipTerminator(character, behavior);
        }
    }

    public void setPasteBehavior(int pasteBehavior) {
        if (this.mChipTerminatorHandler != null) {
            this.mChipTerminatorHandler.setPasteBehavior(pasteBehavior);
        }
    }

    public void setIllegalCharacters(char ... illegalCharacters) {
        this.mIllegalCharacters = illegalCharacters;
    }

    public void invalidateChips() {
        this.beginUnwatchedTextChange();
        if (this.mChipTokenizer != null) {
            Editable text = this.getText();
            int availableWidth = this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            ChipConfiguration configuration = new ChipConfiguration(this.mChipSpacing, this.mChipBackground, this.mChipTextColor, this.mChipTextSize, this.mChipHeight, this.mChipVerticalSpacing, availableWidth);
            this.mChipTokenizer.applyConfiguration(text, configuration);
        }
        this.endUnwatchedTextChange();
    }

    public void enableEditChipOnTouch(boolean moveChipToEnd, boolean chipifyUnterminatedTokens) {
        this.mEditChipOnTouchEnabled = true;
        this.mMoveChipToEndOnEdit = moveChipToEnd;
        this.mChipifyUnterminatedTokensOnEdit = chipifyUnterminatedTokens;
    }

    public void disableEditChipOnTouch() {
        this.mEditChipOnTouchEnabled = false;
    }

    public void setEditingChip(Chip chip, boolean moveChipToEnd) {
        if (this.mChipTokenizer == null) {
            return;
        }
        this.beginUnwatchedTextChange();
        Editable text = this.getText();
        if (moveChipToEnd) {
            text.append(chip.getText());
            this.mChipTokenizer.deleteChipAndPadding(chip, text);
            this.setSelection(text.length());
        } else {
            int chipStart = this.mChipTokenizer.findChipStart(chip, (Spanned)text);
            this.mChipTokenizer.revertChipToToken(chip, text);
            this.setSelection(this.mChipTokenizer.findTokenEnd((CharSequence)text, chipStart));
        }
        this.endUnwatchedTextChange();
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean wasHandled = false;
        this.clearChipStates();
        Chip touchedChip = this.findTouchedChip(event);
        if (touchedChip != null && this.isFocused() && this.singleTapDetector.onTouchEvent(event)) {
            touchedChip.setState(View.PRESSED_SELECTED_STATE_SET);
            if (this.onChipClicked(touchedChip)) {
                wasHandled = true;
            }
            if (this.mOnChipClickListener != null) {
                this.mOnChipClickListener.onChipClick(touchedChip, event);
            }
        }
        boolean superOnTouch = false;
        try {
            superOnTouch = super.onTouchEvent(event);
        }
        catch (NullPointerException e) {
            Log.w((String)"Nacho", (String)String.format("Error during touch event of type [%d]", event.getAction()), (Throwable)e);
        }
        return wasHandled || superOnTouch;
    }

    @Nullable
    private Chip findTouchedChip(MotionEvent event) {
        if (this.mChipTokenizer == null) {
            return null;
        }
        Editable text = this.getText();
        int offset = this.getOffsetForPosition(event.getX(), event.getY());
        List<Chip> chips = this.getAllChips();
        for (Chip chip : chips) {
            int chipStart = this.mChipTokenizer.findChipStart(chip, (Spanned)text);
            int chipEnd = this.mChipTokenizer.findChipEnd(chip, (Spanned)text);
            if (chipStart > offset || offset > chipEnd) continue;
            float startX = this.getXForIndex(chipStart);
            float endX = this.getXForIndex(chipEnd - 1);
            float eventX = event.getX();
            if (!(startX <= eventX) || !(eventX <= endX)) continue;
            return chip;
        }
        return null;
    }

    public boolean onChipClicked(Chip chip) {
        boolean wasHandled = false;
        if (this.mEditChipOnTouchEnabled) {
            if (this.mChipifyUnterminatedTokensOnEdit) {
                this.chipifyAllUnterminatedTokens();
            }
            this.setEditingChip(chip, this.mMoveChipToEndOnEdit);
            wasHandled = true;
        }
        return wasHandled;
    }

    private float getXForIndex(int index) {
        Layout layout = this.getLayout();
        return layout.getPrimaryHorizontal(index);
    }

    private void clearChipStates() {
        for (Chip chip : this.getAllChips()) {
            chip.setState(View.EMPTY_STATE_SET);
        }
    }

    public boolean onTextContextMenuItem(int id) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        switch (id) {
            case 0x1020020: {
                try {
                    this.setClipboardData(ClipData.newPlainText(null, (CharSequence)this.getTextWithPlainTextSpans(start, end)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new StringIndexOutOfBoundsException(String.format("%s \nError cutting text index [%s, %s] for text [%s] and substring [%s]", e.getMessage(), start, end, this.getText().toString(), this.getText().subSequence(start, end)));
                }
                this.getText().delete(this.getSelectionStart(), this.getSelectionEnd());
                return true;
            }
            case 0x1020021: {
                try {
                    this.setClipboardData(ClipData.newPlainText(null, (CharSequence)this.getTextWithPlainTextSpans(start, end)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new StringIndexOutOfBoundsException(String.format("%s \nError copying text index [%s, %s] for text [%s] and substring [%s]", e.getMessage(), start, end, this.getText().toString(), this.getText().subSequence(start, end)));
                }
                return true;
            }
            case 0x1020022: {
                this.mIsPasteEvent = true;
                boolean returnValue = super.onTextContextMenuItem(id);
                this.mIsPasteEvent = false;
                return returnValue;
            }
        }
        return super.onTextContextMenuItem(id);
    }

    private void setClipboardData(ClipData clip) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        clipboard.setPrimaryClip(clip);
    }

    public void performValidation() {
        if (this.mNachoValidator == null || this.mChipTokenizer == null) {
            super.performValidation();
            return;
        }
        Editable text = this.getText();
        if (!TextUtils.isEmpty((CharSequence)text) && !this.mNachoValidator.isValid(this.mChipTokenizer, (CharSequence)text)) {
            this.setRawText(this.mNachoValidator.fixText(this.mChipTokenizer, (CharSequence)text));
        }
    }

    private void beginUnwatchedTextChange() {
        this.mIgnoreTextChangedEvents = true;
    }

    private void endUnwatchedTextChange() {
        this.updatePadding();
        this.mIgnoreTextChangedEvents = false;
    }

    private void setRawText(CharSequence text) {
        this.beginUnwatchedTextChange();
        super.setText(text);
        this.endUnwatchedTextChange();
    }

    public void setText(@Nullable List<String> chipValues) {
        if (this.mChipTokenizer == null) {
            return;
        }
        this.beginUnwatchedTextChange();
        Editable text = this.getText();
        text.clear();
        if (chipValues != null) {
            for (String chipValue : chipValues) {
                CharSequence chippedText = this.mChipTokenizer.terminateToken(chipValue, null);
                text.append(chippedText);
            }
        }
        this.setSelection(text.length());
        this.endUnwatchedTextChange();
    }

    public void setTextWithChips(@Nullable List<ChipInfo> chips) {
        if (this.mChipTokenizer == null) {
            return;
        }
        this.beginUnwatchedTextChange();
        Editable text = this.getText();
        text.clear();
        if (chips != null) {
            for (ChipInfo chipInfo : chips) {
                CharSequence chippedText = this.mChipTokenizer.terminateToken(chipInfo.getText(), chipInfo.getData());
                text.append(chippedText);
            }
        }
        this.setSelection(text.length());
        this.endUnwatchedTextChange();
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
        if (this.mChipTokenizer == null) {
            return;
        }
        ListAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return;
        }
        this.beginUnwatchedTextChange();
        Object data = this.getDataForSuggestion((Adapter)adapter, position);
        CharSequence text = this.getFilter().convertResultToString(adapter.getItem(position));
        this.clearComposingText();
        int end = this.getSelectionEnd();
        Editable editable = this.getText();
        int start = this.mChipTokenizer.findTokenStart((CharSequence)editable, end);
        editable.replace(start, end, this.mChipTokenizer.terminateToken(text, data));
        this.endUnwatchedTextChange();
    }

    protected Object getDataForSuggestion(@NonNull Adapter adapter, int position) {
        return adapter.getItem(position);
    }

    protected void replaceText(CharSequence text) {
        if (this.mChipTokenizer == null) {
            super.replaceText(text);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        if (this.mIgnoreTextChangedEvents) {
            return;
        }
        this.mTextChangedStart = start;
        this.mTextChangedEnd = start + after;
        if (this.mChipTokenizer != null && count > 0 && after < count) {
            Chip[] chips;
            int end = start + count;
            Editable message = this.getText();
            for (Chip chip : chips = this.mChipTokenizer.findAllChips(start, end, (Spanned)message)) {
                int spanStart = this.mChipTokenizer.findChipStart(chip, (Spanned)message);
                int spanEnd = this.mChipTokenizer.findChipEnd(chip, (Spanned)message);
                if (spanStart >= end || spanEnd <= start) continue;
                this.mChipsToRemove.add(chip);
            }
        }
    }

    public void onTextChanged(@NonNull CharSequence textChanged, int start, int before, int count) {
    }

    public void afterTextChanged(Editable message) {
        if (this.mIgnoreTextChangedEvents) {
            return;
        }
        this.beginUnwatchedTextChange();
        if (this.mChipTokenizer != null) {
            Iterator<Chip> iterator = this.mChipsToRemove.iterator();
            while (iterator.hasNext()) {
                Chip chip = iterator.next();
                iterator.remove();
                this.mChipTokenizer.deleteChip(chip, message);
            }
        }
        if (message.length() >= this.mTextChangedEnd && message.length() >= this.mTextChangedStart) {
            this.handleTextChanged(this.mTextChangedStart, this.mTextChangedEnd);
        }
        this.endUnwatchedTextChange();
    }

    private void handleTextChanged(int start, int end) {
        int newSelectionIndex;
        if (start == end) {
            return;
        }
        Editable text = this.getText();
        CharSequence subText = text.subSequence(start, end);
        CharSequence withoutIllegalCharacters = this.removeIllegalCharacters(subText);
        if (withoutIllegalCharacters.length() < subText.length()) {
            text.replace(start, end, withoutIllegalCharacters);
            end = start + withoutIllegalCharacters.length();
            this.clearComposingText();
        }
        if (start == end) {
            return;
        }
        if (this.mChipTokenizer != null && this.mChipTerminatorHandler != null && (newSelectionIndex = this.mChipTerminatorHandler.findAndHandleChipTerminators(this.mChipTokenizer, this.getText(), start, end, this.mIsPasteEvent)) > 0) {
            this.setSelection(newSelectionIndex);
        }
    }

    private CharSequence removeIllegalCharacters(CharSequence text) {
        StringBuilder newText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char theChar = text.charAt(i);
            if (this.isIllegalCharacter(theChar)) continue;
            newText.append(theChar);
        }
        return newText;
    }

    private boolean isIllegalCharacter(char character) {
        if (this.mIllegalCharacters != null) {
            for (char c : this.mIllegalCharacters) {
                if (c != character) continue;
                return true;
            }
        }
        return false;
    }

    public void chipifyAllUnterminatedTokens() {
        this.beginUnwatchedTextChange();
        this.chipifyAllUnterminatedTokens(this.getText());
        this.endUnwatchedTextChange();
    }

    private void chipifyAllUnterminatedTokens(Editable text) {
        if (this.mChipTokenizer != null) {
            this.mChipTokenizer.terminateAllTokens(text);
        }
    }

    public void chipify(int start, int end) {
        this.beginUnwatchedTextChange();
        this.chipify(start, end, this.getText(), null);
        this.endUnwatchedTextChange();
    }

    private void chipify(int start, int end, Editable text, Object data) {
        if (this.mChipTokenizer != null) {
            CharSequence textToChip = text.subSequence(start, end);
            CharSequence chippedText = this.mChipTokenizer.terminateToken(textToChip, data);
            text.replace(start, end, chippedText);
        }
    }

    private CharSequence getTextWithPlainTextSpans(int start, int end) {
        Editable editable = this.getText();
        String selectedText = editable.subSequence(start, end).toString();
        if (this.mChipTokenizer != null) {
            List<Chip> chips = Arrays.asList(this.mChipTokenizer.findAllChips(start, end, (Spanned)editable));
            Collections.reverse(chips);
            for (Chip chip : chips) {
                String chipText = chip.getText().toString();
                int chipStart = this.mChipTokenizer.findChipStart(chip, (Spanned)editable) - start;
                int chipEnd = this.mChipTokenizer.findChipEnd(chip, (Spanned)editable) - start;
                selectedText = selectedText.substring(0, chipStart) + chipText + selectedText.substring(chipEnd, selectedText.length());
            }
        }
        return selectedText;
    }

    @NonNull
    public List<Chip> getAllChips() {
        Editable text = this.getText();
        return this.mChipTokenizer != null ? Arrays.asList(this.mChipTokenizer.findAllChips(0, text.length(), (Spanned)text)) : new ArrayList<Chip>();
    }

    @NonNull
    public List<String> getChipValues() {
        ArrayList<String> chipValues = new ArrayList<String>();
        List<Chip> chips = this.getAllChips();
        for (Chip chip : chips) {
            chipValues.add(chip.getText().toString());
        }
        return chipValues;
    }

    @NonNull
    public List<String> getTokenValues() {
        ArrayList<String> tokenValues = new ArrayList<String>();
        if (this.mChipTokenizer != null) {
            Editable text = this.getText();
            List<Pair<Integer, Integer>> unterminatedTokenIndexes = this.mChipTokenizer.findAllTokens((CharSequence)text);
            for (Pair<Integer, Integer> indexes : unterminatedTokenIndexes) {
                String tokenValue = text.subSequence(((Integer)indexes.first).intValue(), ((Integer)indexes.second).intValue()).toString();
                tokenValues.add(tokenValue);
            }
        }
        return tokenValues;
    }

    @NonNull
    public List<String> getChipAndTokenValues() {
        ArrayList<String> chipAndTokenValues = new ArrayList<String>();
        chipAndTokenValues.addAll(this.getChipValues());
        chipAndTokenValues.addAll(this.getTokenValues());
        return chipAndTokenValues;
    }

    public String toString() {
        try {
            return this.getTextWithPlainTextSpans(0, this.getText().length()).toString();
        }
        catch (ClassCastException ex) {
            return super.toString();
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new StringIndexOutOfBoundsException(String.format("%s \nError converting toString() [%s]", e.getMessage(), this.getText().toString()));
        }
    }

    private class SingleTapListener
    extends GestureDetector.SimpleOnGestureListener {
        private SingleTapListener() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return true;
        }
    }

    public static interface OnChipClickListener {
        public void onChipClick(Chip var1, MotionEvent var2);
    }

    private class ChipTokenizerWrapper
    implements MultiAutoCompleteTextView.Tokenizer {
        @NonNull
        private ChipTokenizer mChipTokenizer;

        public ChipTokenizerWrapper(ChipTokenizer chipTokenizer) {
            this.mChipTokenizer = chipTokenizer;
        }

        public int findTokenStart(CharSequence text, int cursor) {
            return this.mChipTokenizer.findTokenStart(text, cursor);
        }

        public int findTokenEnd(CharSequence text, int cursor) {
            return this.mChipTokenizer.findTokenEnd(text, cursor);
        }

        public CharSequence terminateToken(CharSequence text) {
            return this.mChipTokenizer.terminateToken(text, null);
        }
    }
}

