/*
 * Decompiled with CFR 0.152.
 */
package com.hootsuite.nachos.tokenizer;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.util.Pair;
import com.hootsuite.nachos.ChipConfiguration;
import com.hootsuite.nachos.chip.Chip;
import com.hootsuite.nachos.chip.ChipCreator;
import com.hootsuite.nachos.tokenizer.ChipTokenizer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SpanChipTokenizer<C extends Chip>
implements ChipTokenizer {
    public static final char CHIP_SPAN_SEPARATOR = '\u001f';
    public static final char AUTOCORRECT_SEPARATOR = ' ';
    private Context mContext;
    @Nullable
    private ChipConfiguration mChipConfiguration;
    @NonNull
    private ChipCreator<C> mChipCreator;
    @NonNull
    private Class<C> mChipClass;
    private Comparator<Pair<Integer, Integer>> mReverseTokenIndexesSorter = new Comparator<Pair<Integer, Integer>>(){

        @Override
        public int compare(Pair<Integer, Integer> lhs, Pair<Integer, Integer> rhs) {
            return (Integer)rhs.first - (Integer)lhs.first;
        }
    };

    public SpanChipTokenizer(Context context, @NonNull ChipCreator<C> chipCreator, @NonNull Class<C> chipClass) {
        this.mContext = context;
        this.mChipCreator = chipCreator;
        this.mChipClass = chipClass;
    }

    @Override
    public void applyConfiguration(Editable text, ChipConfiguration chipConfiguration) {
        this.mChipConfiguration = chipConfiguration;
        for (Chip chip : this.findAllChips(0, text.length(), (Spanned)text)) {
            int chipStart = this.findChipStart(chip, (Spanned)text);
            this.deleteChip(chip, text);
            text.insert(chipStart, this.terminateToken(this.mChipCreator.createChip(this.mContext, chip)));
        }
    }

    @Override
    public int findTokenStart(CharSequence text, int cursor) {
        int i;
        for (i = cursor; i > 0 && text.charAt(i - 1) != '\u001f'; --i) {
        }
        while (i > 0 && i < text.length() && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        return i;
    }

    @Override
    public int findTokenEnd(CharSequence text, int cursor) {
        int len = text.length();
        for (int i = cursor; i < len; ++i) {
            if (text.charAt(i) != '\u001f') continue;
            return i - 1;
        }
        return len;
    }

    @Override
    @NonNull
    public List<Pair<Integer, Integer>> findAllTokens(CharSequence text) {
        ArrayList<Pair<Integer, Integer>> unterminatedTokens = new ArrayList<Pair<Integer, Integer>>();
        boolean insideChip = false;
        for (int index = text.length() - 1; index >= 0; --index) {
            char theCharacter = text.charAt(index);
            if (theCharacter == '\u001f') {
                insideChip = !insideChip;
                continue;
            }
            if (Character.isWhitespace(theCharacter) || insideChip) continue;
            int tokenStart = this.findTokenStart(text, index);
            int tokenEnd = this.findTokenEnd(text, index);
            if (tokenEnd - tokenStart < 1) continue;
            unterminatedTokens.add((Pair<Integer, Integer>)new Pair((Object)tokenStart, (Object)tokenEnd));
            index = tokenStart;
        }
        return unterminatedTokens;
    }

    @Override
    public CharSequence terminateToken(CharSequence text, @Nullable Object data) {
        String trimmedText = text.toString().trim();
        return this.terminateToken(this.mChipCreator.createChip(this.mContext, trimmedText, data));
    }

    private CharSequence terminateToken(C chip) {
        String chipSeparator = Character.toString('\u001f');
        String autoCorrectSeparator = Character.toString(' ');
        String textWithSeparator = autoCorrectSeparator + chipSeparator + chip.getText() + chipSeparator + autoCorrectSeparator;
        SpannableString spannableString = new SpannableString((CharSequence)textWithSeparator);
        if (this.mChipConfiguration != null) {
            this.mChipCreator.configureChip(chip, this.mChipConfiguration);
        }
        spannableString.setSpan(chip, 0, textWithSeparator.length(), 33);
        return spannableString;
    }

    @Override
    public void terminateAllTokens(Editable text) {
        List<Pair<Integer, Integer>> unterminatedTokens = this.findAllTokens((CharSequence)text);
        Collections.sort(unterminatedTokens, this.mReverseTokenIndexesSorter);
        for (Pair<Integer, Integer> indexes : unterminatedTokens) {
            int start = (Integer)indexes.first;
            int end = (Integer)indexes.second;
            CharSequence textToChip = text.subSequence(start, end);
            CharSequence chippedText = this.terminateToken(textToChip, null);
            text.replace(start, end, chippedText);
        }
    }

    @Override
    public int findChipStart(Chip chip, Spanned text) {
        return text.getSpanStart((Object)chip);
    }

    @Override
    public int findChipEnd(Chip chip, Spanned text) {
        return text.getSpanEnd((Object)chip);
    }

    @NonNull
    public C[] findAllChips(int start, int end, Spanned text) {
        Chip[] spansArray = (Chip[])text.getSpans(start, end, this.mChipClass);
        return spansArray != null ? spansArray : (Chip[])Array.newInstance(this.mChipClass, 0);
    }

    @Override
    public void revertChipToToken(Chip chip, Editable text) {
        int chipStart = this.findChipStart(chip, (Spanned)text);
        int chipEnd = this.findChipEnd(chip, (Spanned)text);
        text.removeSpan((Object)chip);
        text.replace(chipStart, chipEnd, chip.getText());
    }

    @Override
    public void deleteChip(Chip chip, Editable text) {
        int chipStart = this.findChipStart(chip, (Spanned)text);
        int chipEnd = this.findChipEnd(chip, (Spanned)text);
        text.removeSpan((Object)chip);
        if (chipStart != chipEnd) {
            text.delete(chipStart, chipEnd);
        }
    }

    @Override
    public void deleteChipAndPadding(Chip chip, Editable text) {
        this.deleteChip(chip, text);
    }
}

