/*
 * Decompiled with CFR 0.152.
 */
package com.hootsuite.nachos.terminator;

import android.text.Editable;

public class TextIterator {
    private Editable mText;
    private int mStart;
    private int mEnd;
    private int mIndex;

    public TextIterator(Editable text, int start, int end) {
        this.mText = text;
        this.mStart = start;
        this.mEnd = end;
        this.mIndex = this.mStart - 1;
    }

    public int totalLength() {
        return this.mText.length();
    }

    public int windowLength() {
        return this.mEnd - this.mStart;
    }

    public Editable getText() {
        return this.mText;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean hasNextCharacter() {
        return this.mIndex + 1 < this.mEnd;
    }

    public char nextCharacter() {
        ++this.mIndex;
        return this.mText.charAt(this.mIndex);
    }

    public void deleteCharacter(boolean maintainIndex) {
        this.mText.replace(this.mIndex, this.mIndex + 1, (CharSequence)"");
        if (!maintainIndex) {
            --this.mIndex;
        }
        --this.mEnd;
    }

    public void replace(int replaceStart, int replaceEnd, CharSequence chippedText) {
        this.mText.replace(replaceStart, replaceEnd, chippedText);
        int newLength = chippedText.length();
        int oldLength = replaceEnd - replaceStart;
        this.mIndex = replaceStart + newLength - 1;
        this.mEnd += newLength - oldLength;
    }
}

