/*
 * Decompiled with CFR 0.152.
 */
package com.hootsuite.nachos.chip;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.style.ImageSpan;
import com.hootsuite.nachos.R;
import com.hootsuite.nachos.chip.Chip;

public class ChipSpan
extends ImageSpan
implements Chip {
    private static final float SCALE_PERCENT_OF_CHIP_HEIGHT = 0.7f;
    private static final boolean ICON_ON_LEFT_DEFAULT = true;
    private int[] mStateSet = new int[0];
    private String mEllipsis;
    private ColorStateList mDefaultBackgroundColor;
    private ColorStateList mBackgroundColor;
    private int mTextColor;
    private int mIconBackgroundColor;
    private int mTextSize = -1;
    private int mPaddingEdgePx;
    private int mPaddingBetweenImagePx;
    private int mLeftMarginPx;
    private int mRightMarginPx;
    private int mMaxAvailableWidth = -1;
    private CharSequence mText;
    private String mTextToDraw;
    private Drawable mIcon;
    private boolean mShowIconOnLeft = true;
    private int mChipVerticalSpacing = 0;
    private int mChipHeight = -1;
    private int mChipWidth = -1;
    private int mIconWidth;
    private int mCachedSize = -1;
    private Object mData;

    public ChipSpan(@NonNull Context context, @NonNull CharSequence text, @Nullable Drawable icon, Object data) {
        super(icon);
        this.mIcon = icon;
        this.mText = text;
        this.mTextToDraw = this.mText.toString();
        this.mEllipsis = context.getString(R.string.chip_ellipsis);
        this.mBackgroundColor = this.mDefaultBackgroundColor = ContextCompat.getColorStateList((Context)context, (int)R.color.chip_material_background);
        this.mTextColor = ContextCompat.getColor((Context)context, (int)R.color.chip_default_text_color);
        this.mIconBackgroundColor = ContextCompat.getColor((Context)context, (int)R.color.chip_default_icon_background_color);
        Resources resources = context.getResources();
        this.mPaddingEdgePx = resources.getDimensionPixelSize(R.dimen.chip_default_padding_edge);
        this.mPaddingBetweenImagePx = resources.getDimensionPixelSize(R.dimen.chip_default_padding_between_image);
        this.mLeftMarginPx = resources.getDimensionPixelSize(R.dimen.chip_default_left_margin);
        this.mRightMarginPx = resources.getDimensionPixelSize(R.dimen.chip_default_right_margin);
        this.mData = data;
    }

    public ChipSpan(@NonNull Context context, @NonNull ChipSpan chipSpan) {
        this(context, chipSpan.getText(), chipSpan.getDrawable(), chipSpan.getData());
        this.mDefaultBackgroundColor = chipSpan.mDefaultBackgroundColor;
        this.mTextColor = chipSpan.mTextColor;
        this.mIconBackgroundColor = chipSpan.mIconBackgroundColor;
        this.mTextSize = chipSpan.mTextSize;
        this.mPaddingEdgePx = chipSpan.mPaddingEdgePx;
        this.mPaddingBetweenImagePx = chipSpan.mPaddingBetweenImagePx;
        this.mLeftMarginPx = chipSpan.mLeftMarginPx;
        this.mRightMarginPx = chipSpan.mRightMarginPx;
        this.mMaxAvailableWidth = chipSpan.mMaxAvailableWidth;
        this.mShowIconOnLeft = chipSpan.mShowIconOnLeft;
        this.mChipVerticalSpacing = chipSpan.mChipVerticalSpacing;
        this.mChipHeight = chipSpan.mChipHeight;
        this.mStateSet = chipSpan.mStateSet;
    }

    @Override
    public Object getData() {
        return this.mData;
    }

    public void setChipHeight(int chipHeight) {
        this.mChipHeight = chipHeight;
    }

    public void setChipVerticalSpacing(int chipVerticalSpacing) {
        this.mChipVerticalSpacing = chipVerticalSpacing;
    }

    public void setTextSize(int size) {
        this.mTextSize = size;
        this.invalidateCachedSize();
    }

    public void setTextColor(int color2) {
        this.mTextColor = color2;
    }

    public void setShowIconOnLeft(boolean showIconOnLeft) {
        this.mShowIconOnLeft = showIconOnLeft;
        this.invalidateCachedSize();
    }

    public void setLeftMargin(int leftMarginPx) {
        this.mLeftMarginPx = leftMarginPx;
        this.invalidateCachedSize();
    }

    public void setRightMargin(int rightMarginPx) {
        this.mRightMarginPx = rightMarginPx;
        this.invalidateCachedSize();
    }

    public void setBackgroundColor(@Nullable ColorStateList backgroundColor) {
        this.mBackgroundColor = backgroundColor != null ? backgroundColor : this.mDefaultBackgroundColor;
    }

    public void setIconBackgroundColor(int iconBackgroundColor) {
        this.mIconBackgroundColor = iconBackgroundColor;
    }

    public void setMaxAvailableWidth(int maxAvailableWidth) {
        this.mMaxAvailableWidth = maxAvailableWidth;
        this.invalidateCachedSize();
    }

    @Override
    public void setState(int[] stateSet) {
        this.mStateSet = stateSet != null ? stateSet : new int[]{};
    }

    @Override
    public CharSequence getText() {
        return this.mText;
    }

    @Override
    public int getWidth() {
        return this.mChipWidth != -1 ? this.mLeftMarginPx + this.mChipWidth + this.mRightMarginPx : -1;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        boolean usingFontMetrics;
        boolean bl = usingFontMetrics = fm != null;
        if (usingFontMetrics) {
            this.adjustFontMetrics(paint, fm);
        }
        if (this.mCachedSize == -1 && usingFontMetrics) {
            int maxAvailableWidthMinusMargins;
            int actualWidth;
            this.mIconWidth = this.mIcon != null ? this.calculateChipHeight(fm.top, fm.bottom) : 0;
            this.mCachedSize = actualWidth = this.calculateActualWidth(paint);
            if (this.mMaxAvailableWidth != -1 && actualWidth > (maxAvailableWidthMinusMargins = this.mMaxAvailableWidth - this.mLeftMarginPx - this.mRightMarginPx)) {
                int lastCharacterIndex;
                this.mTextToDraw = this.mText + this.mEllipsis;
                while (this.calculateActualWidth(paint) > maxAvailableWidthMinusMargins && this.mTextToDraw.length() > 0 && (lastCharacterIndex = this.mTextToDraw.length() - this.mEllipsis.length() - 1) >= 0) {
                    this.mTextToDraw = this.mTextToDraw.substring(0, lastCharacterIndex) + this.mEllipsis;
                }
                this.mChipWidth = Math.max(0, maxAvailableWidthMinusMargins);
                this.mCachedSize = this.mMaxAvailableWidth;
            }
        }
        return this.mCachedSize;
    }

    private int calculateActualWidth(Paint paint) {
        if (this.mTextSize != -1) {
            paint.setTextSize((float)this.mTextSize);
        }
        int totalPadding = this.mPaddingEdgePx;
        Rect bounds = new Rect();
        paint.getTextBounds(this.mTextToDraw, 0, this.mTextToDraw.length(), bounds);
        int textWidth = bounds.width();
        totalPadding = this.mIcon != null ? (totalPadding += this.mPaddingBetweenImagePx) : (totalPadding += this.mPaddingEdgePx);
        this.mChipWidth = totalPadding + textWidth + this.mIconWidth;
        return this.getWidth();
    }

    public void invalidateCachedSize() {
        this.mCachedSize = -1;
    }

    private void adjustFontMetrics(Paint paint, Paint.FontMetricsInt fm) {
        if (this.mChipHeight != -1) {
            paint.getFontMetricsInt(fm);
            int textHeight = fm.descent - fm.ascent;
            int halfSpacing = this.mChipVerticalSpacing / 2;
            int spaceBetweenChipAndText = (this.mChipHeight - textHeight) / 2;
            int textTop = fm.top;
            int chipTop = fm.top - spaceBetweenChipAndText;
            int textBottom = fm.bottom;
            int chipBottom = fm.bottom + spaceBetweenChipAndText;
            int topOfContent = Math.min(textTop, chipTop);
            int bottomOfContent = Math.max(textBottom, chipBottom);
            int topOfContentWithSpacing = topOfContent - halfSpacing;
            int bottomOfContentWithSpacing = bottomOfContent + halfSpacing;
            fm.ascent = topOfContentWithSpacing;
            fm.descent = bottomOfContentWithSpacing;
            fm.top = topOfContentWithSpacing;
            fm.bottom = bottomOfContentWithSpacing;
        }
    }

    private int calculateChipHeight(int top, int bottom) {
        return this.mChipHeight != -1 ? this.mChipHeight : bottom - top;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        x += (float)this.mLeftMarginPx;
        if (this.mChipHeight != -1) {
            top += (bottom - top) / 2 - this.mChipHeight / 2;
            bottom = top + this.mChipHeight;
        }
        this.drawBackground(canvas, x, top, bottom, paint);
        this.drawText(canvas, x, top, bottom, paint, this.mTextToDraw);
        if (this.mIcon != null) {
            this.drawIcon(canvas, x, top, bottom, paint);
        }
    }

    private void drawBackground(Canvas canvas, float x, int top, int bottom, Paint paint) {
        int backgroundColor = this.mBackgroundColor.getColorForState(this.mStateSet, this.mBackgroundColor.getDefaultColor());
        paint.setColor(backgroundColor);
        int height = this.calculateChipHeight(top, bottom);
        RectF rect = new RectF(x, (float)top, x + (float)this.mChipWidth, (float)bottom);
        int cornerRadius = height / 2;
        canvas.drawRoundRect(rect, (float)cornerRadius, (float)cornerRadius, paint);
        paint.setColor(this.mTextColor);
    }

    private void drawText(Canvas canvas, float x, int top, int bottom, Paint paint, CharSequence text) {
        if (this.mTextSize != -1) {
            paint.setTextSize((float)this.mTextSize);
        }
        int height = this.calculateChipHeight(top, bottom);
        Paint.FontMetrics fm = paint.getFontMetrics();
        float adjustedY = (float)top + ((float)(height / 2) + (-fm.top - fm.bottom) / 2.0f);
        float adjustedX = x + (float)(this.mIcon == null || !this.mShowIconOnLeft ? this.mPaddingEdgePx : this.mIconWidth + this.mPaddingBetweenImagePx);
        canvas.drawText(text, 0, text.length(), adjustedX, adjustedY, paint);
    }

    private void drawIcon(Canvas canvas, float x, int top, int bottom, Paint paint) {
        this.drawIconBackground(canvas, x, top, bottom, paint);
        this.drawIconBitmap(canvas, x, top, bottom, paint);
    }

    private void drawIconBackground(Canvas canvas, float x, int top, int bottom, Paint paint) {
        int height = this.calculateChipHeight(top, bottom);
        paint.setColor(this.mIconBackgroundColor);
        int radius = height / 2;
        float circleX = this.mShowIconOnLeft ? x + (float)radius : x + (float)this.mChipWidth - (float)radius;
        canvas.drawCircle(circleX, (float)(top + radius), (float)radius, paint);
        paint.setColor(this.mTextColor);
    }

    private void drawIconBitmap(Canvas canvas, float x, int top, int bottom, Paint paint) {
        int height = this.calculateChipHeight(top, bottom);
        Bitmap iconBitmap = Bitmap.createBitmap((int)this.mIcon.getIntrinsicWidth(), (int)this.mIcon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Bitmap scaledIconBitMap = this.scaleDown(iconBitmap, (float)height * 0.7f, true);
        iconBitmap.recycle();
        Canvas bitmapCanvas = new Canvas(scaledIconBitMap);
        this.mIcon.setBounds(0, 0, bitmapCanvas.getWidth(), bitmapCanvas.getHeight());
        this.mIcon.draw(bitmapCanvas);
        float xInsetWithinCircle = (height - bitmapCanvas.getWidth()) / 2;
        float iconX = this.mShowIconOnLeft ? x + xInsetWithinCircle : x + (float)this.mChipWidth - (float)height + xInsetWithinCircle;
        float yInsetWithinCircle = (height - bitmapCanvas.getHeight()) / 2;
        float iconY = (float)top + yInsetWithinCircle;
        canvas.drawBitmap(scaledIconBitMap, iconX, iconY, paint);
    }

    private Bitmap scaleDown(Bitmap realImage, float maxImageSize, boolean filter) {
        float ratio = Math.min(maxImageSize / (float)realImage.getWidth(), maxImageSize / (float)realImage.getHeight());
        int width = Math.round(ratio * (float)realImage.getWidth());
        int height = Math.round(ratio * (float)realImage.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)realImage, (int)width, (int)height, (boolean)filter);
    }

    public String toString() {
        return this.mText.toString();
    }
}

