/*
 * Decompiled with CFR 0.152.
 */
package com.hongtian.easyroundimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.hongtian.easyroundimageview.R;

public class EasyRoundImageView
extends ImageView {
    private boolean hasLeftTop;
    private boolean hasRightTop;
    private boolean hasLeftBottom;
    private boolean hasRightBottom;
    private float radius;
    private Rect mDrawableRect;
    private Bitmap mBitmap;
    private BitmapShader mBitmapShader;
    private Paint mBitmapPaint;
    private Matrix mShaderMatrix;
    private int mBitmapWidth;
    private int mBitmapHeight;

    public EasyRoundImageView(Context context) {
        super(context);
    }

    public EasyRoundImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public EasyRoundImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EasyRoundImageView);
        this.hasLeftTop = typedArray.getBoolean(R.styleable.EasyRoundImageView_hasLeftTop, false);
        this.hasRightTop = typedArray.getBoolean(R.styleable.EasyRoundImageView_hasRightTop, false);
        this.hasLeftBottom = typedArray.getBoolean(R.styleable.EasyRoundImageView_hasLeftBottom, false);
        this.hasRightBottom = typedArray.getBoolean(R.styleable.EasyRoundImageView_hasRightBottom, false);
        this.radius = typedArray.getDimension(R.styleable.EasyRoundImageView_radius, 0.0f);
        typedArray.recycle();
        if (!(this.hasLeftTop || this.hasLeftBottom || this.hasRightBottom || this.hasRightTop)) {
            this.hasLeftBottom = true;
            this.hasRightBottom = true;
            this.hasLeftTop = true;
            this.hasRightTop = true;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.radius == 0.0f) {
            super.onDraw(canvas);
        } else {
            if (this.getDrawable() == null) {
                return;
            }
            RectF rect = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getRight() - this.getLeft() - this.getPaddingRight()), (float)(this.getBottom() - this.getTop() - this.getPaddingBottom()));
            Path path = new Path();
            this.halfCirclePath(rect, path);
            canvas.drawPath(path, this.mBitmapPaint);
        }
    }

    public void halfCirclePath(RectF rect, Path path) {
        float width = rect.right - rect.left;
        float height = rect.bottom - rect.top;
        if (this.radius > width / 2.0f || this.radius > height / 2.0f) {
            this.radius = Math.min(width, height) / 2.0f;
        }
        path.moveTo(rect.left + this.radius, rect.top);
        path.lineTo(rect.width() - this.radius, rect.top);
        if (this.hasRightTop) {
            path.arcTo(new RectF(rect.right - 2.0f * this.radius, rect.top, rect.right, rect.top + 2.0f * this.radius), 270.0f, 90.0f);
        } else {
            path.lineTo(rect.width(), rect.top);
        }
        path.lineTo(rect.width(), rect.bottom - this.radius);
        if (this.hasRightBottom) {
            path.arcTo(new RectF(rect.right - 2.0f * this.radius, rect.bottom - 2.0f * this.radius, rect.right, rect.bottom), 0.0f, 90.0f);
        } else {
            path.lineTo(rect.width(), rect.bottom);
        }
        path.lineTo(this.radius, rect.bottom);
        if (this.hasLeftBottom) {
            path.arcTo(new RectF(rect.left, rect.bottom - 2.0f * this.radius, rect.left + 2.0f * this.radius, rect.bottom), 90.0f, 90.0f);
        } else {
            path.lineTo(rect.left, rect.bottom);
        }
        path.lineTo(rect.left, rect.top + this.radius);
        if (this.hasLeftTop) {
            path.arcTo(new RectF(rect.left, rect.top, rect.left + 2.0f * this.radius, rect.top + 2.0f * this.radius), 180.0f, 90.0f);
        } else {
            path.lineTo(rect.left, rect.top);
        }
        path.close();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setup();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.mBitmap = bm;
        this.setup();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.mBitmap = this.getBitmapFromDrawable(drawable);
        this.setup();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap = drawable instanceof ColorDrawable ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }

    private void setup() {
        if (this.mBitmap == null) {
            return;
        }
        this.mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBitmapPaint = new Paint();
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        this.mBitmapHeight = this.mBitmap.getHeight();
        this.mBitmapWidth = this.mBitmap.getWidth();
        this.updateShaderMatrix();
        this.invalidate();
    }

    private void updateShaderMatrix() {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        this.mShaderMatrix = new Matrix();
        this.mShaderMatrix.set(null);
        this.mDrawableRect = new Rect(0, 0, this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
        if (this.mBitmapWidth * this.mDrawableRect.height() > this.mDrawableRect.width() * this.mBitmapHeight) {
            scale = (float)this.mDrawableRect.height() / (float)this.mBitmapHeight;
            dx = ((float)this.mDrawableRect.width() - (float)this.mBitmapWidth * scale) * 0.5f;
        } else {
            scale = (float)this.mDrawableRect.width() / (float)this.mBitmapWidth;
            dy = ((float)this.mDrawableRect.height() - (float)this.mBitmapHeight * scale) * 0.5f;
        }
        this.mShaderMatrix.setScale(scale, scale);
        this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        this.mBitmapShader.setLocalMatrix(this.mShaderMatrix);
    }
}

