/*
 * Decompiled with CFR 0.152.
 */
package com.hold1.pagertabsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.hold1.pagertabsindicator.R;
import com.hold1.pagertabsindicator.TabView;
import com.hold1.pagertabsindicator.TabViewProvider;

public class PagerTabsIndicator
extends HorizontalScrollView
implements ViewPager.OnPageChangeListener {
    private static final String TAG = PagerTabsIndicator.class.getSimpleName();
    public static final int TAB_INDICATOR_TOP = 0;
    public static final int TAB_INDICATOR_BOTTOM = 1;
    public static final int TAB_INDICATOR_BACKGROUND = 2;
    public static final int SCALE_FIT_XY = 0;
    public static final int SCALE_CENTER_INSIDE = 1;
    private LinearLayout tabsContainer;
    private ViewPager viewPager;
    private int textSize;
    private int indicatorType = 1;
    private int indicatorHeight = 20;
    private int indicatorBgHeight = 20;
    private int indicatorMargin = 0;
    private int indicatorColor;
    private int indicatorBgColor;
    private Drawable indicatorDrawable;
    private Paint bgPaing;
    private int indicatorResource = -1;
    private int indicatorScaleType = 1;
    private Paint tintPaint;
    private Paint dividerPaint;
    private boolean showDivider = true;
    private int dividerWidth = 2;
    private int dividerMargin = 10;
    private int tabElevation = 6;
    private int dividerColor = -16777216;
    private int dividerResource = -1;
    private Drawable dividerDrawable;
    private int textColor;
    private int tabPadding;
    private boolean lockExpanded = false;
    private boolean showBarIndicator = true;
    private boolean disableTabAnimation = false;
    private int position = 0;
    private int oldPosition = 0;
    private int targetPosition = -1;
    private float positionOffset = 0.0f;
    private int lastScrollX = 0;
    private int tabWidth = -2;
    private Runnable runnable;
    private RectF bgRect = new RectF();
    private Rect indicatorRect = new Rect();

    public PagerTabsIndicator(Context context) {
        super(context, null);
    }

    public PagerTabsIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PagerTabsIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHorizontalScrollBarEnabled(false);
        this.tabsContainer = new LinearLayout(this.getContext());
        this.addView((View)this.tabsContainer, -1, -1);
        this.textSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_text_size);
        this.indicatorHeight = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_indicator_height);
        this.indicatorBgHeight = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_indicator_bg_height);
        this.dividerWidth = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_divider_width);
        this.dividerMargin = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_divider_margin);
        this.textColor = this.getResources().getColor(R.color.tab_default_text_color);
        this.indicatorColor = this.getResources().getColor(R.color.tab_indicator_color);
        this.indicatorBgColor = this.getResources().getColor(R.color.tab_indicator_bg_color);
        this.dividerColor = this.getResources().getColor(R.color.tab_default_divider_color);
        this.tabPadding = this.getResources().getDimensionPixelSize(R.dimen.tab_default_padding);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PagerTabsIndicator);
        this.tabPadding = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_padding, this.tabPadding);
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_text_size, this.textSize);
        this.textColor = typedArray.getColor(R.styleable.PagerTabsIndicator_tab_text_color, this.textColor);
        this.showDivider = typedArray.getBoolean(R.styleable.PagerTabsIndicator_tab_show_divider, this.showDivider);
        this.lockExpanded = typedArray.getBoolean(R.styleable.PagerTabsIndicator_tab_lock_expanded, this.lockExpanded);
        this.indicatorType = typedArray.getInt(R.styleable.PagerTabsIndicator_tab_indicator, this.indicatorType);
        this.indicatorResource = typedArray.getResourceId(R.styleable.PagerTabsIndicator_tab_indicator_resource, this.indicatorResource);
        this.indicatorHeight = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_indicator_height, this.indicatorHeight);
        this.indicatorBgHeight = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_indicator_bg_height, this.indicatorBgHeight);
        this.indicatorMargin = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_indicator_margin, this.indicatorMargin);
        this.indicatorColor = typedArray.getColor(R.styleable.PagerTabsIndicator_tab_indicator_color, this.indicatorColor);
        this.indicatorBgColor = typedArray.getColor(R.styleable.PagerTabsIndicator_tab_indicator_bg_color, this.indicatorBgColor);
        this.dividerWidth = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_divider_width, this.dividerWidth);
        this.dividerMargin = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_divider_margin, this.dividerMargin);
        this.dividerColor = typedArray.getColor(R.styleable.PagerTabsIndicator_tab_divider_color, this.dividerColor);
        this.dividerResource = typedArray.getResourceId(R.styleable.PagerTabsIndicator_tab_divider_resource, this.dividerResource);
        this.showBarIndicator = typedArray.getBoolean(R.styleable.PagerTabsIndicator_tab_show_bar_indicator, this.showBarIndicator);
        this.tabElevation = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_elevation, this.tabElevation);
        this.indicatorScaleType = typedArray.getInt(R.styleable.PagerTabsIndicator_tab_indicator_scale_type, this.indicatorScaleType);
        this.disableTabAnimation = typedArray.getBoolean(R.styleable.PagerTabsIndicator_tab_disable_animation, this.disableTabAnimation);
        typedArray.recycle();
        this.prepareResources();
    }

    private void prepareResources() {
        this.bgPaing = new Paint();
        this.bgPaing.setColor(this.indicatorBgColor);
        this.bgPaing.setStyle(Paint.Style.FILL);
        this.bgPaing.setAntiAlias(true);
        this.tintPaint = new Paint();
        this.tintPaint.setColor(this.indicatorColor);
        this.tintPaint.setStyle(Paint.Style.FILL);
        this.tintPaint.setAntiAlias(true);
        this.dividerPaint = new Paint();
        this.dividerPaint.setColor(this.dividerColor);
        this.dividerPaint.setStyle(Paint.Style.FILL);
        this.dividerPaint.setAntiAlias(true);
        if (this.indicatorResource != -1) {
            this.indicatorDrawable = this.getResources().getDrawable(this.indicatorResource);
        }
        if (this.dividerResource != -1) {
            this.dividerDrawable = this.getResources().getDrawable(this.dividerResource);
        }
        ViewCompat.setElevation((View)this, (float)this.tabElevation);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        Log.d((String)TAG, (String)("layout width=" + (r - l)));
        int newWidth = r - l;
        int childCount = this.tabsContainer.getChildCount();
        if (this.lockExpanded && childCount > 0) {
            int newTabWidth = newWidth / childCount;
            if (newTabWidth == 0 || newTabWidth == this.tabWidth) {
                return;
            }
            this.tabWidth = newTabWidth;
            Log.d((String)TAG, (String)("newWidth=" + newWidth + " tabWidth=" + this.tabWidth));
            for (int i = 0; i < this.tabsContainer.getChildCount(); ++i) {
                View view = this.tabsContainer.getChildAt(i);
                view.getLayoutParams().width = this.tabWidth;
                view.requestLayout();
            }
        }
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        if (this.showBarIndicator) {
            switch (this.indicatorType) {
                case 0: {
                    lp.topMargin = this.indicatorBgHeight;
                    lp.bottomMargin = 0;
                    break;
                }
                case 1: {
                    lp.bottomMargin = this.indicatorBgHeight;
                    lp.topMargin = 0;
                }
            }
        } else {
            lp.topMargin = this.getPaddingTop();
            lp.bottomMargin = this.getPaddingBottom();
        }
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        viewPager.addOnAdapterChangeListener(new ViewPager.OnAdapterChangeListener(){

            public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
                PagerTabsIndicator.this.listenToAdapterChanges(newAdapter);
            }
        });
        this.listenToAdapterChanges(viewPager.getAdapter());
    }

    public void notifyDatasetChanged() {
        if (this.viewPager == null || this.viewPager.getAdapter() == null) {
            return;
        }
        this.tabsContainer.removeAllViews();
        for (int i = 0; i < this.viewPager.getAdapter().getCount(); ++i) {
            Object innerView;
            if (this.viewPager.getAdapter() instanceof TabViewProvider.CustomView) {
                innerView = ((TabViewProvider.CustomView)this.viewPager.getAdapter()).getView(i);
            } else if (this.viewPager.getAdapter() instanceof TabViewProvider.ImageProvider) {
                TabViewProvider.ImageProvider imageProvider = (TabViewProvider.ImageProvider)this.viewPager.getAdapter();
                innerView = this.createImageView();
                if (imageProvider.getImageUri(i) != null) {
                    Glide.with((Context)this.getContext()).load((Object)imageProvider.getImageUri(i)).into((ImageView)innerView);
                } else if (imageProvider.getImageResourceId(i) != 0) {
                    ((ImageView)innerView).setImageResource(imageProvider.getImageResourceId(i));
                }
                innerView = new TabView(this.getContext(), (View)innerView);
            } else {
                innerView = this.createTextView(this.viewPager.getAdapter().getPageTitle(i).toString());
                innerView = new TabView(this.getContext(), (View)innerView);
            }
            this.addTabView((View)innerView, i);
        }
    }

    private View createTextView(String text) {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)text);
        textView.setGravity(17);
        textView.setSingleLine();
        textView.setTextSize(0, (float)this.textSize);
        textView.setTextColor(this.textColor);
        return textView;
    }

    private View createImageView() {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setPadding(this.tabPadding, this.tabPadding, this.tabPadding, this.tabPadding);
        imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        imageView.setAdjustViewBounds(true);
        return imageView;
    }

    private void addTabView(View view, final int position) {
        this.tabsContainer.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.tabWidth, -1));
        view.setPadding(this.tabPadding, 0, this.tabPadding, 0);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Log.d((String)TAG, (String)("tab click " + position));
                PagerTabsIndicator.this.viewPager.setCurrentItem(position);
                PagerTabsIndicator.this.targetPosition = position;
            }
        });
    }

    private void listenToAdapterChanges(PagerAdapter pagerAdapter) {
        if (pagerAdapter == null) {
            Log.e((String)TAG, (String)"listenToAdapterChanges - pager adapter is null. can't register");
            return;
        }
        pagerAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                PagerTabsIndicator.this.notifyDatasetChanged();
            }

            public void onInvalidated() {
                super.onInvalidated();
            }
        });
        this.notifyDatasetChanged();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawIndicator(canvas);
        this.drawDivider(canvas);
    }

    private void drawIndicator(Canvas canvas) {
        if (!this.showBarIndicator) {
            return;
        }
        this.bgRect.left = 0.0f;
        this.bgRect.right = this.tabsContainer.getRight();
        View currentTab = this.tabsContainer.getChildAt(this.position);
        if (currentTab == null) {
            return;
        }
        if (this.disableTabAnimation) {
            currentTab = this.tabsContainer.getChildAt(Math.round((float)this.position + this.positionOffset));
        }
        this.indicatorRect.left = currentTab.getLeft();
        this.indicatorRect.right = currentTab.getRight();
        if (this.positionOffset > 0.0f && this.position < this.viewPager.getAdapter().getCount() - 1 && !this.disableTabAnimation) {
            View nextTab = this.tabsContainer.getChildAt(this.position + 1);
            this.indicatorRect.left = (int)(this.positionOffset * (float)nextTab.getLeft() + (1.0f - this.positionOffset) * (float)this.indicatorRect.left);
            this.indicatorRect.right = (int)(this.positionOffset * (float)nextTab.getRight() + (1.0f - this.positionOffset) * (float)this.indicatorRect.right);
        }
        switch (this.indicatorType) {
            case 0: {
                this.bgRect.top = 0.0f;
                this.bgRect.bottom = this.indicatorBgHeight;
                this.indicatorRect.top = this.indicatorMargin;
                this.indicatorRect.bottom = this.indicatorHeight + this.indicatorMargin;
                break;
            }
            default: {
                this.bgRect.top = this.getHeight() - this.indicatorBgHeight;
                this.bgRect.bottom = this.getHeight();
                this.indicatorRect.top = this.getHeight() - this.indicatorHeight - this.indicatorMargin;
                this.indicatorRect.bottom = this.getHeight() - this.indicatorMargin;
            }
        }
        canvas.drawRect(this.bgRect, this.bgPaing);
        if (this.indicatorDrawable == null) {
            canvas.drawRect(this.indicatorRect, this.tintPaint);
        } else {
            if (this.indicatorScaleType == 1) {
                float ratio = this.indicatorDrawable.getIntrinsicHeight() / this.indicatorDrawable.getIntrinsicWidth();
                float scaledWidth = (float)this.indicatorHeight * ratio;
                this.indicatorRect.left = (int)((float)this.indicatorRect.centerX() - scaledWidth / 2.0f);
                this.indicatorRect.right = (int)((float)this.indicatorRect.left + scaledWidth);
            }
            this.indicatorDrawable.setBounds(this.indicatorRect);
            this.indicatorDrawable.draw(canvas);
        }
    }

    private void drawDivider(Canvas canvas) {
        if (!this.showDivider) {
            return;
        }
        for (int i = 0; i < this.tabsContainer.getChildCount() - 1; ++i) {
            View tab = this.tabsContainer.getChildAt(i);
            int startX = tab.getRight() - this.dividerWidth / 2;
            int endX = startX + this.dividerWidth;
            int startY = 0;
            int endY = this.getHeight();
            if (this.indicatorType == 1) {
                startY = this.dividerMargin;
                endY = this.getHeight() - this.indicatorBgHeight - this.dividerMargin;
            } else if (this.indicatorType == 0) {
                startY = this.indicatorBgHeight + this.dividerMargin;
                endY = this.getHeight() - this.dividerMargin;
            }
            if (this.dividerDrawable == null) {
                canvas.drawRect((float)startX, (float)startY, (float)endX, (float)endY, this.dividerPaint);
                continue;
            }
            this.dividerDrawable.setBounds(new Rect(startX, startY, endX, endY));
            this.dividerDrawable.draw(canvas);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        Log.d((String)TAG, (String)("position=" + position + " offset=" + positionOffset));
        this.position = position;
        this.positionOffset = positionOffset;
        if (this.targetPosition == -1) {
            this.scrollToChild(position, (int)(positionOffset * (float)this.tabsContainer.getChildAt(position).getWidth()));
        }
        int targetPosition = Math.round((float)position + positionOffset);
        float targetOffset = (float)Math.abs(0.5 - (double)positionOffset) * 2.0f;
        for (int i = 0; i < this.tabsContainer.getChildCount(); ++i) {
            View child = this.tabsContainer.getChildAt(i);
            if (!(child instanceof TabView)) continue;
            if (i == targetPosition) {
                ((TabView)child).onOffset(targetOffset);
                continue;
            }
            ((TabView)child).onOffset(0.0f);
        }
        this.invalidate();
    }

    public void onPageSelected(int position) {
        Log.d((String)TAG, (String)("onPageSelected=" + position));
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            if (this.targetPosition != -1) {
                this.setTabSelected(this.targetPosition);
            }
            this.targetPosition = -1;
        }
    }

    public void setTabSelected(int position) {
        this.position = position;
        int tabCount = this.tabsContainer.getChildCount();
        for (int i = 0; i < tabCount; ++i) {
            boolean isSelected;
            View child = this.tabsContainer.getChildAt(i);
            boolean bl = isSelected = i == position;
            if (this.indicatorType == 2) {
                child.setSelected(isSelected);
            }
            if (!isSelected) continue;
            this.animateToTab(position);
        }
    }

    public void animateToTab(int position) {
        final View tabView = this.tabsContainer.getChildAt(position);
        if (this.runnable != null) {
            this.removeCallbacks(this.runnable);
        }
        this.runnable = new Runnable(){

            @Override
            public void run() {
                int scrollPos = tabView.getLeft() - (PagerTabsIndicator.this.getWidth() - tabView.getWidth()) / 2;
                PagerTabsIndicator.this.smoothScrollTo(scrollPos, 0);
                PagerTabsIndicator.this.runnable = null;
            }
        };
        this.post(this.runnable);
    }

    private void scrollToChild(int position, int offset) {
        View tabView = this.tabsContainer.getChildAt(position);
        int newScrollX = tabView.getLeft() - (this.getWidth() - tabView.getWidth()) / 2 + offset;
        if (newScrollX != this.lastScrollX) {
            this.lastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }

    public int getTextSize() {
        return this.textSize;
    }

    public PagerTabsIndicator setTextSize(int textSize) {
        this.textSize = textSize;
        return this;
    }

    public int getIndicatorType() {
        return this.indicatorType;
    }

    public PagerTabsIndicator setIndicatorType(int indicatorType) {
        this.indicatorType = indicatorType;
        return this;
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public PagerTabsIndicator setIndicatorHeight(int indicatorHeight) {
        this.indicatorHeight = indicatorHeight;
        return this;
    }

    public int getIndicatorBgHeight() {
        return this.indicatorBgHeight;
    }

    public PagerTabsIndicator setIndicatorBgHeight(int indicatorBgHeight) {
        this.indicatorBgHeight = indicatorBgHeight;
        return this;
    }

    public int getIndicatorMargin() {
        return this.indicatorMargin;
    }

    public PagerTabsIndicator setIndicatorMargin(int indicatorMargin) {
        this.indicatorMargin = indicatorMargin;
        return this;
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public PagerTabsIndicator setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        return this;
    }

    public int getIndicatorBgColor() {
        return this.indicatorBgColor;
    }

    public PagerTabsIndicator setIndicatorBgColor(int indicatorBgColor) {
        this.indicatorBgColor = indicatorBgColor;
        return this;
    }

    public boolean isShowDivider() {
        return this.showDivider;
    }

    public PagerTabsIndicator setShowDivider(boolean showDivider) {
        this.showDivider = showDivider;
        return this;
    }

    public int getDividerWidth() {
        return this.dividerWidth;
    }

    public PagerTabsIndicator setDividerWidth(int dividerWidth) {
        this.dividerWidth = dividerWidth;
        return this;
    }

    public int getDividerMargin() {
        return this.dividerMargin;
    }

    public PagerTabsIndicator setDividerMargin(int dividerMargin) {
        this.dividerMargin = dividerMargin;
        return this;
    }

    public int getTabElevation() {
        return this.tabElevation;
    }

    public PagerTabsIndicator setTabElevation(int tabElevation) {
        this.tabElevation = tabElevation;
        return this;
    }

    public int getDividerColor() {
        return this.dividerColor;
    }

    public PagerTabsIndicator setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public PagerTabsIndicator setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public int getTabPadding() {
        return this.tabPadding;
    }

    public PagerTabsIndicator setTabPadding(int tabPadding) {
        this.tabPadding = tabPadding;
        return this;
    }

    public boolean isLockExpanded() {
        return this.lockExpanded;
    }

    public PagerTabsIndicator setLockExpanded(boolean lockExpanded) {
        this.lockExpanded = lockExpanded;
        return this;
    }

    public boolean isShowBarIndicator() {
        return this.showBarIndicator;
    }

    public PagerTabsIndicator setShowBarIndicator(boolean showBarIndicator) {
        this.showBarIndicator = showBarIndicator;
        return this;
    }

    public boolean isDisableTabAnimation() {
        return this.disableTabAnimation;
    }

    public PagerTabsIndicator setDisableTabAnimation(boolean disableTabAnimation) {
        this.disableTabAnimation = disableTabAnimation;
        return this;
    }

    public PagerTabsIndicator setDividerResource(int dividerResource) {
        if (dividerResource == -1) {
            this.dividerDrawable = null;
        }
        this.dividerResource = dividerResource;
        return this;
    }

    public PagerTabsIndicator setIndicatorResource(int indicatorResource) {
        this.indicatorResource = indicatorResource;
        if (indicatorResource == -1) {
            this.indicatorDrawable = null;
        }
        return this;
    }

    public void refresh() {
        this.tabWidth = -2;
        this.prepareResources();
        this.notifyDatasetChanged();
    }

    public PagerTabsIndicator setHeight(int height) {
        this.getLayoutParams().height = height;
        this.requestLayout();
        return this;
    }
}

