/*
 * Decompiled with CFR 0.152.
 */
package com.hold1.pagertabsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.hold1.pagertabsindicator.R;
import com.hold1.pagertabsindicator.TabView;
import com.hold1.pagertabsindicator.TabViewProvider;

public class PagerTabsIndicator
extends HorizontalScrollView
implements ViewPager.OnPageChangeListener {
    private static final String TAG = PagerTabsIndicator.class.getSimpleName();
    private static final int TAB_INDICATOR_TOP = 0;
    private static final int TAB_INDICATOR_BOTTOM = 1;
    private static final int TAB_INDICATOR_BACKGROUND = 2;
    private LinearLayout tabsContainer;
    private ViewPager viewPager;
    private int textSize;
    private int indicatorType = 1;
    private int indicatorHeight = 20;
    private int indicatorBgHeight = 20;
    private int indicatorMargin = 0;
    private int indicatorColor;
    private int indicatorBgColor;
    private Drawable indicatorDrawable;
    private Paint bgPaing;
    private int indicatorResource = -1;
    private Paint tintPaint;
    private Paint dividerPaint;
    private boolean showDivider = true;
    private int dividerWidth = 2;
    private int dividerMargin = 10;
    private int dividerColor = -16777216;
    private int dividerResource = -1;
    private Drawable dividerDrawable;
    private int textColor;
    private int tabPadding;
    private boolean lockExpanded = false;
    private boolean hideBarIndicator = false;
    private int position = 0;
    private int targetPosition = -1;
    private float positionOffset = 0.0f;
    private int lastScrollX = 0;
    private int tabWidth = -2;
    private Runnable runnable;
    private RectF bgRect = new RectF();
    private RectF indicatorRect = new RectF();

    public PagerTabsIndicator(Context context) {
        super(context, null);
    }

    public PagerTabsIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PagerTabsIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHorizontalScrollBarEnabled(false);
        this.tabsContainer = new LinearLayout(this.getContext());
        this.addView((View)this.tabsContainer, -1, -1);
        this.textSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_text_size);
        this.indicatorHeight = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_indicator_height);
        this.indicatorBgHeight = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_indicator_bg_height);
        this.dividerWidth = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_divider_width);
        this.dividerMargin = this.getContext().getResources().getDimensionPixelSize(R.dimen.tab_default_divider_margin);
        this.textColor = this.getResources().getColor(R.color.tab_default_text_color);
        this.indicatorColor = this.getResources().getColor(R.color.tab_indicator_color);
        this.indicatorBgColor = this.getResources().getColor(R.color.tab_indicator_bg_color);
        this.dividerColor = this.getResources().getColor(R.color.tab_default_divider_color);
        this.tabPadding = this.getResources().getDimensionPixelSize(R.dimen.tab_default_padding);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PagerTabsIndicator);
        this.tabPadding = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_padding, this.tabPadding);
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_text_size, this.textSize);
        this.textColor = typedArray.getColor(R.styleable.PagerTabsIndicator_tab_text_color, this.textColor);
        this.showDivider = typedArray.getBoolean(R.styleable.PagerTabsIndicator_tab_show_divider, this.showDivider);
        this.lockExpanded = typedArray.getBoolean(R.styleable.PagerTabsIndicator_tab_lock_expanded, this.lockExpanded);
        this.indicatorType = typedArray.getInt(R.styleable.PagerTabsIndicator_tab_indicator, this.indicatorType);
        this.indicatorResource = typedArray.getResourceId(R.styleable.PagerTabsIndicator_tab_indicator_resource, this.indicatorResource);
        this.indicatorHeight = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_indicator_height, this.indicatorHeight);
        this.indicatorMargin = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_indicator_margin, this.indicatorMargin);
        this.indicatorBgHeight = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_indicator_bg_height, this.indicatorBgHeight);
        this.indicatorColor = typedArray.getColor(R.styleable.PagerTabsIndicator_tab_indicator_color, this.indicatorColor);
        this.indicatorBgColor = typedArray.getColor(R.styleable.PagerTabsIndicator_tab_indicator_bg_color, this.indicatorBgColor);
        this.dividerWidth = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_divider_width, this.dividerWidth);
        this.dividerMargin = typedArray.getDimensionPixelSize(R.styleable.PagerTabsIndicator_tab_divider_margin, this.dividerMargin);
        this.dividerColor = typedArray.getColor(R.styleable.PagerTabsIndicator_tab_divider_color, this.dividerColor);
        this.dividerResource = typedArray.getResourceId(R.styleable.PagerTabsIndicator_tab_divider_resource, this.dividerResource);
        this.hideBarIndicator = typedArray.getBoolean(R.styleable.PagerTabsIndicator_tab_hide_bar_indicator, this.hideBarIndicator);
        typedArray.recycle();
        this.bgPaing = new Paint();
        this.bgPaing.setColor(this.indicatorBgColor);
        this.bgPaing.setStyle(Paint.Style.FILL);
        this.bgPaing.setAntiAlias(true);
        this.tintPaint = new Paint();
        this.tintPaint.setColor(this.indicatorColor);
        this.tintPaint.setStyle(Paint.Style.FILL);
        this.tintPaint.setAntiAlias(true);
        this.dividerPaint = new Paint();
        this.dividerPaint.setColor(this.dividerColor);
        this.dividerPaint.setStyle(Paint.Style.FILL);
        this.dividerPaint.setAntiAlias(true);
        if (this.indicatorResource != -1) {
            this.indicatorDrawable = this.getResources().getDrawable(this.indicatorResource);
        }
        if (this.dividerResource != -1) {
            this.dividerDrawable = this.getResources().getDrawable(this.dividerResource);
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int newWidth = this.getMeasuredWidth();
        int childCount = this.tabsContainer.getChildCount();
        if (this.lockExpanded) {
            int newTabWidth = Math.round(newWidth / childCount);
            if (newTabWidth == 0 || newTabWidth == this.tabWidth) {
                return;
            }
            this.tabWidth = newTabWidth;
            for (int i = 0; i < this.tabsContainer.getChildCount(); ++i) {
                View view = this.tabsContainer.getChildAt(i);
                view.getLayoutParams().width = this.tabWidth;
            }
        }
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        if (!this.hideBarIndicator) {
            switch (this.indicatorType) {
                case 0: {
                    lp.topMargin = this.indicatorBgHeight;
                    break;
                }
                case 1: {
                    lp.bottomMargin = this.indicatorBgHeight;
                }
            }
        }
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        viewPager.addOnAdapterChangeListener(new ViewPager.OnAdapterChangeListener(){

            public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
                PagerTabsIndicator.this.listenToAdapterChanges(newAdapter);
            }
        });
        this.listenToAdapterChanges(viewPager.getAdapter());
    }

    public void notifyDatasetChanged() {
        if (this.viewPager == null || this.viewPager.getAdapter() == null) {
            return;
        }
        this.tabsContainer.removeAllViews();
        for (int i = 0; i < this.viewPager.getAdapter().getCount(); ++i) {
            View innerView;
            if (this.viewPager.getAdapter() instanceof TabViewProvider.CustomView) {
                innerView = ((TabViewProvider.CustomView)this.viewPager.getAdapter()).getView(i);
            } else if (this.viewPager.getAdapter() instanceof TabViewProvider.ImageProvider) {
                TabViewProvider.ImageProvider imageProvider = (TabViewProvider.ImageProvider)this.viewPager.getAdapter();
                innerView = this.createImageView();
                if (imageProvider.getImageUri(i) != null) {
                    Glide.with((Context)this.getContext()).load((Object)imageProvider.getImageUri(i)).into((ImageView)innerView);
                } else if (imageProvider.getImageResourceId(this.position) != 0) {
                    ((ImageView)innerView).setImageResource(imageProvider.getImageResourceId(this.position));
                }
            } else {
                innerView = this.createTextView(this.viewPager.getAdapter().getPageTitle(i).toString());
            }
            TabView tabView = new TabView(this.getContext());
            tabView.addView(innerView);
            this.addTabView((View)tabView, i);
        }
    }

    private View createTextView(String text) {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)text);
        textView.setGravity(17);
        textView.setSingleLine();
        textView.setTextSize(0, (float)this.textSize);
        textView.setTextColor(this.textColor);
        return textView;
    }

    private View createImageView() {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        return imageView;
    }

    private void addTabView(View view, final int position) {
        this.tabsContainer.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.tabWidth, -1));
        view.setPadding(50, 0, 50, 0);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PagerTabsIndicator.this.viewPager.setCurrentItem(position);
                PagerTabsIndicator.this.targetPosition = position;
            }
        });
    }

    private void listenToAdapterChanges(PagerAdapter pagerAdapter) {
        if (pagerAdapter == null) {
            Log.e((String)TAG, (String)"listenToAdapterChanges - pager adapter is null. can't register");
            return;
        }
        pagerAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                PagerTabsIndicator.this.notifyDatasetChanged();
            }

            public void onInvalidated() {
                super.onInvalidated();
            }
        });
        this.notifyDatasetChanged();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.hideBarIndicator) {
            this.bgRect.left = 0.0f;
            this.bgRect.right = this.tabsContainer.getRight();
            View currentTab = this.tabsContainer.getChildAt(this.position);
            this.indicatorRect.left = currentTab.getLeft();
            this.indicatorRect.right = currentTab.getRight();
            if (this.positionOffset > 0.0f && this.position < this.viewPager.getAdapter().getCount() - 1) {
                View nextTab = this.tabsContainer.getChildAt(this.position + 1);
                this.indicatorRect.left = this.positionOffset * (float)nextTab.getLeft() + (1.0f - this.positionOffset) * this.indicatorRect.left;
                this.indicatorRect.right = this.positionOffset * (float)nextTab.getRight() + (1.0f - this.positionOffset) * this.indicatorRect.right;
            }
            switch (this.indicatorType) {
                case 0: {
                    this.bgRect.top = 0.0f;
                    this.bgRect.bottom = this.indicatorHeight;
                    this.indicatorRect.top = this.indicatorMargin;
                    this.indicatorRect.bottom = this.indicatorHeight + this.indicatorMargin;
                    break;
                }
                default: {
                    this.bgRect.top = this.getHeight() - this.indicatorHeight;
                    this.bgRect.bottom = this.getHeight();
                    this.indicatorRect.top = this.getHeight() - this.indicatorHeight - this.indicatorMargin;
                    this.indicatorRect.bottom = this.getHeight() - this.indicatorMargin;
                }
            }
            canvas.drawRect(this.bgRect, this.bgPaing);
            canvas.drawRect(this.indicatorRect, this.tintPaint);
        }
        if (!this.showDivider) {
            return;
        }
        this.drawDivider(canvas);
    }

    private void drawDivider(Canvas canvas) {
        for (int i = 0; i < this.tabsContainer.getChildCount() - 1; ++i) {
            View tab = this.tabsContainer.getChildAt(i);
            int startX = tab.getRight() - this.dividerWidth / 2;
            int endX = startX + this.dividerWidth;
            int startY = 0;
            int endY = this.getHeight();
            if (this.indicatorType == 1) {
                startY = this.dividerMargin;
                endY = this.getHeight() - this.indicatorBgHeight - this.dividerMargin;
            } else if (this.indicatorType == 0) {
                startY = this.indicatorBgHeight + this.dividerMargin;
                endY = this.getHeight() - this.dividerMargin;
            }
            if (this.dividerDrawable == null) {
                canvas.drawRect((float)startX, (float)startY, (float)endX, (float)endY, this.dividerPaint);
                continue;
            }
            this.dividerDrawable.setBounds(new Rect(startX, startY, endX, endY));
            this.dividerDrawable.draw(canvas);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        Log.d((String)TAG, (String)("position=" + position + " positionOffset=" + positionOffset + "  pixels=" + positionOffsetPixels));
        this.position = position;
        this.positionOffset = positionOffset;
        if (this.targetPosition == -1) {
            this.scrollToChild(position, (int)(positionOffset * (float)this.tabsContainer.getChildAt(position).getWidth()));
        }
        this.invalidate();
    }

    public void onPageSelected(int position) {
        Log.d((String)TAG, (String)("onPageSelected=" + position));
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            if (this.targetPosition != -1) {
                this.setTabSelected(this.targetPosition);
            }
            this.targetPosition = -1;
        }
    }

    public void setTabSelected(int position) {
        this.position = position;
        int tabCount = this.tabsContainer.getChildCount();
        for (int i = 0; i < tabCount; ++i) {
            boolean isSelected;
            View child = this.tabsContainer.getChildAt(i);
            boolean bl = isSelected = i == position;
            if (this.indicatorType == 2) {
                child.setSelected(isSelected);
            }
            if (!isSelected) continue;
            this.animateToTab(position);
        }
    }

    public void animateToTab(int position) {
        final View tabView = this.tabsContainer.getChildAt(position);
        if (this.runnable != null) {
            this.removeCallbacks(this.runnable);
        }
        this.runnable = new Runnable(){

            @Override
            public void run() {
                int scrollPos = tabView.getLeft() - (PagerTabsIndicator.this.getWidth() - tabView.getWidth()) / 2;
                PagerTabsIndicator.this.smoothScrollTo(scrollPos, 0);
                PagerTabsIndicator.this.runnable = null;
            }
        };
        this.post(this.runnable);
    }

    private void scrollToChild(int position, int offset) {
        View tabView = this.tabsContainer.getChildAt(position);
        int newScrollX = tabView.getLeft() - (this.getWidth() - tabView.getWidth()) / 2 + offset;
        if (newScrollX != this.lastScrollX) {
            this.lastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }
}

