/*
 * Decompiled with CFR 0.152.
 */
package com.hold1.bubblegum;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.AnimationDrawable;
import android.os.SystemClock;
import android.util.Log;
import com.hold1.bubblegum.Gradient;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u00020*H\u0002J\u0012\u00101\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u00020\u0003H\u0002J\u0012\u00105\u001a\u00020/2\b\u00106\u001a\u0004\u0018\u000107H\u0014J\b\u00108\u001a\u00020/H\u0016J\u000e\u00109\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010:\u001a\u00020/H\u0016J\b\u0010;\u001a\u00020/H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0007R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010\u001bR\u000e\u0010(\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/hold1/bubblegum/GradientDrawable;", "Landroid/graphics/drawable/AnimationDrawable;", "gradient", "Lcom/hold1/bubblegum/Gradient;", "(Lcom/hold1/bubblegum/Gradient;)V", "colors", "", "([Lcom/hold1/bubblegum/Gradient;)V", "FRAME_DELAY", "", "getColors", "()[Lcom/hold1/bubblegum/Gradient;", "setColors", "[Lcom/hold1/bubblegum/Gradient;", "currentGradient", "currentIndex", "", "elapsed", "getElapsed", "()J", "setElapsed", "(J)V", "fadeInFromBlank", "", "getFadeInFromBlank", "()Z", "setFadeInFromBlank", "(Z)V", "innerColor", "loopDuration", "getLoopDuration", "()I", "setLoopDuration", "(I)V", "loopInterval", "getLoopInterval", "setLoopInterval", "oneTimeLoop", "getOneTimeLoop", "setOneTimeLoop", "outerColor", "paint1", "Landroid/graphics/Paint;", "paint2", "radialPaint", "running", "applyGradient", "", "paint", "draw", "canvas", "Landroid/graphics/Canvas;", "getNextGradient", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "run", "setGradient", "start", "stop", "Companion", "bubblegum_release"})
public final class GradientDrawable
extends AnimationDrawable {
    private Gradient currentGradient;
    private int innerColor;
    private int outerColor;
    private Paint paint1;
    private Paint paint2;
    private Paint radialPaint;
    private final long FRAME_DELAY = 16L;
    private boolean running;
    private int loopDuration;
    private int loopInterval;
    private int currentIndex;
    private boolean oneTimeLoop;
    private boolean fadeInFromBlank;
    private long elapsed;
    @NotNull
    private Gradient[] colors;
    private static final int defaultStartColor = -2203038;
    private static final int defaultEndColor = -18292;
    public static final Companion Companion = new Companion(null);

    public final int getLoopDuration() {
        return this.loopDuration;
    }

    public final void setLoopDuration(int n) {
        this.loopDuration = n;
    }

    public final int getLoopInterval() {
        return this.loopInterval;
    }

    public final void setLoopInterval(int n) {
        this.loopInterval = n;
    }

    public final boolean getOneTimeLoop() {
        return this.oneTimeLoop;
    }

    public final void setOneTimeLoop(boolean bl) {
        this.oneTimeLoop = bl;
    }

    public final boolean getFadeInFromBlank() {
        return this.fadeInFromBlank;
    }

    public final void setFadeInFromBlank(boolean bl) {
        this.fadeInFromBlank = bl;
    }

    private final void applyGradient(Gradient gradient, Paint paint) {
        int[] nArray = gradient.getColors();
        if (nArray.length >= 2) {
            Integer n = gradient.getAngle() != null ? gradient.getAngle() : Integer.valueOf(35);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            int angle = -n.intValue();
            int radius = (this.getBounds().width() + this.getBounds().height()) / 4;
            double startX = (double)this.getBounds().centerX() + (double)radius * Math.cos(Math.toRadians((double)-180 + (double)angle));
            double startY = (double)this.getBounds().centerY() + (double)radius * Math.sin(Math.toRadians((double)-180 + (double)angle));
            double endX = (double)this.getBounds().centerX() + (double)radius * Math.cos(Math.toRadians(angle));
            double endY = (double)this.getBounds().centerY() + (double)radius * Math.sin(Math.toRadians(angle));
            paint.setShader((Shader)new LinearGradient((float)startX, (float)startY, (float)endX, (float)endY, gradient.getColors(), gradient.getPositions(), Shader.TileMode.CLAMP));
        }
    }

    public final void setGradient(@NotNull Gradient gradient) {
        Intrinsics.checkParameterIsNotNull((Object)gradient, (String)"gradient");
        this.oneTimeLoop = true;
        this.colors = (Gradient[])ArraysKt.plus((Object[])this.colors, (Object)gradient);
        this.start();
    }

    protected void onBoundsChange(@Nullable Rect bounds) {
        super.onBoundsChange(bounds);
        if (this.currentGradient != null) {
            Gradient gradient = this.currentGradient;
            if (gradient == null) {
                Intrinsics.throwNpe();
            }
            Paint paint = this.paint1;
            if (paint == null) {
                Intrinsics.throwNpe();
            }
            this.applyGradient(gradient, paint);
        }
        if (this.radialPaint != null) {
            Paint paint = this.radialPaint;
            if (paint == null) {
                Intrinsics.throwNpe();
            }
            Rect rect = bounds;
            if (rect == null) {
                Intrinsics.throwNpe();
            }
            paint.setShader((Shader)new RadialGradient(0.25f * (float)rect.width(), 0.8f * (float)bounds.height(), Math.max((float)bounds.width(), (float)bounds.height()), this.innerColor, this.outerColor, Shader.TileMode.CLAMP));
        }
    }

    public final long getElapsed() {
        return this.elapsed;
    }

    public final void setElapsed(long l) {
        this.elapsed = l;
    }

    public void draw(@Nullable Canvas canvas) {
        if (this.running) {
            double progress = Math.min((double)this.elapsed / (double)this.loopDuration, 1.0);
            Log.d((String)"GradientDrawable", (String)("progress " + progress));
            if (this.paint2 != null) {
                Paint paint = this.paint2;
                if (paint == null) {
                    Intrinsics.throwNpe();
                }
                paint.setAlpha((int)(progress * (double)255));
            }
        }
        Canvas canvas2 = canvas;
        if (canvas2 == null) {
            Intrinsics.throwNpe();
        }
        canvas2.drawRect(0.0f, 0.0f, (float)this.getBounds().width(), (float)this.getBounds().height(), this.paint1);
        if (this.paint2 != null) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getBounds().width(), (float)this.getBounds().height(), this.paint2);
        }
        canvas.drawRect(0.0f, 0.0f, (float)this.getBounds().width(), (float)this.getBounds().height(), this.radialPaint);
    }

    public void start() {
        this.elapsed = Long.MAX_VALUE;
        if (((Object[])this.colors).length < 2) {
            return;
        }
        if (this.running) {
            this.stop();
        }
        this.running = true;
        this.invalidateSelf();
        this.scheduleSelf((Runnable)((Object)this), SystemClock.uptimeMillis() + this.FRAME_DELAY);
    }

    public void stop() {
        this.unscheduleSelf((Runnable)((Object)this));
        this.running = false;
    }

    public void run() {
        this.invalidateSelf();
        long uptimeMillis = SystemClock.uptimeMillis();
        if (this.elapsed < (long)this.loopDuration) {
            this.elapsed += this.FRAME_DELAY;
            this.scheduleSelf((Runnable)((Object)this), uptimeMillis + this.FRAME_DELAY);
        } else if (this.oneTimeLoop && this.currentIndex == ((Object[])this.colors).length - 1) {
            this.running = false;
        } else if (this.elapsed < (long)(this.loopDuration + this.loopInterval)) {
            this.elapsed += (long)this.loopInterval;
            this.scheduleSelf((Runnable)((Object)this), uptimeMillis + this.FRAME_DELAY + (long)this.loopInterval);
        } else {
            if (this.paint2 != null) {
                this.paint1 = this.paint2;
            }
            Paint paint = this.paint2 = new Paint();
            if (paint == null) {
                Intrinsics.throwNpe();
            }
            paint.setColor(0);
            this.elapsed = 0L;
            Gradient gradient = this.getNextGradient();
            Paint paint2 = this.paint2;
            if (paint2 == null) {
                Intrinsics.throwNpe();
            }
            this.applyGradient(gradient, paint2);
            this.scheduleSelf((Runnable)((Object)this), uptimeMillis + this.FRAME_DELAY);
        }
    }

    private final Gradient getNextGradient() {
        this.currentIndex = (this.currentIndex + 1) % ((Object[])this.colors).length;
        return this.colors[this.currentIndex];
    }

    @NotNull
    public final Gradient[] getColors() {
        return this.colors;
    }

    public final void setColors(@NotNull Gradient[] gradientArray) {
        Intrinsics.checkParameterIsNotNull((Object)gradientArray, (String)"<set-?>");
        this.colors = gradientArray;
    }

    public GradientDrawable(@NotNull Gradient[] colors) {
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        this.colors = colors;
        this.outerColor = (int)0xAA000000L;
        this.FRAME_DELAY = 16;
        this.loopDuration = 800;
        this.loopInterval = 1000;
        if (!this.fadeInFromBlank) {
            this.currentGradient = ((Object[])this.colors).length > 0 ? this.colors[0] : new Gradient(new int[]{Companion.getDefaultStartColor(), Companion.getDefaultEndColor()});
        }
        Paint paint = this.paint1 = new Paint();
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setColor(-1);
        Paint paint2 = this.radialPaint = new Paint();
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setColor(-1);
    }

    public GradientDrawable(@NotNull Gradient gradient) {
        Intrinsics.checkParameterIsNotNull((Object)gradient, (String)"gradient");
        this(new Gradient[]{gradient});
    }

    static {
        defaultStartColor = (int)4292764258L;
        defaultEndColor = (int)4294949004L;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/hold1/bubblegum/GradientDrawable$Companion;", "", "()V", "defaultEndColor", "", "getDefaultEndColor", "()I", "defaultStartColor", "getDefaultStartColor", "bubblegum_release"})
    public static final class Companion {
        public final int getDefaultStartColor() {
            return defaultStartColor;
        }

        public final int getDefaultEndColor() {
            return defaultEndColor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

