/*
 * Decompiled with CFR 0.152.
 */
package com.hold1.bubblegum;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import com.hold1.bubblegum.Gradient;
import com.hold1.bubblegum.GradientDrawable;
import com.hold1.bubblegum.R;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0019\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u0012R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/hold1/bubblegum/BubbleView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backgroundDraw", "Lcom/hold1/bubblegum/GradientDrawable;", "getBackgroundDraw", "()Lcom/hold1/bubblegum/GradientDrawable;", "setBackgroundDraw", "(Lcom/hold1/bubblegum/GradientDrawable;)V", "addGradient", "", "gradient", "Lcom/hold1/bubblegum/Gradient;", "commonInit", "setGradient", "setGradients", "gradients", "", "([Lcom/hold1/bubblegum/Gradient;)V", "startAnimation", "stopAnimation", "bubblegum_release"})
public final class BubbleView
extends View {
    @NotNull
    public GradientDrawable backgroundDraw;

    @NotNull
    public final GradientDrawable getBackgroundDraw() {
        GradientDrawable gradientDrawable = this.backgroundDraw;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
        }
        return gradientDrawable;
    }

    public final void setBackgroundDraw(@NotNull GradientDrawable gradientDrawable) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)gradientDrawable), (String)"<set-?>");
        this.backgroundDraw = gradientDrawable;
    }

    public final void commonInit(@Nullable AttributeSet attrs) {
        GradientDrawable bgDrawable;
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.BubbleView);
        Gradient gradient = null;
        if (array.getColor(R.styleable.BubbleView_bbStartColor, -1) != -1 && array.getColor(R.styleable.BubbleView_bbEndColor, -1) != -1) {
            gradient = new Gradient(new int[]{array.getColor(R.styleable.BubbleView_bbStartColor, -16711681), array.getColor(R.styleable.BubbleView_bbEndColor, -16776961)});
        }
        Gradient gradient2 = gradient;
        if (gradient2 != null) {
            gradient2.setAngle(array.getInt(R.styleable.BubbleView_bbAngle, 0));
        }
        int gradientArrayId = array.getResourceId(R.styleable.BubbleView_bbGradientColors, 0);
        if (gradientArrayId != 0) {
            int[] gradientColors = this.getResources().getIntArray(gradientArrayId);
            Intrinsics.checkExpressionValueIsNotNull((Object)gradientColors, (String)"gradientColors");
            gradient = new Gradient(gradientColors);
        }
        array.recycle();
        if (gradient == null) {
            gradient = new Gradient(new int[]{GradientDrawable.Companion.getDefaultStartColor(), GradientDrawable.Companion.getDefaultEndColor()});
        }
        this.backgroundDraw = bgDrawable = new GradientDrawable(gradient);
        if (Build.VERSION.SDK_INT >= 16) {
            GradientDrawable gradientDrawable = this.backgroundDraw;
            if (gradientDrawable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
            }
            this.setBackground((Drawable)gradientDrawable);
        } else {
            GradientDrawable gradientDrawable = this.backgroundDraw;
            if (gradientDrawable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
            }
            this.setBackgroundDrawable((Drawable)gradientDrawable);
        }
    }

    public final void addGradient(@NotNull Gradient gradient) {
        Intrinsics.checkParameterIsNotNull((Object)gradient, (String)"gradient");
        GradientDrawable gradientDrawable = this.backgroundDraw;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
        }
        GradientDrawable gradientDrawable2 = this.backgroundDraw;
        if (gradientDrawable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
        }
        gradientDrawable.setColors((Gradient[])ArraysKt.plus((Object[])gradientDrawable2.getColors(), (Object)gradient));
    }

    public final void setGradient(@NotNull Gradient gradient) {
        Intrinsics.checkParameterIsNotNull((Object)gradient, (String)"gradient");
        GradientDrawable gradientDrawable = this.backgroundDraw;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
        }
        gradientDrawable.setGradient(gradient);
    }

    public final void setGradients(@NotNull Gradient[] gradients) {
        Intrinsics.checkParameterIsNotNull((Object)gradients, (String)"gradients");
        GradientDrawable gradientDrawable = this.backgroundDraw;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
        }
        gradientDrawable.setColors(gradients);
    }

    public final void startAnimation() {
        GradientDrawable gradientDrawable = this.backgroundDraw;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
        }
        gradientDrawable.start();
    }

    public final void stopAnimation() {
        GradientDrawable gradientDrawable = this.backgroundDraw;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundDraw");
        }
        gradientDrawable.stop();
    }

    public BubbleView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.commonInit(null);
    }

    public BubbleView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.commonInit(attrs);
    }

    public BubbleView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.commonInit(attrs);
    }
}

