/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.util;

import android.opengl.GLES20;
import android.util.Log;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

public class ShaderUtil {
    private static final String TAG = ShaderUtil.class.getSimpleName();

    public static int createProgram(String vertexShaderCode, String fragmentShaderCode) {
        int vertexShader = ShaderUtil.loadShader(35633, vertexShaderCode);
        int fragmentShader = ShaderUtil.loadShader(35632, fragmentShaderCode);
        if (vertexShader == 0 || fragmentShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)vertexShader);
            GLES20.glAttachShader((int)program, (int)fragmentShader);
            GLES20.glLinkProgram((int)program);
            GLES20.glDeleteShader((int)vertexShader);
            GLES20.glDeleteShader((int)fragmentShader);
            ShaderUtil.checkGLError("Attach Shader");
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                Log.e((String)TAG, (String)"Failed to link program");
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    public static int loadShader(int type, String shaderCode) {
        int shader = GLES20.glCreateShader((int)type);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)shaderCode);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                Log.e((String)TAG, (String)"Failed to compile the shader");
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    public static String getVertexCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("uniform mat4 uMVPMatrix;   \n").append("uniform mat4 uTexMatrix;   \n").append("attribute vec2 aTexCoord;   \n").append("attribute vec3 aPosition;  \n").append("varying vec2 vTexCoord;  \n").append("void main() {              \n").append("  gl_Position = uMVPMatrix * vec4(aPosition, 1); \n").append("     vTexCoord = (uTexMatrix * vec4(aTexCoord,0,1)).st;\n").append("}  \n");
        return sb.toString();
    }

    public static boolean checkGLError(String msg) {
        int error = GLES20.glGetError();
        if (error != 0) {
            Log.e((String)TAG, (String)("checkGLError: " + msg));
        }
        return error == 0;
    }

    public static boolean checkEGLContext() {
        EGLContext context = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        if (context.equals(EGL10.EGL_NO_CONTEXT)) {
            Log.e((String)TAG, (String)"This thread is no EGLContext.");
            return false;
        }
        return true;
    }

    public static String getFragmentShaderCode(int mode) {
        StringBuilder sb = new StringBuilder();
        sb.append(" \n").append("precision mediump float;   \n").append("varying vec2 vTexCoord;   \n").append("uniform sampler2D uTexture;   \n").append("uniform int uRadius;   \n").append("uniform float uWidthOffset;  \n").append("uniform float uHeightOffset;  \n").append("mediump float getGaussWeight(mediump float currentPos, mediump float sigma) \n").append("{ \n").append("   return 1.0 / sigma * exp(-(currentPos * currentPos) / (2.0 * sigma * sigma)); \n").append("} \n").append("void main() {   \n");
        if (mode == 0) {
            sb.append(ShaderUtil.getBoxSampleCode());
        } else if (mode == 1) {
            sb.append(ShaderUtil.getGaussianSampleCode());
        } else if (mode == 2) {
            sb.append(ShaderUtil.getStackSampleCode());
        }
        sb.append("}   \n");
        return sb.toString();
    }

    private static String getGaussianSampleCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("int diameter = 2 * uRadius + 1;  \n").append("  vec3 sampleTex;\n").append("  vec3 col;  \n").append("  float weightSum = 0.0; \n").append("  for(int i = 0; i < diameter; i++) {\n").append("       vec2 offset = vec2(float(i - uRadius) * uWidthOffset, float(i - uRadius) * uHeightOffset);  \n").append("       sampleTex = vec3(texture2D(uTexture, vTexCoord.st+offset));\n").append("       float index = float(i); \n").append("       float gaussWeight = getGaussWeight(index - float(diameter - 1)/2.0,").append("           (float(diameter - 1)/2.0 + 1.0) / 2.0); \n").append("       col += sampleTex * gaussWeight; \n").append("       weightSum += gaussWeight;\n").append("  }   \n").append("  gl_FragColor = vec4(col / weightSum, 1.0);   \n");
        return sb.toString();
    }

    private static String getBoxSampleCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("int diameter = 2 * uRadius + 1; \n").append("  vec3 sampleTex;\n").append("  vec3 col;  \n").append("  float weightSum = 0.0; \n").append("  for(int i = 0; i < diameter; i++) {\n").append("       vec2 offset = vec2(float(i - uRadius) * uWidthOffset, float(i - uRadius) * uHeightOffset);  \n").append("        sampleTex = vec3(texture2D(uTexture, vTexCoord.st+offset));\n").append("       float index = float(i); \n").append("       float boxWeight = float(1.0) / float(diameter); \n").append("       col += sampleTex * boxWeight; \n").append("       weightSum += boxWeight;\n").append("  }   \n").append("  gl_FragColor = vec4(col / weightSum, 1.0);   \n");
        return sb.toString();
    }

    private static String getStackSampleCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("int diameter = 2 * uRadius + 1;  \n").append("  vec3 sampleTex;\n").append("  vec3 col;  \n").append("  float weightSum = 0.0; \n").append("  for(int i = 0; i < diameter; i++) {\n").append("       vec2 offset = vec2(float(i - uRadius) * uWidthOffset, float(i - uRadius) * uHeightOffset);  \n").append("       sampleTex = vec3(texture2D(uTexture, vTexCoord.st+offset));\n").append("       float index = float(i); \n").append("       float boxWeight = float(uRadius) + 1.0 - abs(index - float(uRadius)); \n").append("       col += sampleTex * boxWeight; \n").append("       weightSum += boxWeight;\n").append("  }   \n").append("  gl_FragColor = vec4(col / weightSum, 1.0);   \n");
        return sb.toString();
    }

    public static String getKernelInitCode(float[] kernel) {
        if (kernel == null || kernel.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("  float kernel[" + kernel.length + "]; \n");
        for (int i = 0; i < kernel.length; ++i) {
            sb.append("  kernel[");
            sb.append(i);
            sb.append("] = ");
            sb.append(kernel[i] + "f; \n");
        }
        return sb.toString();
    }

    public static String getOffsetInitCode(int radius) {
        int d = 2 * radius + 1;
        StringBuilder sb = new StringBuilder("  vec2 offsets[" + d + "]; \n");
        for (int i = -radius; i <= radius; ++i) {
            sb.append("  offsets[").append(i + radius).append("] = vec2(").append(i).append(".f * uWidthOffset, ").append(i).append(".f * uHeightOffset); \n");
        }
        return sb.toString();
    }

    public static String getCopyFragmentCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(" \n").append("precision mediump float;").append("varying vec2 vTexCoord;   \n").append("uniform sampler2D uTexture;   \n").append("void main() {   \n").append("  vec3 col = vec3(texture2D(uTexture, vTexCoord.st));\n").append("  gl_FragColor = vec4(col, 1.0);   \n").append("}   \n");
        return sb.toString();
    }

    public static String getColorFragmentCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("precision mediump float;   \n").append("uniform vec4 vColor;   \n").append("void main() {   \n").append("   gl_FragColor = vColor;   \n").append("} \n");
        return sb.toString();
    }
}

