/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.task;

import com.hoko.blur.task.AsyncBlurTask;
import com.hoko.blur.task.BlurSubTask;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class BlurTaskManager {
    private static final int EXECUTOR_THREADS = Runtime.getRuntime().availableProcessors() <= 3 ? 1 : Runtime.getRuntime().availableProcessors() / 2;
    private static final ExecutorService ASYNC_BLUR_EXECUTOR = Executors.newFixedThreadPool(EXECUTOR_THREADS);
    private static final ExecutorService CONCURRENT_BLUR_EXECUTOR = Executors.newFixedThreadPool(EXECUTOR_THREADS);
    private static volatile BlurTaskManager sInstance;

    private BlurTaskManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlurTaskManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<BlurTaskManager> clazz = BlurTaskManager.class;
        synchronized (BlurTaskManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new BlurTaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void submit(AsyncBlurTask task) {
        if (task != null) {
            ASYNC_BLUR_EXECUTOR.submit(task);
        }
    }

    public void invokeAll(Collection<BlurSubTask> tasks) {
        if (tasks != null && tasks.size() > 0) {
            try {
                CONCURRENT_BLUR_EXECUTOR.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getCores() {
        return EXECUTOR_THREADS;
    }
}

