/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.task;

import android.graphics.Bitmap;
import android.view.View;
import com.hoko.blur.api.IBlurProcessor;
import com.hoko.blur.api.IBlurResultDispatcher;
import com.hoko.blur.task.BlurResult;
import com.hoko.blur.task.BlurResultDispatcher;
import com.hoko.blur.util.SingleMainHandler;

public class AsyncBlurTask
implements Runnable {
    private Callback mCallback;
    private IBlurProcessor mProcessor;
    private Bitmap mBitmap;
    private View mView;
    private IBlurResultDispatcher mResultDelivery;

    public AsyncBlurTask(IBlurProcessor processor, Bitmap bitmap, Callback callback) {
        this.mProcessor = processor;
        this.mBitmap = bitmap;
        this.mCallback = callback;
        this.mResultDelivery = new BlurResultDispatcher(SingleMainHandler.get());
    }

    public AsyncBlurTask(IBlurProcessor processor, View view, Callback callback) {
        this(processor, (Bitmap)null, callback);
        this.mView = view;
    }

    @Override
    public void run() {
        BlurResult result = new BlurResult(this.mCallback);
        try {
            if (this.mProcessor == null) {
                result.setSuccess(false);
                return;
            }
            if (this.mView != null) {
                result.setBitmap(this.mProcessor.blur(this.mView));
            } else {
                result.setBitmap(this.mProcessor.blur(this.mBitmap));
            }
            result.setSuccess(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
            result.setSuccess(false);
            result.setError(e);
        }
        finally {
            this.mResultDelivery.postResult(result);
        }
    }

    public void setResultDelivery(IBlurResultDispatcher resultDelivery) {
        this.mResultDelivery = resultDelivery;
    }

    public static interface Callback {
        public void onBlurSuccess(Bitmap var1);

        public void onBlurFailed(Throwable var1);
    }
}

