/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RSRuntimeException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import com.hoko.blur.processor.BlurProcessor;
import com.hoko.blur.renderscript.ScriptC_BoxblurHorizontal;
import com.hoko.blur.renderscript.ScriptC_BoxblurVertical;
import com.hoko.blur.renderscript.ScriptC_Stackblur;
import com.hoko.blur.util.BlurUtil;
import com.hoko.blur.util.Preconditions;

class RenderScriptBlurProcessor
extends BlurProcessor {
    private RenderScript mRenderScript;
    private ScriptIntrinsicBlur mGaussianBlurScirpt;
    private ScriptC_BoxblurHorizontal mBoxBlurScriptH;
    private ScriptC_BoxblurVertical mBoxBlurScriptV;
    private ScriptC_Stackblur mStackBlurScript;
    private Allocation mAllocationIn;
    private Allocation mAllocationOut;

    RenderScriptBlurProcessor(BlurProcessor.Builder builder) {
        super(builder);
        this.init(builder.mCtx);
    }

    private void init(Context context) {
        try {
            this.mRenderScript = RenderScript.create((Context)context.getApplicationContext());
            this.mGaussianBlurScirpt = ScriptIntrinsicBlur.create((RenderScript)this.mRenderScript, (Element)Element.U8_4((RenderScript)this.mRenderScript));
            this.mBoxBlurScriptH = new ScriptC_BoxblurHorizontal(this.mRenderScript);
            this.mBoxBlurScriptV = new ScriptC_BoxblurVertical(this.mRenderScript);
            this.mStackBlurScript = new ScriptC_Stackblur(this.mRenderScript);
        }
        catch (RSRuntimeException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Bitmap doInnerBlur(Bitmap scaledInBitmap, boolean concurrent) {
        Preconditions.checkNotNull(scaledInBitmap, "scaledInBitmap == null");
        Bitmap scaledOutBitmap = Bitmap.createBitmap((int)scaledInBitmap.getWidth(), (int)scaledInBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mAllocationIn = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)scaledInBitmap);
        this.mAllocationOut = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)scaledOutBitmap);
        try {
            switch (this.mMode) {
                case 0: {
                    this.doBoxBlur(scaledInBitmap);
                    break;
                }
                case 2: {
                    this.doStackBlur(scaledInBitmap);
                    break;
                }
                case 1: {
                    this.doGaussianBlur(scaledInBitmap);
                }
            }
            this.mAllocationOut.copyTo(scaledInBitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scaledInBitmap;
    }

    private void doBoxBlur(Bitmap input) {
        if (this.mBoxBlurScriptH == null || this.mBoxBlurScriptV == null) {
            this.mAllocationOut = this.mAllocationIn;
            return;
        }
        this.mBoxBlurScriptH.set_input(this.mAllocationIn);
        this.mBoxBlurScriptH.set_output(this.mAllocationOut);
        this.mBoxBlurScriptH.set_width(input.getWidth());
        this.mBoxBlurScriptH.set_height(input.getHeight());
        this.mBoxBlurScriptH.set_radius(this.mRadius);
        this.mBoxBlurScriptH.forEach_boxblur_h(this.mAllocationIn);
        this.mBoxBlurScriptV.set_input(this.mAllocationOut);
        this.mBoxBlurScriptV.set_output(this.mAllocationIn);
        this.mBoxBlurScriptV.set_width(input.getWidth());
        this.mBoxBlurScriptV.set_height(input.getHeight());
        this.mBoxBlurScriptV.set_radius(this.mRadius);
        this.mBoxBlurScriptV.forEach_boxblur_v(this.mAllocationOut);
        this.mAllocationOut = this.mAllocationIn;
    }

    private void doGaussianBlur(Bitmap input) {
        if (this.mGaussianBlurScirpt == null) {
            this.mAllocationOut = this.mAllocationIn;
            return;
        }
        this.mRadius = BlurUtil.checkRadius(this.mRadius);
        this.mGaussianBlurScirpt.setRadius((float)this.mRadius);
        this.mGaussianBlurScirpt.setInput(this.mAllocationIn);
        this.mGaussianBlurScirpt.forEach(this.mAllocationOut);
    }

    private void doStackBlur(Bitmap input) {
        if (this.mStackBlurScript == null) {
            this.mAllocationOut = this.mAllocationIn;
            return;
        }
        this.mStackBlurScript.set_input(this.mAllocationIn);
        this.mStackBlurScript.set_output(this.mAllocationOut);
        this.mStackBlurScript.set_width(input.getWidth());
        this.mStackBlurScript.set_height(input.getHeight());
        this.mStackBlurScript.set_radius(this.mRadius);
        this.mStackBlurScript.forEach_stackblur_v(this.mAllocationIn);
        this.mStackBlurScript.set_input(this.mAllocationOut);
        this.mStackBlurScript.set_output(this.mAllocationIn);
        this.mStackBlurScript.forEach_stackblur_h(this.mAllocationOut);
        this.mAllocationOut = this.mAllocationIn;
    }

    @Override
    public BlurProcessor.Builder newBuilder() {
        BlurProcessor.Builder builder = super.newBuilder();
        builder.context(this.mRenderScript.getApplicationContext());
        return builder;
    }
}

