/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.graphics.Bitmap;
import com.hoko.blur.opengl.cache.FrameBufferCache;
import com.hoko.blur.opengl.cache.TextureCache;
import com.hoko.blur.opengl.offscreen.EglBuffer;
import com.hoko.blur.processor.BlurProcessor;
import com.hoko.blur.util.Preconditions;

class OpenGLBlurProcessor
extends BlurProcessor {
    private EglBuffer mEglBuffer;

    OpenGLBlurProcessor(BlurProcessor.Builder builder) {
        super(builder);
        this.init();
    }

    private void init() {
        this.mEglBuffer = new EglBuffer();
    }

    @Override
    protected Bitmap doInnerBlur(Bitmap scaledInBitmap, boolean concurrent) {
        Preconditions.checkNotNull(scaledInBitmap, "scaledInBitmap == null");
        Preconditions.checkArgument(!scaledInBitmap.isRecycled(), "You must input an unrecycled bitmap !");
        this.mEglBuffer.setBlurRadius(this.mRadius);
        this.mEglBuffer.setBlurMode(this.mMode);
        return this.mEglBuffer.getBlurBitmap(scaledInBitmap);
    }

    @Override
    protected void free() {
        this.mEglBuffer.free();
        TextureCache.getInstance().deleteTextures();
        FrameBufferCache.getInstance().deleteFrameBuffers();
    }
}

