/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.graphics.Bitmap;
import com.hoko.blur.filter.NativeBlurFilter;
import com.hoko.blur.processor.BlurProcessor;
import com.hoko.blur.task.BlurSubTask;
import com.hoko.blur.task.BlurTaskManager;
import com.hoko.blur.util.Preconditions;
import java.util.ArrayList;

class NativeBlurProcessor
extends BlurProcessor {
    NativeBlurProcessor(BlurProcessor.Builder builder) {
        super(builder);
    }

    @Override
    protected Bitmap doInnerBlur(Bitmap scaledInBitmap, boolean concurrent) {
        Preconditions.checkNotNull(scaledInBitmap, "scaledInBitmap == null");
        if (concurrent) {
            try {
                int cores = BlurTaskManager.getCores();
                ArrayList<BlurSubTask> hTasks = new ArrayList<BlurSubTask>(cores);
                ArrayList<BlurSubTask> vTasks = new ArrayList<BlurSubTask>(cores);
                for (int i = 0; i < cores; ++i) {
                    hTasks.add(new BlurSubTask(1003, this.mMode, scaledInBitmap, this.mRadius, cores, i, 0));
                    vTasks.add(new BlurSubTask(1003, this.mMode, scaledInBitmap, this.mRadius, cores, i, 1));
                }
                BlurTaskManager.getInstance().invokeAll(hTasks);
                BlurTaskManager.getInstance().invokeAll(vTasks);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            NativeBlurFilter.doFullBlur(this.mMode, scaledInBitmap, this.mRadius);
        }
        return scaledInBitmap;
    }
}

