/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import com.hoko.blur.processor.BlurProcessor;
import com.hoko.blur.processor.NativeBlurProcessor;
import com.hoko.blur.processor.OpenGLBlurProcessor;
import com.hoko.blur.processor.OriginBlurProcessor;
import com.hoko.blur.processor.RenderScriptBlurProcessor;

class BlurProcessorFactory {
    BlurProcessorFactory() {
    }

    static BlurProcessor get(int scheme, BlurProcessor.Builder builder) {
        BlurProcessor generator = null;
        switch (scheme) {
            case 1001: {
                generator = new RenderScriptBlurProcessor(builder);
                break;
            }
            case 1002: {
                generator = new OpenGLBlurProcessor(builder);
                break;
            }
            case 1003: {
                generator = new NativeBlurProcessor(builder);
                break;
            }
            case 1004: {
                generator = new OriginBlurProcessor(builder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported blur scheme!");
            }
        }
        return generator;
    }
}

