/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.hoko.blur.api.IBlurProcessor;
import com.hoko.blur.processor.BlurProcessorFactory;
import com.hoko.blur.task.AsyncBlurTask;
import com.hoko.blur.task.BlurTaskManager;
import com.hoko.blur.util.BitmapUtil;
import com.hoko.blur.util.Preconditions;

public abstract class BlurProcessor
implements IBlurProcessor {
    int mRadius;
    int mMode;
    private int mScheme;
    private float mSampleFactor;
    private boolean mIsForceCopy;
    private boolean mNeedUpscale;
    private int mTranslateX;
    private int mTranslateY;

    public BlurProcessor(Builder builder) {
        this.mMode = builder.mMode;
        this.mScheme = builder.mScheme;
        this.mRadius = builder.mRadius;
        this.mSampleFactor = builder.mSampleFactor;
        this.mIsForceCopy = builder.mIsForceCopy;
        this.mNeedUpscale = builder.mNeedUpscale;
        this.mTranslateX = builder.mTranslateX;
        this.mTranslateY = builder.mTranslateY;
    }

    @Override
    public void mode(int mode) {
        this.mMode = mode;
    }

    @Override
    public void radius(int radius) {
        this.mRadius = radius;
    }

    @Override
    public void sampleFactor(float factor) {
        this.mSampleFactor = factor;
    }

    @Override
    public int mode() {
        return this.mMode;
    }

    @Override
    public int radius() {
        return this.mRadius;
    }

    @Override
    public float sampleFactor() {
        return this.mSampleFactor;
    }

    @Override
    public int scheme() {
        return this.mScheme;
    }

    @Override
    public boolean forceCopy() {
        return this.mIsForceCopy;
    }

    @Override
    public boolean needUpscale() {
        return this.mNeedUpscale;
    }

    @Override
    public int translateX() {
        return this.mTranslateX;
    }

    @Override
    public int translateY() {
        return this.mTranslateY;
    }

    @Override
    public Bitmap blur(Bitmap bitmap) {
        return this.doBlur(bitmap, true);
    }

    private Bitmap doBlur(Bitmap bitmap, boolean concurrent) {
        Preconditions.checkNotNull(bitmap, "bitmap == null");
        Preconditions.checkArgument(!bitmap.isRecycled(), "You must input an unrecycled bitmap !");
        if (this.mRadius <= 0) {
            this.mRadius = 1;
        }
        if (this.mSampleFactor < 1.0f) {
            this.mSampleFactor = 1.0f;
        }
        Bitmap inBitmap = null;
        inBitmap = this.mIsForceCopy ? bitmap.copy(bitmap.getConfig(), true) : bitmap;
        Bitmap transInBitmap = BitmapUtil.transformBitmap(inBitmap, this.translateX(), this.translateY());
        Bitmap scaledInBitmap = BitmapUtil.getScaledBitmap(transInBitmap, this.sampleFactor());
        Bitmap scaledOutBitmap = this.doInnerBlur(scaledInBitmap, concurrent);
        Bitmap outBitmap = this.mNeedUpscale ? BitmapUtil.getScaledBitmap(scaledOutBitmap, 1.0f / this.sampleFactor()) : scaledOutBitmap;
        return outBitmap;
    }

    protected abstract Bitmap doInnerBlur(Bitmap var1, boolean var2);

    @Override
    public Bitmap blur(View view) {
        Preconditions.checkNotNull(view, "You must input a view !");
        Bitmap viewBitmap = BitmapUtil.getViewBitmap(view, this.translateX(), this.translateY(), this.sampleFactor());
        Bitmap scaledOutBitmap = this.doInnerBlur(viewBitmap, true);
        Bitmap outBitmap = this.mNeedUpscale ? BitmapUtil.getScaledBitmap(scaledOutBitmap, 1.0f / this.sampleFactor()) : scaledOutBitmap;
        return outBitmap;
    }

    @Override
    public void asyncBlur(Bitmap bitmap, AsyncBlurTask.Callback callback) {
        BlurTaskManager.getInstance().submit(new AsyncBlurTask((IBlurProcessor)this, bitmap, callback));
    }

    @Override
    public void asyncBlur(View view, AsyncBlurTask.Callback callback) {
        BlurTaskManager.getInstance().submit(new AsyncBlurTask((IBlurProcessor)this, view, callback));
    }

    protected void free() {
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private static final int DEFAULT_MODE = 2;
        private static final int DEFAULT_SCHEME = 1003;
        private static final int DEFAULT_BLUR_RADIUS = 5;
        private static final float DEFAULT_SAMPLE_FACTOR = 5.0f;
        private static final boolean DEFAULT_FORCE_COPY = false;
        private static final boolean DEFAULT_UP_SCALE = true;
        private static final int DEFAULT_TRANSLATE_X = 0;
        private static final int DEFAULT_TRANSLATE_Y = 0;
        private int mMode = 2;
        private int mScheme = 1003;
        private int mRadius = 5;
        private float mSampleFactor = 5.0f;
        private boolean mIsForceCopy = false;
        private boolean mNeedUpscale = true;
        private int mTranslateX = 0;
        private int mTranslateY = 0;
        Context mCtx;

        public Builder(Context context) {
            this.mCtx = context.getApplicationContext();
        }

        public Builder(IBlurProcessor blurGenerator) {
            this.mMode = blurGenerator.mode();
            this.mScheme = blurGenerator.scheme();
            this.mRadius = blurGenerator.radius();
            this.mSampleFactor = blurGenerator.sampleFactor();
            this.mIsForceCopy = blurGenerator.forceCopy();
            this.mNeedUpscale = blurGenerator.needUpscale();
            this.mTranslateX = blurGenerator.translateX();
            this.mTranslateY = blurGenerator.translateY();
        }

        public Builder context(Context ctx) {
            this.mCtx = ctx;
            return this;
        }

        public Builder mode(int mode) {
            this.mMode = mode;
            return this;
        }

        public Builder scheme(int scheme) {
            this.mScheme = scheme;
            return this;
        }

        public Builder radius(int radius) {
            this.mRadius = radius;
            return this;
        }

        public Builder sampleFactor(float factor) {
            this.mSampleFactor = factor;
            return this;
        }

        public Builder forceCopy(boolean isForceCopy) {
            this.mIsForceCopy = isForceCopy;
            return this;
        }

        public Builder needUpscale(boolean needUpscale) {
            this.mNeedUpscale = needUpscale;
            return this;
        }

        public Builder translateX(int translateX) {
            this.mTranslateX = translateX;
            return this;
        }

        public Builder translateY(int translateY) {
            this.mTranslateY = translateY;
            return this;
        }

        public BlurProcessor processor() {
            return BlurProcessorFactory.get(this.mScheme, this);
        }

        private void reset() {
            this.mMode = 2;
            this.mScheme = 1003;
            this.mRadius = 5;
            this.mSampleFactor = 5.0f;
            this.mIsForceCopy = false;
            this.mNeedUpscale = true;
            this.mTranslateX = 0;
            this.mTranslateY = 0;
        }
    }
}

