/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.offscreen;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.util.Log;
import com.hoko.blur.api.IFrameBuffer;
import com.hoko.blur.api.IRenderer;
import com.hoko.blur.api.ITexture;
import com.hoko.blur.opengl.cache.FrameBufferCache;
import com.hoko.blur.opengl.texture.TextureFactory;
import com.hoko.blur.util.ShaderUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

public class OffScreenBlurRenderer
implements IRenderer<Bitmap> {
    private static final String TAG = OffScreenBlurRenderer.class.getSimpleName();
    private final String vertexShaderCode = "attribute vec2 aTexCoord;   \nattribute vec4 aPosition;  \nvarying vec2 vTexCoord;  \nvoid main() {              \n  gl_Position = aPosition; \n  vTexCoord = aTexCoord; \n}  \n";
    private FloatBuffer mVertexBuffer;
    private ShortBuffer mDrawListBuffer;
    private FloatBuffer mTexCoordBuffer;
    private static final int COORDS_PER_VERTEX = 3;
    private float[] squareCoords = new float[]{-1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static float[] mTexHorizontalCoords = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private float[] fragmentColor = new float[]{0.2f, 0.70980394f, 0.8980392f, 1.0f};
    private int mProgram;
    private int mPositionId;
    private int mColorHandle;
    private int mTexCoordId;
    private int mRadiusId;
    private int mWidthOffsetId;
    private int mHeightOffsetId;
    private int vertexStride = 12;
    private Bitmap mBitmap;
    private ITexture mHorizontalTexture;
    private ITexture mInputTexture;
    private int mTextureUniformId;
    private IFrameBuffer mHorizontalFrameBuffer;
    private int mWidth;
    private int mHeight;
    public int mRadius;
    private int mMode;
    private FrameBufferCache mFrameBufferCache = FrameBufferCache.getInstance();
    private boolean mHasEGLContext;
    private boolean mNeedRelink;

    public OffScreenBlurRenderer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(this.squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = bb.asFloatBuffer();
        this.mVertexBuffer.put(this.squareCoords);
        this.mVertexBuffer.position(0);
        ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        this.mDrawListBuffer = dlb.asShortBuffer();
        this.mDrawListBuffer.put(this.drawOrder);
        this.mDrawListBuffer.position(0);
        ByteBuffer tcb = ByteBuffer.allocateDirect(mTexHorizontalCoords.length * 4);
        tcb.order(ByteOrder.nativeOrder());
        this.mTexCoordBuffer = tcb.asFloatBuffer();
        this.mTexCoordBuffer.put(mTexHorizontalCoords);
        this.mTexCoordBuffer.position(0);
    }

    @Override
    public void onDrawFrame(Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        this.mBitmap = bitmap;
        this.mWidth = this.mBitmap.getWidth();
        this.mHeight = this.mBitmap.getHeight();
        if (this.mWidth == 0 || this.mHeight == 0) {
            return;
        }
        if (this.prepare()) {
            this.draw();
        }
        this.onPostBlur();
    }

    @Override
    public void onSurfaceCreated() {
        GLES20.glClear((int)16384);
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    private boolean prepare() {
        if (!this.mHasEGLContext) {
            EGLContext context = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
            if (context.equals(EGL10.EGL_NO_CONTEXT)) {
                Log.e((String)TAG, (String)"This thread is no EGLContext.");
                return false;
            }
            GLES20.glClear((int)16384);
            this.mHasEGLContext = true;
        }
        if (this.mNeedRelink) {
            this.deletePrograms();
            this.mProgram = ShaderUtil.createProgram("attribute vec2 aTexCoord;   \nattribute vec4 aPosition;  \nvarying vec2 vTexCoord;  \nvoid main() {              \n  gl_Position = aPosition; \n  vTexCoord = aTexCoord; \n}  \n", ShaderUtil.getFragmentShaderCode(this.mMode));
            this.mNeedRelink = false;
        }
        if (this.mProgram == 0) {
            return false;
        }
        GLES20.glClearColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        this.mInputTexture = TextureFactory.create(this.mBitmap);
        this.mHorizontalTexture = TextureFactory.create(this.mWidth, this.mHeight);
        this.mHorizontalFrameBuffer = this.mFrameBufferCache.getFrameBuffer();
        if (this.mHorizontalFrameBuffer != null) {
            this.mHorizontalFrameBuffer.bindTexture(this.mHorizontalTexture);
        }
        return ShaderUtil.checkGLError("Prepare to blurring");
    }

    private void draw() {
        this.drawOneDimenBlur(true);
        this.drawOneDimenBlur(false);
    }

    private void drawOneDimenBlur(boolean isHorizontal) {
        GLES20.glUseProgram((int)this.mProgram);
        this.mPositionId = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        GLES20.glEnableVertexAttribArray((int)this.mPositionId);
        GLES20.glVertexAttribPointer((int)this.mPositionId, (int)3, (int)5126, (boolean)false, (int)this.vertexStride, (Buffer)this.mVertexBuffer);
        this.mTexCoordId = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTexCoord");
        GLES20.glEnableVertexAttribArray((int)this.mTexCoordId);
        GLES20.glVertexAttribPointer((int)this.mTexCoordId, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mTexCoordBuffer);
        if (isHorizontal) {
            this.mHorizontalFrameBuffer.bindSelf();
        }
        this.mTextureUniformId = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTexture");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)(isHorizontal ? this.mInputTexture.id() : this.mHorizontalTexture.id()));
        GLES20.glUniform1i((int)this.mTextureUniformId, (int)0);
        this.mRadiusId = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uRadius");
        this.mWidthOffsetId = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uWidthOffset");
        this.mHeightOffsetId = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uHeightOffset");
        GLES20.glUniform1i((int)this.mRadiusId, (int)this.mRadius);
        GLES20.glUniform1f((int)this.mWidthOffsetId, (float)(isHorizontal ? 0.0f : 1.0f / (float)this.mWidth));
        GLES20.glUniform1f((int)this.mHeightOffsetId, (float)(isHorizontal ? 1.0f / (float)this.mHeight : 0.0f));
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.mDrawListBuffer);
        if (!isHorizontal) {
            GLES20.glDisableVertexAttribArray((int)this.mPositionId);
            GLES20.glDisableVertexAttribArray((int)this.mTexCoordId);
        }
        this.resetAllBuffer();
    }

    private void resetAllBuffer() {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glUseProgram((int)0);
        this.mVertexBuffer.rewind();
        this.mTexCoordBuffer.rewind();
        this.mDrawListBuffer.rewind();
    }

    private void onPostBlur() {
        if (this.mInputTexture != null) {
            this.mInputTexture.delete();
        }
        if (this.mHorizontalTexture != null) {
            this.mHorizontalTexture.delete();
        }
        this.mFrameBufferCache.recycleFrameBuffer(this.mHorizontalFrameBuffer);
    }

    private void deletePrograms() {
        if (this.mProgram != 0) {
            GLES20.glDeleteProgram((int)this.mProgram);
        }
    }

    @Override
    public void free() {
        this.mNeedRelink = true;
        this.deletePrograms();
    }

    public void setBlurMode(int mode) {
        this.mNeedRelink = true;
        this.mMode = mode;
    }

    public void setBlurRadius(int radius) {
        this.mRadius = radius;
    }
}

