/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.offscreen;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.hoko.blur.opengl.offscreen.OffScreenBlurRenderer;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EglBuffer {
    private EGL10 mEgl;
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private EGLConfig[] mEglConfigs = new EGLConfig[1];
    private int[] mContextAttribs;
    private ThreadLocal<OffScreenBlurRenderer> mThreadRenderer = new ThreadLocal();
    private ThreadLocal<EGLContext> mThreadEGLContext = new ThreadLocal();
    private ThreadLocal<EGLSurface> mThreadEGLSurface = new ThreadLocal();

    public EglBuffer() {
        this.initGL();
    }

    private void initGL() {
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] version = new int[2];
        this.mEgl.eglInitialize(this.mEGLDisplay, version);
        int[] configAttribs = new int[]{12320, 32, 12321, 8, 12322, 8, 12323, 8, 12324, 8, 12352, 4, 12339, 1, 12344};
        int[] numConfigs = new int[1];
        this.mEgl.eglChooseConfig(this.mEGLDisplay, configAttribs, this.mEglConfigs, 1, numConfigs);
        this.mContextAttribs = new int[]{12440, 2, 12344};
    }

    private void initSurface(int width, int height) {
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        EGLSurface eglSurface = this.mEgl.eglCreatePbufferSurface(this.mEGLDisplay, this.mEglConfigs[0], surfaceAttribs);
        this.mThreadEGLSurface.set(eglSurface);
        this.mEgl.eglMakeCurrent(this.mEGLDisplay, eglSurface, eglSurface, this.getEGLContext());
    }

    public Bitmap getBlurBitmap(Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            return bitmap;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        this.initSurface(w, h);
        if (this.getRenderer() != null) {
            this.getRenderer().onSurfaceCreated();
            this.getRenderer().onSurfaceChanged(w, h);
            this.getRenderer().onDrawFrame(bitmap);
            this.mEgl.eglSwapBuffers(this.mEGLDisplay, this.mThreadEGLSurface.get());
        }
        this.convertToBitmap(bitmap);
        this.unbindEglCurrent();
        return bitmap;
    }

    public void setBlurRadius(int radius) {
        this.getRenderer().setBlurRadius(radius);
    }

    public void setBlurMode(int mode) {
        this.getRenderer().setBlurMode(mode);
    }

    public void free() {
        this.getRenderer().free();
    }

    private void convertToBitmap(Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        IntBuffer ib = IntBuffer.allocate(w * h);
        GLES20.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (Buffer)ib);
        int[] ia = ib.array();
        bitmap.copyPixelsFromBuffer((Buffer)IntBuffer.wrap(ia));
    }

    private void unbindEglCurrent() {
        this.mEgl.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
    }

    private OffScreenBlurRenderer getRenderer() {
        OffScreenBlurRenderer renderer = this.mThreadRenderer.get();
        if (renderer == null) {
            renderer = new OffScreenBlurRenderer();
            this.mThreadRenderer.set(renderer);
        }
        return renderer;
    }

    private EGLContext getEGLContext() {
        EGLContext eglContext = this.mThreadEGLContext.get();
        if (eglContext == null) {
            eglContext = this.mEgl.eglCreateContext(this.mEGLDisplay, this.mEglConfigs[0], EGL10.EGL_NO_CONTEXT, this.mContextAttribs);
            this.mThreadEGLContext.set(eglContext);
        }
        return eglContext;
    }
}

