/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.functor;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import com.hoko.blur.api.IFrameBuffer;
import com.hoko.blur.api.IScreenRenderer;
import com.hoko.blur.api.ITexture;
import com.hoko.blur.opengl.cache.FrameBufferCache;
import com.hoko.blur.opengl.cache.TextureCache;
import com.hoko.blur.opengl.functor.DrawFunctor;
import com.hoko.blur.util.Preconditions;
import com.hoko.blur.util.ShaderUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

public class ScreenBlurRenderer
implements IScreenRenderer {
    private static final String TAG = "ScreenBlurRenderer";
    private static final int DEFAULT_MODE = 1;
    private static final int DEFAULT_BLUR_RADIUS = 5;
    private static final float DEFAULT_SAMPLE_FACTOR = 4.0f;
    private int mRadius = 5;
    private int mMode = 1;
    private float mSampleFactor = 4.0f;
    private float[] mModelMatrix = new float[16];
    private float[] mViewMatrix = new float[16];
    private float[] mProjMatrix = new float[16];
    private float[] mMVPMatrix = new float[16];
    private float[] mScreenMVPMatrix = new float[16];
    private float[] mTexMatrix = new float[16];
    private int mWidth;
    private int mHeight;
    private int mScaleW;
    private int mScaleH;
    private FloatBuffer mVertexBuffer;
    private ShortBuffer mDrawListBuffer;
    private FloatBuffer mTexCoordBuffer;
    private static final int COORDS_PER_VERTEX = 3;
    private float[] squareCoords = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static float[] mTexHorizontalCoords = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private short[] drawOrder = new short[]{0, 1, 2, 2, 3, 1};
    private int mVertexStride = 12;
    private int mBlurProgram;
    private int mCopyProgram;
    private int mPositionId;
    private int mMVPMatrixId;
    private int mTexCoordId;
    private int mTexMatrixId;
    private int mTextureUniformId;
    private ITexture mHorizontalTexture;
    private ITexture mVerticalTexture;
    private ITexture mDisplayTexture;
    private IFrameBuffer mDisplayFrameBuffer;
    private IFrameBuffer mHorizontalFrameBuffer;
    private IFrameBuffer mVerticalFrameBuffer;
    private boolean mHasEGLContext = false;
    private boolean mNeedRelink = true;
    private DrawFunctor.GLInfo mInfo;
    private TextureCache mTextureCache = TextureCache.getInstance();
    private FrameBufferCache mFrameBufferCache = FrameBufferCache.getInstance();

    public ScreenBlurRenderer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(this.squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = bb.asFloatBuffer();
        this.mVertexBuffer.put(this.squareCoords);
        this.mVertexBuffer.position(0);
        ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        this.mDrawListBuffer = dlb.asShortBuffer();
        this.mDrawListBuffer.put(this.drawOrder);
        this.mDrawListBuffer.position(0);
        ByteBuffer tcb = ByteBuffer.allocateDirect(mTexHorizontalCoords.length * 4);
        tcb.order(ByteOrder.nativeOrder());
        this.mTexCoordBuffer = tcb.asFloatBuffer();
        this.mTexCoordBuffer.put(mTexHorizontalCoords);
        this.mTexCoordBuffer.position(0);
    }

    @Override
    public void onDrawFrame(DrawFunctor.GLInfo info) {
        this.mInfo = info;
        this.mWidth = info.clipRight - info.clipLeft;
        this.mHeight = info.clipBottom - info.clipTop;
        this.mScaleW = (int)((float)this.mWidth / this.mSampleFactor);
        this.mScaleH = (int)((float)this.mHeight / this.mSampleFactor);
        if (this.mWidth <= 0 || this.mHeight <= 0 || this.mScaleW <= 0 || this.mScaleH <= 0) {
            return;
        }
        if (!this.prepare()) {
            Log.e((String)TAG, (String)"onDrawFrame: prepare");
            return;
        }
        if (this.mRadius > 0) {
            this.copyTextureFromScreen(this.mInfo);
            this.getTexMatrix(false);
            this.drawOneDimenBlur(this.mMVPMatrix, this.mTexMatrix, true);
            this.drawOneDimenBlur(this.mMVPMatrix, this.mTexMatrix, false);
            this.getTexMatrix(true);
            this.upscale(this.mScreenMVPMatrix, this.mTexMatrix);
        }
        this.onPostBlur();
    }

    @Override
    public void onSurfaceCreated() {
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
    }

    private boolean checkBlurSize(int width, int height) {
        return width <= 1800 && height <= 3200;
    }

    private boolean prepare() {
        if (!this.mHasEGLContext) {
            EGLContext context = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
            if (context.equals(EGL10.EGL_NO_CONTEXT)) {
                Log.e((String)TAG, (String)"This thread is no EGLContext.");
                return false;
            }
            GLES20.glClear((int)16384);
            this.mHasEGLContext = true;
        }
        Preconditions.checkArgument(this.checkBlurSize(this.mWidth, this.mHeight), "Too large blurred sizes");
        this.initMVPMatrix(this.mInfo);
        if (this.mNeedRelink) {
            this.deletePrograms();
            this.mBlurProgram = ShaderUtil.createProgram(ShaderUtil.getVertexCode(), ShaderUtil.getFragmentShaderCode(this.mMode));
            this.mCopyProgram = ShaderUtil.createProgram(ShaderUtil.getVertexCode(), ShaderUtil.getCopyFragmentCode());
            this.mNeedRelink = false;
        }
        if (this.mBlurProgram == 0 || this.mCopyProgram == 0) {
            return false;
        }
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLES20.glDisable((int)3089);
        this.mDisplayTexture = this.mTextureCache.getTexture(this.mWidth, this.mHeight);
        this.mHorizontalTexture = this.mTextureCache.getTexture(this.mScaleW, this.mScaleH);
        this.mVerticalTexture = this.mTextureCache.getTexture(this.mScaleW, this.mScaleH);
        this.mDisplayFrameBuffer = this.mFrameBufferCache.getDisplayFrameBuffer();
        this.mHorizontalFrameBuffer = this.mFrameBufferCache.getFrameBuffer();
        this.mVerticalFrameBuffer = this.mFrameBufferCache.getFrameBuffer();
        if (this.mHorizontalFrameBuffer != null) {
            this.mHorizontalFrameBuffer.bindTexture(this.mHorizontalTexture);
        }
        if (this.mVerticalFrameBuffer != null) {
            this.mVerticalFrameBuffer.bindTexture(this.mVerticalTexture);
        }
        return ShaderUtil.checkGLError("Prepare to blurring");
    }

    private void initMVPMatrix(DrawFunctor.GLInfo info) {
        if (info == null) {
            return;
        }
        Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mProjMatrix, (int)0);
        Matrix.scaleM((float[])this.mModelMatrix, (int)0, (float)this.mScaleW, (float)this.mScaleH, (float)1.0f);
        Matrix.orthoM((float[])this.mProjMatrix, (int)0, (float)0.0f, (float)this.mScaleW, (float)0.0f, (float)this.mScaleH, (float)-100.0f, (float)100.0f);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mModelMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mProjMatrix, (int)0, (float[])this.mMVPMatrix, (int)0);
        System.arraycopy(info.transform, 0, this.mModelMatrix, 0, 16);
        Matrix.scaleM((float[])this.mModelMatrix, (int)0, (float)this.mWidth, (float)this.mHeight, (float)1.0f);
        Matrix.setIdentityM((float[])this.mProjMatrix, (int)0);
        Matrix.orthoM((float[])this.mProjMatrix, (int)0, (float)0.0f, (float)info.viewportWidth, (float)info.viewportHeight, (float)0.0f, (float)-100.0f, (float)100.0f);
        Matrix.multiplyMM((float[])this.mScreenMVPMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mModelMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mScreenMVPMatrix, (int)0, (float[])this.mProjMatrix, (int)0, (float[])this.mScreenMVPMatrix, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOneDimenBlur(float[] mvpMatrix, float[] texMatrix, boolean isHorizontal) {
        try {
            GLES20.glViewport((int)0, (int)0, (int)this.mScaleW, (int)this.mScaleH);
            GLES20.glUseProgram((int)this.mBlurProgram);
            this.mPositionId = GLES20.glGetAttribLocation((int)this.mBlurProgram, (String)"aPosition");
            GLES20.glEnableVertexAttribArray((int)this.mPositionId);
            GLES20.glVertexAttribPointer((int)this.mPositionId, (int)3, (int)5126, (boolean)false, (int)this.mVertexStride, (Buffer)this.mVertexBuffer);
            this.mMVPMatrixId = GLES20.glGetUniformLocation((int)this.mBlurProgram, (String)"uMVPMatrix");
            GLES20.glUniformMatrix4fv((int)this.mMVPMatrixId, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
            this.mTexMatrixId = GLES20.glGetUniformLocation((int)this.mBlurProgram, (String)"uTexMatrix");
            GLES20.glUniformMatrix4fv((int)this.mTexMatrixId, (int)1, (boolean)false, (float[])texMatrix, (int)0);
            this.mTexCoordId = GLES20.glGetAttribLocation((int)this.mBlurProgram, (String)"aTexCoord");
            GLES20.glEnableVertexAttribArray((int)this.mTexCoordId);
            GLES20.glVertexAttribPointer((int)this.mTexCoordId, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mTexCoordBuffer);
            if (isHorizontal) {
                this.mHorizontalFrameBuffer.bindSelf();
            } else {
                this.mVerticalFrameBuffer.bindSelf();
            }
            this.mTextureUniformId = GLES20.glGetUniformLocation((int)this.mBlurProgram, (String)"uTexture");
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)(isHorizontal ? this.mDisplayTexture.id() : this.mHorizontalTexture.id()));
            GLES20.glUniform1i((int)this.mTextureUniformId, (int)0);
            int radiusId = GLES20.glGetUniformLocation((int)this.mBlurProgram, (String)"uRadius");
            int widthOffsetId = GLES20.glGetUniformLocation((int)this.mBlurProgram, (String)"uWidthOffset");
            int heightOffsetId = GLES20.glGetUniformLocation((int)this.mBlurProgram, (String)"uHeightOffset");
            GLES20.glUniform1i((int)radiusId, (int)this.mRadius);
            GLES20.glUniform1f((int)widthOffsetId, (float)(isHorizontal ? 1.0f / (float)this.mWidth * this.mSampleFactor : 0.0f));
            GLES20.glUniform1f((int)heightOffsetId, (float)(isHorizontal ? 0.0f : 1.0f / (float)this.mHeight * this.mSampleFactor));
            GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.mDrawListBuffer);
        }
        finally {
            this.resetAllBuffer();
        }
    }

    private void upscale(float[] mvpMatrix, float[] texMatrix) {
        GLES20.glViewport((int)0, (int)0, (int)this.mInfo.viewportWidth, (int)this.mInfo.viewportHeight);
        GLES20.glUseProgram((int)this.mCopyProgram);
        this.mPositionId = GLES20.glGetAttribLocation((int)this.mCopyProgram, (String)"aPosition");
        GLES20.glEnableVertexAttribArray((int)this.mPositionId);
        GLES20.glVertexAttribPointer((int)this.mPositionId, (int)3, (int)5126, (boolean)false, (int)this.mVertexStride, (Buffer)this.mVertexBuffer);
        this.mMVPMatrixId = GLES20.glGetUniformLocation((int)this.mCopyProgram, (String)"uMVPMatrix");
        GLES20.glUniformMatrix4fv((int)this.mMVPMatrixId, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        this.mTexMatrixId = GLES20.glGetUniformLocation((int)this.mCopyProgram, (String)"uTexMatrix");
        GLES20.glUniformMatrix4fv((int)this.mTexMatrixId, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        this.mTexCoordId = GLES20.glGetAttribLocation((int)this.mCopyProgram, (String)"aTexCoord");
        GLES20.glEnableVertexAttribArray((int)this.mTexCoordId);
        GLES20.glVertexAttribPointer((int)this.mTexCoordId, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mTexCoordBuffer);
        this.mDisplayFrameBuffer.bindSelf();
        this.mTextureUniformId = GLES20.glGetUniformLocation((int)this.mCopyProgram, (String)"uTexture");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mVerticalTexture.id());
        GLES20.glUniform1i((int)this.mTextureUniformId, (int)0);
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.mDrawListBuffer);
        this.resetAllBuffer();
    }

    private void resetAllBuffer() {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        this.mVertexBuffer.rewind();
        this.mTexCoordBuffer.rewind();
        this.mDrawListBuffer.rewind();
    }

    private void getTexMatrix(boolean flipY) {
        Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
        if (flipY) {
            Matrix.translateM((float[])this.mTexMatrix, (int)0, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.scaleM((float[])this.mTexMatrix, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
        } else {
            Matrix.translateM((float[])this.mTexMatrix, (int)0, (float)0.0f, (float)0.0f, (float)0.0f);
            Matrix.scaleM((float[])this.mTexMatrix, (int)0, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void copyTextureFromScreen(DrawFunctor.GLInfo info) {
        if (info != null && this.mDisplayTexture != null && this.mDisplayTexture.id() != 0) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.mDisplayTexture.id());
            GLES20.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)info.clipLeft, (int)(info.viewportHeight - info.clipBottom), (int)this.mWidth, (int)this.mHeight);
        }
    }

    private void onPostBlur() {
        this.mDisplayFrameBuffer.bindSelf();
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glUseProgram((int)0);
        this.mTextureCache.recycleTexture(this.mDisplayTexture);
        this.mTextureCache.recycleTexture(this.mHorizontalTexture);
        this.mTextureCache.recycleTexture(this.mVerticalTexture);
        this.mFrameBufferCache.recycleFrameBuffer(this.mHorizontalFrameBuffer);
        this.mFrameBufferCache.recycleFrameBuffer(this.mVerticalFrameBuffer);
    }

    @Override
    public void free() {
        this.mTextureCache.deleteTextures();
        this.mFrameBufferCache.deleteFrameBuffers();
        GLES20.glDisableVertexAttribArray((int)this.mPositionId);
        GLES20.glDisableVertexAttribArray((int)this.mTexCoordId);
        this.deletePrograms();
        this.mNeedRelink = true;
    }

    private void deletePrograms() {
        if (this.mBlurProgram != 0) {
            GLES20.glDeleteProgram((int)this.mBlurProgram);
        }
        if (this.mCopyProgram != 0) {
            GLES20.glDeleteProgram((int)this.mCopyProgram);
        }
    }

    @Override
    public void mode(int mode) {
        this.mMode = mode;
        this.mNeedRelink = true;
    }

    @Override
    public void radius(int radius) {
        this.mRadius = radius;
    }

    @Override
    public void sampleFactor(float factor) {
        this.mSampleFactor = factor;
    }

    @Override
    public int mode() {
        return this.mMode;
    }

    @Override
    public int radius() {
        return this.mRadius;
    }

    @Override
    public float sampleFactor() {
        return this.mSampleFactor;
    }
}

