/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.functor;

import android.graphics.Canvas;
import android.opengl.Matrix;
import android.os.Build;
import com.hoko.blur.api.IRenderer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;

public class DrawFunctor {
    private long mNativeFunctor = this.createNativeFunctor(new WeakReference<DrawFunctor>(this));
    private IRenderer<GLInfo> mBlurRenderer;

    public DrawFunctor(IRenderer<GLInfo> blurRenderer) {
        this.mBlurRenderer = blurRenderer;
    }

    private static void postEventFromNative(WeakReference<DrawFunctor> functor, GLInfo info, int what) {
        if (functor != null && functor.get() != null) {
            DrawFunctor d = (DrawFunctor)functor.get();
            if (info != null) {
                d.onDraw(info);
            } else {
                d.onInvoke(what);
            }
        }
    }

    public void doDraw(Canvas canvas) {
        if (canvas.isHardwareAccelerated()) {
            try {
                Class<?> canvasClazz = null;
                Method callDrawGLFunctionMethod = null;
                if (Build.VERSION.SDK_INT > 22) {
                    canvasClazz = Class.forName("android.view.DisplayListCanvas");
                    callDrawGLFunctionMethod = canvasClazz.getMethod("callDrawGLFunction2", Long.TYPE);
                    callDrawGLFunctionMethod.setAccessible(true);
                    callDrawGLFunctionMethod.invoke((Object)canvas, this.mNativeFunctor);
                } else if (Build.VERSION.SDK_INT == 21) {
                    canvasClazz = Class.forName("android.view.HardwareCanvas");
                    callDrawGLFunctionMethod = canvasClazz.getMethod("callDrawGLFunction", Long.TYPE);
                    callDrawGLFunctionMethod.setAccessible(true);
                    callDrawGLFunctionMethod.invoke((Object)canvas, this.mNativeFunctor);
                } else if (Build.VERSION.SDK_INT == 22) {
                    canvasClazz = Class.forName("android.view.HardwareCanvas");
                    callDrawGLFunctionMethod = canvasClazz.getMethod("callDrawGLFunction2", Long.TYPE);
                    callDrawGLFunctionMethod.setAccessible(true);
                    callDrawGLFunctionMethod.invoke((Object)canvas, this.mNativeFunctor);
                } else {
                    canvasClazz = Class.forName("android.view.HardwareCanvas");
                    callDrawGLFunctionMethod = canvasClazz.getMethod("callDrawGLFunction", Integer.TYPE);
                    callDrawGLFunctionMethod.setAccessible(true);
                    callDrawGLFunctionMethod.invoke((Object)canvas, (int)this.mNativeFunctor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void onInvoke(int what) {
    }

    private void onDraw(GLInfo info) {
        if (this.mBlurRenderer != null) {
            if (info.transform[12] < (float)info.clipLeft) {
                info.transform[12] = info.clipLeft;
            }
            if (info.transform[13] < (float)info.clipTop) {
                info.transform[13] = info.clipTop;
            }
            this.mBlurRenderer.onDrawFrame(info);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativeFunctor != 0L) {
            this.releaseFunctor(this.mNativeFunctor);
        }
    }

    public IRenderer getRenderer() {
        return this.mBlurRenderer;
    }

    public native long createNativeFunctor(WeakReference<DrawFunctor> var1);

    private native void releaseFunctor(long var1);

    static {
        System.loadLibrary("hoko_blur");
    }

    public static class GLInfo {
        public int clipLeft;
        public int clipTop;
        public int clipRight;
        public int clipBottom;
        public int viewportWidth;
        public int viewportHeight;
        public float[] transform;
        public boolean isLayer;

        public GLInfo() {
            this.transform = new float[16];
            Matrix.setIdentityM((float[])this.transform, (int)0);
        }

        public GLInfo(int width, int height) {
            this.viewportWidth = width;
            this.viewportHeight = height;
        }

        public String toString() {
            return "GLInfo{clipLeft=" + this.clipLeft + ", clipTop=" + this.clipTop + ", clipRight=" + this.clipRight + ", clipBottom=" + this.clipBottom + ", viewportWidth=" + this.viewportWidth + ", viewportHeight=" + this.viewportHeight + ", transform=" + Arrays.toString(this.transform) + ", isLayer=" + this.isLayer + '}';
        }
    }
}

