/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import com.hoko.blur.api.IParams;
import com.hoko.blur.api.IScreenRenderer;
import com.hoko.blur.opengl.functor.DrawFunctor;
import com.hoko.blur.opengl.functor.ScreenBlurRenderer;
import com.hoko.blur.util.BlurUtil;

public class BlurDrawable
extends Drawable
implements IParams {
    private DrawFunctor mDrawFunctor;
    private IScreenRenderer mBlurRenderer = new ScreenBlurRenderer();
    private int alpha;
    private Paint mPaint;
    private boolean mBlurEnabled = true;

    public BlurDrawable() {
        this.mDrawFunctor = new DrawFunctor(this.mBlurRenderer);
        this.mPaint = new Paint();
        this.mPaint.setColor(0);
    }

    public void draw(@NonNull Canvas canvas) {
        if (canvas.isHardwareAccelerated() && this.mBlurEnabled) {
            this.mDrawFunctor.doDraw(canvas);
        } else {
            canvas.drawRect(this.getBounds(), this.mPaint);
        }
    }

    @Deprecated
    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return this.alpha == 255 ? -1 : -3;
    }

    public void disableBlur() {
        this.mBlurEnabled = false;
    }

    public void enableBlur() {
        this.mBlurEnabled = true;
    }

    @Override
    public void mode(int mode) {
        if (this.mBlurRenderer != null) {
            this.mBlurRenderer.mode(mode);
            this.invalidateSelf();
        }
    }

    @Override
    public void radius(int radius) {
        if (this.mBlurRenderer != null) {
            this.mBlurRenderer.radius(BlurUtil.checkRadius(radius));
            this.invalidateSelf();
        }
    }

    @Override
    public void sampleFactor(float factor) {
        if (this.mBlurRenderer != null) {
            this.mBlurRenderer.sampleFactor(factor);
        }
        this.invalidateSelf();
    }

    @Override
    public int mode() {
        if (this.mBlurRenderer != null) {
            return this.mBlurRenderer.mode();
        }
        return 0;
    }

    @Override
    public int radius() {
        if (this.mBlurRenderer != null) {
            return this.mBlurRenderer.radius();
        }
        return 0;
    }

    @Override
    public float sampleFactor() {
        if (this.mBlurRenderer != null) {
            return this.mBlurRenderer.sampleFactor();
        }
        return 1.0f;
    }

    public void freeGLResource() {
        if (this.mBlurRenderer != null) {
            this.mBlurRenderer.free();
        }
    }
}

