/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.cache;

import com.hoko.blur.api.ISize;
import com.hoko.blur.api.ITexture;
import com.hoko.blur.opengl.cache.CachePool;
import com.hoko.blur.opengl.size.Size;
import com.hoko.blur.opengl.texture.TextureFactory;

public class TextureCache {
    private static volatile TextureCache sInstance;
    private CachePool<ISize, ITexture> mCache = new CachePool<ISize, ITexture>(){

        @Override
        protected ITexture create(ISize size) {
            if (size == null) {
                return null;
            }
            return TextureFactory.create(size.width(), size.height());
        }

        @Override
        protected void entryDeleted(ITexture texture) {
            if (texture != null) {
                texture.delete();
            }
        }

        @Override
        protected boolean checkHit(ISize a, ITexture b) {
            return a != null && b != null && a.width() == b.width() && a.height() == b.height();
        }
    };

    private TextureCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextureCache getInstance() {
        if (sInstance != null) return sInstance;
        Class<TextureCache> clazz = TextureCache.class;
        synchronized (TextureCache.class) {
            if (sInstance != null) return sInstance;
            sInstance = new TextureCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public ITexture getTexture(int width, int height) {
        if (this.mCache != null) {
            return this.mCache.get(new Size(width, height));
        }
        return null;
    }

    public void recycleTexture(ITexture texture) {
        if (texture != null) {
            this.mCache.put(texture);
        }
    }

    public void deleteTextures() {
        if (this.mCache != null) {
            this.mCache.evictAll();
        }
    }
}

