/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.cache;

import com.hoko.blur.api.IFrameBuffer;
import com.hoko.blur.opengl.cache.CachePool;
import com.hoko.blur.opengl.framebuffer.FrameBufferFactory;

public class FrameBufferCache {
    private static volatile FrameBufferCache sInstance;
    private CachePool<Object, IFrameBuffer> mCache = new CachePool<Object, IFrameBuffer>(){

        @Override
        protected IFrameBuffer create(Object key) {
            return FrameBufferFactory.create();
        }

        @Override
        protected boolean checkHit(Object a, IFrameBuffer b) {
            return true;
        }

        @Override
        protected void entryDeleted(IFrameBuffer frameBuffer) {
            if (frameBuffer != null) {
                frameBuffer.delete();
            }
        }
    };
    private IFrameBuffer sDisplayFrameBuffer;

    private FrameBufferCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FrameBufferCache getInstance() {
        if (sInstance != null) return sInstance;
        Class<FrameBufferCache> clazz = FrameBufferCache.class;
        synchronized (FrameBufferCache.class) {
            if (sInstance != null) return sInstance;
            sInstance = new FrameBufferCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public IFrameBuffer getFrameBuffer() {
        if (this.mCache != null) {
            return this.mCache.get(new Object());
        }
        return null;
    }

    public IFrameBuffer getDisplayFrameBuffer() {
        if (this.sDisplayFrameBuffer == null) {
            this.sDisplayFrameBuffer = FrameBufferFactory.getDisplayFrameBuffer();
        }
        return this.sDisplayFrameBuffer;
    }

    public void recycleFrameBuffer(IFrameBuffer frameBuffer) {
        if (frameBuffer != null) {
            this.mCache.put(frameBuffer);
        }
    }

    public void deleteFrameBuffers() {
        if (this.mCache != null) {
            this.mCache.evictAll();
        }
        if (this.sDisplayFrameBuffer != null) {
            this.sDisplayFrameBuffer.delete();
            this.sDisplayFrameBuffer = null;
        }
    }
}

