/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.cache;

import com.hoko.blur.util.Preconditions;
import java.util.LinkedList;

public abstract class CachePool<K, T extends K> {
    private static final int MAX_SIZE = 1024;
    private int mMaxSize;
    private LinkedList<T> mList;

    public CachePool() {
        this(1024);
    }

    public CachePool(int maxSize) {
        Preconditions.checkArgument(maxSize > 0, "maxSize <= 0");
        this.mMaxSize = maxSize;
        this.mList = new LinkedList();
    }

    public final T get(K key) {
        Preconditions.checkNotNull(key, "size == null");
        T listValue = this.remove(key);
        if (listValue != null) {
            return listValue;
        }
        return this.create(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(T t) {
        Preconditions.checkNotNull(t, "value == null");
        CachePool cachePool = this;
        synchronized (cachePool) {
            this.mList.add(t);
        }
        this.trimToSize(this.mMaxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T remove(K key) {
        Preconditions.checkNotNull(key, "key == null");
        T previous = null;
        CachePool cachePool = this;
        synchronized (cachePool) {
            for (Object t : this.mList) {
                if (!this.checkHit(key, t)) continue;
                previous = this.mList.remove(this.mList.indexOf(t));
                break;
            }
        }
        return previous;
    }

    public void delete(K key) {
        Preconditions.checkNotNull(key, "key == null");
        T removed = this.remove(key);
        if (removed != null) {
            this.entryDeleted(removed);
        }
    }

    protected T create(K key) {
        return null;
    }

    protected void entryDeleted(T t) {
    }

    protected abstract boolean checkHit(K var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int maxSize) {
        while (true) {
            CachePool cachePool = this;
            synchronized (cachePool) {
                if (this.mList.size() <= maxSize || this.mList.isEmpty()) {
                    break;
                }
                T removed = this.mList.removeFirst();
                if (removed != null) {
                    this.entryDeleted(removed);
                }
            }
        }
    }

    public final synchronized int maxSize() {
        return this.mMaxSize;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }
}

