/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.filter;

import com.hoko.blur.util.BlurUtil;

final class GaussianBlurFilter {
    GaussianBlurFilter() {
    }

    static void doBlur(int[] in, int width, int height, int radius, int direction) {
        int[] result = new int[width * height];
        float[] kernel = GaussianBlurFilter.makeKernel(radius);
        if (direction == 0) {
            GaussianBlurFilter.gaussianBlurHorizontal(kernel, in, result, width, height);
            System.arraycopy(result, 0, in, 0, result.length);
        } else if (direction == 1) {
            GaussianBlurFilter.gaussianBlurVertical(kernel, in, result, width, height);
            System.arraycopy(result, 0, in, 0, result.length);
        } else {
            GaussianBlurFilter.gaussianBlurHorizontal(kernel, in, result, width, height);
            GaussianBlurFilter.gaussianBlurVertical(kernel, result, in, width, height);
        }
    }

    private static void gaussianBlurHorizontal(float[] kernel, int[] inPixels, int[] outPixels, int width, int height) {
        int cols = kernel.length;
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            int ioffset = y * width;
            for (int x = 0; x < width; ++x) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                int moffset = cols2;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f = kernel[moffset + col];
                    if (f == 0.0f) continue;
                    int ix = x + col;
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= width) {
                        ix = width - 1;
                    }
                    int rgb = inPixels[ioffset + ix];
                    r += f * (float)(rgb >> 16 & 0xFF);
                    g += f * (float)(rgb >> 8 & 0xFF);
                    b += f * (float)(rgb & 0xFF);
                }
                int outIndex = ioffset + x;
                int ia = inPixels[outIndex] >> 24 & 0xFF;
                int ir = BlurUtil.clamp((int)((double)r + 0.5), 0, 255);
                int ig = BlurUtil.clamp((int)((double)g + 0.5), 0, 255);
                int ib = BlurUtil.clamp((int)((double)b + 0.5), 0, 255);
                outPixels[outIndex] = ia << 24 | ir << 16 | ig << 8 | ib;
            }
        }
    }

    private static void gaussianBlurVertical(float[] kernel, int[] inPixels, int[] outPixels, int width, int height) {
        int cols = kernel.length;
        int cols2 = cols / 2;
        for (int x = 0; x < width; ++x) {
            int ioffset = x;
            for (int y = 0; y < height; ++y) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                int moffset = cols2;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f = kernel[moffset + col];
                    if (f == 0.0f) continue;
                    int iy = y + col;
                    if (iy < 0) {
                        iy = 0;
                    } else if (iy >= height) {
                        iy = height - 1;
                    }
                    int rgb = inPixels[ioffset + iy * width];
                    r += f * (float)(rgb >> 16 & 0xFF);
                    g += f * (float)(rgb >> 8 & 0xFF);
                    b += f * (float)(rgb & 0xFF);
                }
                int outIndex = ioffset + y * width;
                int ia = inPixels[outIndex] >> 24 & 0xFF;
                int ir = BlurUtil.clamp((int)((double)r + 0.5), 0, 255);
                int ig = BlurUtil.clamp((int)((double)g + 0.5), 0, 255);
                int ib = BlurUtil.clamp((int)((double)b + 0.5), 0, 255);
                outPixels[outIndex] = ia << 24 | ir << 16 | ig << 8 | ib;
            }
        }
    }

    private static float[] makeKernel(int r) {
        int rows = r * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = (float)(r + 1) / 2.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float total = 0.0f;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            matrix[index] = (float)(Math.exp((float)(-1 * (row * row)) / sigma22) / (double)sigma);
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return matrix;
    }
}

