/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.filter;

import com.hoko.blur.util.BlurUtil;

final class BoxBlurFilter {
    BoxBlurFilter() {
    }

    static void doBlur(int[] in, int width, int height, int radius, int round) {
        int[] result = new int[width * height];
        if (round == 0) {
            BoxBlurFilter.boxBlurHorizontal(in, result, width, height, radius);
            System.arraycopy(result, 0, in, 0, result.length);
        } else if (round == 1) {
            BoxBlurFilter.boxBlurVertical(in, result, width, height, radius);
            System.arraycopy(result, 0, in, 0, result.length);
        } else {
            BoxBlurFilter.boxBlurHorizontal(in, result, width, height, radius);
            BoxBlurFilter.boxBlurVertical(result, in, width, height, radius);
        }
    }

    private static void boxBlurHorizontal(int[] in, int[] out, int width, int height, int radius) {
        int widthMinus1 = width - 1;
        int tableSize = 2 * radius + 1;
        int[] divide = new int[256 * tableSize];
        for (int i = 0; i < 256 * tableSize; ++i) {
            divide[i] = i / tableSize;
        }
        int inIndex = 0;
        for (int y = 0; y < height; ++y) {
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int i = -radius; i <= radius; ++i) {
                int rgb = in[inIndex + BlurUtil.clamp(i, 0, width - 1)];
                ta += rgb >> 24 & 0xFF;
                tr += rgb >> 16 & 0xFF;
                tg += rgb >> 8 & 0xFF;
                tb += rgb & 0xFF;
            }
            int baseIndex = y * width;
            for (int x = 0; x < width; ++x) {
                int i2;
                out[baseIndex + x] = divide[ta] << 24 | divide[tr] << 16 | divide[tg] << 8 | divide[tb];
                int i1 = x + radius + 1;
                if (i1 > widthMinus1) {
                    i1 = widthMinus1;
                }
                if ((i2 = x - radius) < 0) {
                    i2 = 0;
                }
                int rgb1 = in[inIndex + i1];
                int rgb2 = in[inIndex + i2];
                ta += (rgb1 >> 24 & 0xFF) - (rgb2 >> 24 & 0xFF);
                tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
                tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
                tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
            }
            inIndex += width;
        }
    }

    private static void boxBlurVertical(int[] in, int[] out, int width, int height, int radius) {
        int heightMinus1 = height - 1;
        int tableSize = 2 * radius + 1;
        int[] divide = new int[256 * tableSize];
        for (int i = 0; i < 256 * tableSize; ++i) {
            divide[i] = i / tableSize;
        }
        for (int x = 0; x < width; ++x) {
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int i = -radius; i <= radius; ++i) {
                int rgb = in[x + BlurUtil.clamp(i, 0, height - 1) * width];
                ta += rgb >> 24 & 0xFF;
                tr += rgb >> 16 & 0xFF;
                tg += rgb >> 8 & 0xFF;
                tb += rgb & 0xFF;
            }
            for (int y = 0; y < height; ++y) {
                int i2;
                out[y * width + x] = divide[ta] << 24 | divide[tr] << 16 | divide[tg] << 8 | divide[tb];
                int i1 = y + radius + 1;
                if (i1 > heightMinus1) {
                    i1 = heightMinus1;
                }
                if ((i2 = y - radius) < 0) {
                    i2 = 0;
                }
                int rgb1 = in[x + i1 * width];
                int rgb2 = in[x + i2 * width];
                ta += (rgb1 >> 24 & 0xFF) - (rgb2 >> 24 & 0xFF);
                tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
                tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
                tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
            }
        }
    }
}

